/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.bedrock.util;

import com.hivemc.chunker.conversion.intermediate.column.ChunkerColumn;
import com.hivemc.chunker.conversion.intermediate.column.chunk.ChunkerChunk;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.ChunkerBlockIdentifier;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.states.vanilla.VanillaBlockStates;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectMap;
import it.unimi.dsi.fastutil.objects.ObjectBidirectionalIterator;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.OptionalInt;

public class ColumnUtil {
    public static OptionalInt getHighestLitOrSlabBlock(ChunkerColumn column, int x, int z) {
        ObjectSet chunkSet = column.getChunks().byte2ObjectEntrySet();
        if (chunkSet.isEmpty()) {
            return OptionalInt.empty();
        }
        ObjectBidirectionalIterator<Byte2ObjectMap.Entry> iterator = chunkSet.iterator((Byte2ObjectMap.Entry)chunkSet.last());
        while (iterator.hasPrevious()) {
            ChunkerChunk chunk = (ChunkerChunk)((Byte2ObjectMap.Entry)iterator.previous()).getValue();
            if (chunk.isEmpty()) continue;
            byte[][][] blockLight = chunk.getBlockLight();
            byte[][][] skyLight = chunk.getSkyLight();
            for (int y = 15; y >= 0; --y) {
                boolean litOrSlab;
                ChunkerBlockIdentifier identifier = chunk.getPalette().get(x, y, z, ChunkerBlockIdentifier.AIR);
                if (identifier.isAir()) continue;
                int light = (blockLight == null ? 0 : blockLight[x][y][z]) + (skyLight == null ? 0 : skyLight[x][y][z]);
                boolean bl = litOrSlab = light != 0 || identifier.getType().getStates().contains(VanillaBlockStates.SLAB_TYPE);
                if (!litOrSlab) continue;
                return OptionalInt.of(chunk.getY() << 4 | y);
            }
        }
        return OptionalInt.empty();
    }
}

