/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.bedrock.base.writer;

import com.hivemc.chunker.conversion.encoding.base.Converter;
import com.hivemc.chunker.conversion.encoding.base.Version;
import com.hivemc.chunker.conversion.encoding.base.writer.LevelWriter;
import com.hivemc.chunker.conversion.encoding.base.writer.WorldWriter;
import com.hivemc.chunker.conversion.encoding.bedrock.base.BedrockReaderWriter;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.BedrockResolvers;
import com.hivemc.chunker.conversion.encoding.bedrock.base.writer.BedrockWorldWriter;
import com.hivemc.chunker.conversion.encoding.bedrock.util.LevelDBKey;
import com.hivemc.chunker.conversion.handlers.pretransform.manager.PreTransformManager;
import com.hivemc.chunker.conversion.intermediate.column.chunk.ChunkCoordPair;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.ChunkerBlockIdentifier;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.ChunkerItemStack;
import com.hivemc.chunker.conversion.intermediate.level.ChunkerGeneratorType;
import com.hivemc.chunker.conversion.intermediate.level.ChunkerLevel;
import com.hivemc.chunker.conversion.intermediate.level.ChunkerLevelPlayer;
import com.hivemc.chunker.conversion.intermediate.level.ChunkerLevelSettings;
import com.hivemc.chunker.conversion.intermediate.level.ChunkerPortal;
import com.hivemc.chunker.conversion.intermediate.level.map.ChunkerMap;
import com.hivemc.chunker.conversion.intermediate.world.Dimension;
import com.hivemc.chunker.nbt.TagType;
import com.hivemc.chunker.nbt.tags.Tag;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import com.hivemc.chunker.nbt.tags.collection.ListTag;
import com.hivemc.chunker.nbt.tags.primitive.IntTag;
import com.hivemc.chunker.scheduling.task.Task;
import com.hivemc.chunker.scheduling.task.TaskWeight;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectMap;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.iq80.leveldb.CompressionType;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.DBIterator;
import org.iq80.leveldb.Options;
import org.iq80.leveldb.WriteBatch;
import org.iq80.leveldb.impl.Iq80DBFactory;
import org.iq80.leveldb.table.BloomFilterPolicy;
import org.jetbrains.annotations.Nullable;

public class BedrockLevelWriter
implements LevelWriter,
BedrockReaderWriter {
    public static final String VOID_WORD_STRING = "{ \"biome_id\" : 1, \"block_layers\" : [{\"block_data\" : 0, \"block_name\" : \"minecraft:air\", \"count\" : 1 }], \"encoding_version\" : 4,  \"structure_options\" : null}";
    protected final File outputFolder;
    protected final Version version;
    protected final Converter converter;
    protected final BedrockResolvers resolvers;
    protected DB database;

    public BedrockLevelWriter(File outputFolder, Version version, Converter converter) {
        this.outputFolder = outputFolder;
        this.version = version;
        this.converter = converter;
        this.resolvers = this.buildResolvers(converter).build();
    }

    protected void openDatabase() throws IOException {
        File databaseDirectory = new File(this.outputFolder, "db");
        databaseDirectory.mkdirs();
        new File(databaseDirectory, "LOCK").delete();
        Options options = new Options();
        options.compressionType(CompressionType.ZLIB_RAW);
        options.blockSize(163840);
        options.filterPolicy(new BloomFilterPolicy(10));
        options.writeBufferSize(0x19000000);
        options.createIfMissing(true);
        Iq80DBFactory factory = new Iq80DBFactory();
        this.database = factory.open(databaseDirectory, options);
        if (this.converter.shouldAllowNBTCopying()) {
            this.remapExistingDB();
        }
    }

    protected void remapExistingDB() throws IOException {
        ArrayList<byte[]> removals = new ArrayList<byte[]>();
        try (DBIterator iterator = this.database.iterator();){
            while (iterator.hasNext()) {
                int dimensionID;
                boolean containsDimension;
                Map.Entry entry = (Map.Entry)iterator.next();
                byte[] key = (byte[])entry.getKey();
                int keyLength = key.length;
                boolean containsSubChunk = keyLength == 14 || keyLength == 10;
                boolean bl = containsDimension = keyLength == 14 || keyLength == 13;
                if (keyLength != 9 && !containsSubChunk && !containsDimension || Arrays.equals(key, LevelDBKey.LOCAL_PLAYER)) continue;
                ByteBuffer buffer = ByteBuffer.wrap(key).order(ByteOrder.LITTLE_ENDIAN);
                int x = buffer.getInt();
                int z = buffer.getInt();
                Dimension dimension = Dimension.OVERWORLD;
                if (containsDimension && (dimension = Dimension.fromBedrock((byte)(dimensionID = buffer.getInt()), null)) == null) {
                    this.converter.logNonFatalException(new Exception("Unknown dimension key " + dimensionID));
                    removals.add(key);
                    continue;
                }
                byte subChunkY = 0;
                if (containsSubChunk) {
                    subChunkY = buffer.get();
                }
                byte type = buffer.get();
                Optional<Dimension> newDimension = this.converter.getNewDimension(dimension);
                ChunkCoordPair chunkCoordPair = new ChunkCoordPair(x, z);
                if (newDimension.isPresent() && this.converter.shouldProcessColumn(dimension, chunkCoordPair)) {
                    if (newDimension.get() == dimension) continue;
                    byte[] value = (byte[])entry.getValue();
                    removals.add(key);
                    if (containsSubChunk) {
                        this.database.put(LevelDBKey.key(newDimension.get(), chunkCoordPair, subChunkY, type), value);
                        continue;
                    }
                    this.database.put(LevelDBKey.key(newDimension.get(), chunkCoordPair, type), value);
                    continue;
                }
                removals.add(key);
            }
        }
        try (WriteBatch writeBatch = this.database.createWriteBatch();){
            for (byte[] key : removals) {
                writeBatch.delete(key);
            }
            this.database.write(writeBatch);
            removals.clear();
        }
    }

    @Override
    public void free() throws Exception {
        if (this.database != null) {
            try {
                this.database.close();
            }
            finally {
                this.database = null;
            }
        }
    }

    @Override
    public void flushLevel() {
        if (this.converter.shouldLevelDBCompaction()) {
            Task.signal("signal_compaction", true);
            this.database.compactRange(null, null);
            Task.signal("signal_compaction", false);
        }
    }

    @Override
    public WorldWriter writeLevel(ChunkerLevel chunkerLevel) throws Exception {
        this.openDatabase();
        Task.asyncConsume("Writing Level Data", TaskWeight.NORMAL, this::writeLevelData, chunkerLevel);
        return this.createWorldWriter();
    }

    protected void writeLevelData(ChunkerLevel chunkerLevel) {
        Task.asyncConsume("Writing Level Settings", TaskWeight.NORMAL, this::writeLevelSettings, chunkerLevel);
        Task.asyncConsume("Writing Local Player", TaskWeight.NORMAL, this::writeLocalPlayer, chunkerLevel);
        Task.asyncConsume("Writing Saved Maps", TaskWeight.NORMAL, this::writeMaps, chunkerLevel);
        Task.asyncConsume("Writing Portals", TaskWeight.NORMAL, this::writePortals, chunkerLevel);
    }

    protected void writeMaps(ChunkerLevel chunkerLevel) {
        if (chunkerLevel.getMaps().isEmpty()) {
            return;
        }
        Task.asyncConsumeForEach("Writing Saved Map", TaskWeight.NORMAL, this::writeMap, chunkerLevel.getMaps());
    }

    protected CompoundTag prepareMap(ChunkerMap chunkerMap) throws Exception {
        CompoundTag mapData = chunkerMap.getOriginalNBT() != null ? chunkerMap.getOriginalNBT() : new CompoundTag(12);
        mapData.put("mapId", chunkerMap.getId());
        if (!mapData.contains("parentMapId")) {
            mapData.put("parentMapId", -1L);
        }
        if (!mapData.contains("decorations")) {
            mapData.put("decorations", new ListTag(TagType.COMPOUND));
        }
        mapData.put("scale", mapData.getLong("parentMapId", -1L) == -1L ? (byte)4 : (byte)chunkerMap.getScale());
        mapData.put("dimension", chunkerMap.getDimension().getBedrockID());
        mapData.put("width", (short)chunkerMap.getWidth());
        mapData.put("height", (short)chunkerMap.getHeight());
        mapData.put("xCenter", chunkerMap.getXCenter());
        mapData.put("zCenter", chunkerMap.getZCenter());
        mapData.put("unlimitedTracking", chunkerMap.isUnlimitedTracking() ? (byte)1 : 0);
        mapData.put("mapLocked", chunkerMap.isLocked() ? (byte)1 : 0);
        if (chunkerMap.getBytes() != null) {
            mapData.put("colors", chunkerMap.getBytes());
        }
        return mapData;
    }

    protected void writeMap(ChunkerMap chunkerMap) throws Exception {
        CompoundTag mapData = this.prepareMap(chunkerMap);
        byte[] value = Tag.writeBedrockNBT(mapData);
        this.database.put(("map_" + chunkerMap.getId()).getBytes(StandardCharsets.UTF_8), value);
    }

    protected void writePortals(ChunkerLevel chunkerLevel) throws Exception {
        if (chunkerLevel.getPortals().isEmpty()) {
            return;
        }
        CompoundTag entry = new CompoundTag(1);
        ListTag portalRecords = new ListTag(TagType.COMPOUND, chunkerLevel.getPortals().size());
        for (ChunkerPortal portal : chunkerLevel.getPortals()) {
            CompoundTag record = new CompoundTag(7);
            record.put("DimId", (int)portal.getDimension().getBedrockID());
            record.put("Span", portal.getWidth());
            record.put("TpX", portal.getX());
            record.put("TpY", portal.getY());
            record.put("TpZ", portal.getZ());
            record.put("Xa", portal.getXa());
            record.put("Za", portal.getZa());
            portalRecords.add(record);
        }
        entry.put("PortalRecords", portalRecords);
        CompoundTag data = new CompoundTag(1);
        data.put("data", entry);
        byte[] value = Tag.writeBedrockNBT(data);
        this.database.put(LevelDBKey.PORTALS, value);
    }

    @Override
    public void writeCustomLevelSetting(ChunkerLevelSettings chunkerLevelSettings, CompoundTag output, String targetName, Object value) {
        if (targetName.equals("AutumnDrop2025")) {
            return;
        }
        if (targetName.equals("SummerDrop2025")) {
            return;
        }
        if (targetName.equals("WinterDrop2024")) {
            return;
        }
        if (targetName.equals("R21Support")) {
            return;
        }
        if (targetName.equals("R20Support")) {
            return;
        }
        if (targetName.equals("CavesAndCliffs")) {
            return;
        }
        if (targetName.equals("FlatWorldVersion")) {
            output.put("WorldVersion", (Integer)value);
            return;
        }
        if (targetName.equals("RandomSeed")) {
            if (!output.contains("RandomSeed") || (int)output.getLong("RandomSeed") != (int)Long.parseLong((String)value)) {
                output.put("RandomSeed", Long.parseLong((String)value));
            }
            return;
        }
        if (value instanceof ChunkerGeneratorType) {
            ChunkerGeneratorType type = (ChunkerGeneratorType)((Object)value);
            if (!this.converter.shouldAllowNBTCopying() && type == ChunkerGeneratorType.CUSTOM) {
                type = ChunkerGeneratorType.VOID;
            }
            switch (type) {
                case NORMAL: {
                    output.put("Generator", 1);
                    return;
                }
                case FLAT: {
                    output.put("Generator", 2);
                    return;
                }
                case VOID: {
                    output.put("Generator", 2);
                    output.put("FlatWorldLayers", VOID_WORD_STRING);
                    return;
                }
                case CUSTOM: {
                    return;
                }
            }
        }
        throw new IllegalArgumentException("Writing of " + targetName + " is not implemented.");
    }

    protected void enableExperiments(CompoundTag output, String ... experiments) {
        CompoundTag experimentsTag = output.getOrCreateCompound("experiments");
        for (String experiment : experiments) {
            experimentsTag.put(experiment, (byte)1);
        }
        experimentsTag.put("experiments_ever_used", (byte)1);
        experimentsTag.put("saved_with_toggled_experiments", (byte)1);
    }

    protected void writeLevelSettings(ChunkerLevel chunkerLevel) throws Exception {
        int type;
        int y;
        CompoundTag data = chunkerLevel.getOriginalLevelData() == null || !this.converter.shouldAllowNBTCopying() ? new CompoundTag(100) : chunkerLevel.getOriginalLevelData();
        chunkerLevel.getSettings().worldStartCount = 0xFFFFFFFEL;
        chunkerLevel.getSettings().toNBT(data, this, this.converter);
        if (!data.contains("Generator")) {
            data.put("Generator", 2);
        }
        if (!data.contains("StorageVersion")) {
            data.put("StorageVersion", this.resolvers.dataVersion().getStorageVersion());
        }
        if (!data.contains("NetworkVersion")) {
            data.put("NetworkVersion", this.resolvers.dataVersion().getProtocolVersion());
        }
        if (data.contains("SpawnY") && (y = data.getInt("SpawnY")) == -1) {
            data.put("SpawnY", (int)Short.MAX_VALUE);
        }
        if (data.contains("GameType") && ((type = data.getInt("GameType")) == 3 || type == 4 || type == 6)) {
            data.put("GameType", this.getVersion().isGreaterThanOrEqual(1, 18, 30) && this.getVersion().isLessThan(1, 19, 50) ? 6 : 2);
        }
        data.put("LastPlayed", Instant.now().getEpochSecond());
        Version version = this.resolvers.dataVersion().getVersion();
        ListTag<IntTag, Integer> minimumVersion = new ListTag<IntTag, Integer>(TagType.INT, 5);
        minimumVersion.add(new IntTag(version.getMajor()));
        minimumVersion.add(new IntTag(version.getMinor()));
        minimumVersion.add(new IntTag(version.getPatch()));
        minimumVersion.add(new IntTag(0));
        minimumVersion.add(new IntTag(0));
        if (!data.contains("MinimumCompatibleClientVersion")) {
            data.put("MinimumCompatibleClientVersion", minimumVersion);
        }
        if (!data.contains("lastOpenedWithVersion")) {
            data.put("lastOpenedWithVersion", minimumVersion);
        }
        Tag.writeBedrockNBT(new File(this.outputFolder, "level.dat"), this.resolvers.dataVersion().getStorageVersion(), data);
    }

    protected void writeLocalPlayer(ChunkerLevel output) throws Exception {
        if (output.getPlayer() == null || this.converter.shouldAllowNBTCopying()) {
            return;
        }
        ChunkerLevelPlayer player = output.getPlayer();
        CompoundTag playerTag = new CompoundTag(9);
        playerTag.put("Pos", ListTag.fromValues(TagType.FLOAT, List.of(Float.valueOf((float)player.getPositionX()), Float.valueOf((float)player.getPositionY() + 1.62001f), Float.valueOf((float)player.getPositionZ()))));
        playerTag.put("Motion", ListTag.fromValues(TagType.FLOAT, List.of(Float.valueOf((float)player.getMotionX()), Float.valueOf((float)player.getMotionY()), Float.valueOf((float)player.getMotionZ()))));
        playerTag.put("Rotation", ListTag.fromValues(TagType.FLOAT, List.of(Float.valueOf(player.getYaw()), Float.valueOf(player.getPitch()))));
        ListTag items = new ListTag(TagType.COMPOUND, player.getInventory().size());
        for (Byte2ObjectMap.Entry tag : player.getInventory().byte2ObjectEntrySet()) {
            Optional<CompoundTag> item;
            if ((tag.getByteKey() & 0xFF) >= 100 || ((ChunkerItemStack)tag.getValue()).getIdentifier().isAir() || (item = this.resolvers.writeItem((ChunkerItemStack)tag.getValue())).isEmpty()) continue;
            item.get().put("Slot", tag.getByteKey());
            items.add(item.get());
        }
        playerTag.put("Inventory", items);
        ListTag armor = new ListTag(TagType.COMPOUND, 4);
        for (int i = 3; i >= 0; --i) {
            Optional<CompoundTag> item;
            ChunkerItemStack chunkerItemStack = player.getInventory().get((byte)(100 + i));
            if (chunkerItemStack == null) {
                chunkerItemStack = new ChunkerItemStack(ChunkerBlockIdentifier.AIR);
            }
            if ((item = this.resolvers.writeItem(chunkerItemStack)).isEmpty()) continue;
            armor.add(item.get());
        }
        playerTag.put("Armor", armor);
        ListTag offhand = new ListTag(TagType.COMPOUND, 1);
        for (int i = 0; i < 1; ++i) {
            Optional<CompoundTag> item;
            ChunkerItemStack chunkerItemStack = player.getInventory().get((byte)(150 + i));
            if (chunkerItemStack == null) {
                chunkerItemStack = new ChunkerItemStack(ChunkerBlockIdentifier.AIR);
            }
            if ((item = this.resolvers.writeItem(chunkerItemStack)).isEmpty()) continue;
            offhand.add(item.get());
        }
        playerTag.put("Offhand", offhand);
        playerTag.put("DimensionId", (int)player.getDimension().getBedrockID());
        if (player.getGameType() == 3 || player.getGameType() == 4 || player.getGameType() == 6) {
            playerTag.put("PlayerGameMode", this.getVersion().isGreaterThanOrEqual(1, 18, 30) && this.getVersion().isLessThan(1, 19, 50) ? 6 : 2);
        } else {
            playerTag.put("PlayerGameMode", player.getGameType());
        }
        CompoundTag movementAttribute = new CompoundTag(7);
        movementAttribute.put("Base", 0.1f);
        movementAttribute.put("Current", 0.1f);
        movementAttribute.put("DefaultMax", Float.MAX_VALUE);
        movementAttribute.put("DefaultMin", 0.0f);
        movementAttribute.put("Max", Float.MAX_VALUE);
        movementAttribute.put("Min", 0.0f);
        movementAttribute.put("Name", "minecraft:movement");
        playerTag.put("Attributes", new ListTag(TagType.COMPOUND, List.of(movementAttribute)));
        byte[] value = Tag.writeBedrockNBT(playerTag);
        this.database.put(LevelDBKey.LOCAL_PLAYER, value);
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    @Override
    @Nullable
    public PreTransformManager getPreTransformManager() {
        return this.resolvers.preTransformManager();
    }

    public BedrockWorldWriter createWorldWriter() {
        return new BedrockWorldWriter(this.outputFolder, this.converter, this.resolvers, this.database);
    }
}

