/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.bedrock.base.writer;

import com.hivemc.chunker.conversion.encoding.base.Converter;
import com.hivemc.chunker.conversion.encoding.base.writer.ColumnWriter;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.BedrockResolvers;
import com.hivemc.chunker.conversion.encoding.bedrock.base.writer.BedrockChunkWriter;
import com.hivemc.chunker.conversion.encoding.bedrock.base.writer.BedrockWorldWriter;
import com.hivemc.chunker.conversion.encoding.bedrock.util.ColumnUtil;
import com.hivemc.chunker.conversion.encoding.bedrock.util.LevelDBChunkType;
import com.hivemc.chunker.conversion.encoding.bedrock.util.LevelDBKey;
import com.hivemc.chunker.conversion.handlers.pretransform.manager.PreTransformManager;
import com.hivemc.chunker.conversion.intermediate.column.ChunkerColumn;
import com.hivemc.chunker.conversion.intermediate.column.biome.ChunkerBiome;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.BlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.chunk.ChunkerChunk;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.ChunkerBlockIdentifier;
import com.hivemc.chunker.conversion.intermediate.column.entity.Entity;
import com.hivemc.chunker.conversion.intermediate.column.heightmap.BedrockHeightMap;
import com.hivemc.chunker.conversion.intermediate.column.heightmap.HeightMap;
import com.hivemc.chunker.conversion.intermediate.world.Dimension;
import com.hivemc.chunker.mapping.identifier.Identifier;
import com.hivemc.chunker.nbt.io.Writer;
import com.hivemc.chunker.nbt.tags.Tag;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import com.hivemc.chunker.scheduling.task.ProgressiveTask;
import com.hivemc.chunker.scheduling.task.Task;
import com.hivemc.chunker.scheduling.task.TaskWeight;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.WriteBatch;
import org.jetbrains.annotations.Nullable;

public class BedrockColumnWriter
implements ColumnWriter {
    protected final BedrockWorldWriter parent;
    protected final Converter converter;
    protected final BedrockResolvers resolvers;
    protected final DB database;
    protected final Dimension dimension;

    public BedrockColumnWriter(BedrockWorldWriter parent, Converter converter, BedrockResolvers resolvers, DB database, Dimension dimension) {
        this.parent = parent;
        this.converter = converter;
        this.resolvers = resolvers;
        this.database = database;
        this.dimension = dimension;
    }

    @Override
    public void writeColumn(ChunkerColumn chunkerColumn) throws Exception {
        this.preProcessColumn(chunkerColumn);
        chunkerColumn.getChunks().values().forEach(chunk -> chunk.setPalette(chunk.getPalette().compact(ChunkerBlockIdentifier.AIR)));
        ArrayList<ProgressiveTask<Void>> processing = new ArrayList<ProgressiveTask<Void>>(5);
        processing.add(Task.asyncConsume("Writing Metadata", TaskWeight.LOW, this::writeMetadata, chunkerColumn));
        processing.add(Task.asyncConsume("Writing HeightMap/Biomes", TaskWeight.NORMAL, this::writeHeightMapBiomes, chunkerColumn));
        processing.add(Task.asyncConsume("Writing Entities", TaskWeight.HIGH, this::writeEntities, chunkerColumn));
        processing.add(Task.asyncConsume("Writing Block Entities", TaskWeight.HIGH, this::writeBlockEntities, chunkerColumn));
        processing.add(Task.asyncConsume("Writing Chunks", TaskWeight.HIGHER, this::writeChunks, chunkerColumn));
        Task.join(processing).then("Post-processing column", TaskWeight.HIGH, () -> this.postProcessColumn(chunkerColumn));
    }

    @Override
    @Nullable
    public PreTransformManager getPreTransformManager() {
        return this.resolvers.preTransformManager();
    }

    protected void writeMetadata(ChunkerColumn chunkerColumn) throws Exception {
        try (WriteBatch writeBatch = this.database.createWriteBatch();){
            writeBatch.put(LevelDBKey.key(this.dimension, chunkerColumn.getPosition(), LevelDBChunkType.LEGACY_VERSION), new byte[]{7});
            this.database.write(writeBatch);
        }
    }

    protected void preProcessColumn(ChunkerColumn column) {
        for (ChunkerChunk chunk : column.getChunks().values()) {
            this.resolvers.blockEntityResolver().generateBeforeWriteBlockEntities(column, chunk);
            this.resolvers.entityResolver().generateBeforeWriteEntities(column, chunk);
        }
        List<BlockEntity> blockEntities = column.getBlockEntities();
        for (int i = 0; i < blockEntities.size(); ++i) {
            BlockEntity blockEntity2 = blockEntities.get(i);
            BlockEntity replacement = this.resolvers.blockEntityResolver().updateBeforeWrite(column, blockEntity2.getX(), blockEntity2.getY(), blockEntity2.getZ(), blockEntity2);
            if (replacement == blockEntity2) continue;
            blockEntities.set(i, replacement);
        }
        List<Entity> entities = column.getEntities();
        for (int i = 0; i < entities.size(); ++i) {
            Entity entity2 = entities.get(i);
            Entity replacement = this.resolvers.entityResolver().updateBeforeWrite(column, entity2);
            if (replacement == entity2) continue;
            entities.set(i, replacement);
        }
        column.getBlockEntities().removeIf(blockEntity -> this.shouldRemoveBlockEntityBeforeWrite(column, (BlockEntity)blockEntity));
        column.getEntities().removeIf(entity -> this.resolvers.entityResolver().shouldRemoveBeforeWrite(column, entity));
    }

    protected boolean shouldRemoveBlockEntityBeforeWrite(ChunkerColumn column, BlockEntity blockEntity) {
        ChunkerBlockIdentifier blockIdentifier = column.getBlock(blockEntity.getX(), blockEntity.getY(), blockEntity.getZ());
        if (blockIdentifier.isAir()) {
            return true;
        }
        Optional<Identifier> result = this.resolvers.writeBlockIdentifier(blockIdentifier, false);
        if (result.isEmpty() || result.get().getIdentifier().equals("minecraft:air")) {
            return true;
        }
        return this.resolvers.blockEntityResolver().shouldRemoveBeforeWrite(column, blockEntity.getX(), blockEntity.getY(), blockEntity.getZ(), blockEntity);
    }

    protected void postProcessColumn(ChunkerColumn chunkerColumn) {
    }

    protected BedrockHeightMap generateHeightMap(ChunkerColumn column) {
        short[][] heightMap = new short[16][16];
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                short value;
                OptionalInt highest = ColumnUtil.getHighestLitOrSlabBlock(column, x, z);
                heightMap[x][z] = value = (short)(highest.orElse(-1) + 1);
            }
        }
        return new BedrockHeightMap(heightMap);
    }

    protected void writeHeightMapBiomes(ChunkerColumn column) throws Exception {
        byte[] bytes;
        BedrockHeightMap heightMap;
        HeightMap heightMap2 = column.getHeightMap();
        if (!(heightMap2 instanceof BedrockHeightMap)) {
            heightMap = this.generateHeightMap(column);
        } else {
            BedrockHeightMap bedrockHeightMap = (BedrockHeightMap)heightMap2;
            heightMap = bedrockHeightMap;
        }
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
             DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);){
            Writer writer = Writer.toBedrockWriter(dataOutputStream);
            short[][] heightMapValues = heightMap.getHeightMap();
            for (int z = 0; z < 16; ++z) {
                for (int x = 0; x < 16; ++x) {
                    writer.writeShort(heightMapValues[x][z]);
                }
            }
            if (column.getBiomes() != null) {
                ChunkerBiome[] biomes;
                for (ChunkerBiome chunkerBiome : biomes = column.getBiomes().asColumn(this.resolvers.getFallbackBiome(this.dimension))) {
                    writer.writeByte(this.resolvers.writeBiomeID(chunkerBiome, this.dimension));
                }
            } else {
                ChunkerBiome fallbackBiome = this.resolvers.getFallbackBiome(this.dimension);
                for (int i = 0; i < 256; ++i) {
                    writer.writeByte(this.resolvers.writeBiomeID(fallbackBiome, this.dimension));
                }
            }
            bytes = byteArrayOutputStream.toByteArray();
        }
        this.database.put(LevelDBKey.key(this.dimension, column.getPosition(), LevelDBChunkType.DATA_2D), bytes);
    }

    protected void writeEntities(ChunkerColumn column) throws Exception {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);){
            try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
                 DataOutputStream writerStream = new DataOutputStream(bufferedOutputStream);){
                for (Entity entity : column.getEntities()) {
                    try {
                        CompoundTag tag = this.writeEntity(column, entity);
                        if (tag == null) continue;
                        Tag.encodeNamed(Writer.toBedrockWriter(writerStream), "", tag);
                    }
                    catch (Exception e) {
                        this.converter.logNonFatalException(new Exception("Failed to process Entity " + String.valueOf(entity), e));
                    }
                }
            }
            this.database.put(LevelDBKey.key(this.dimension, column.getPosition(), LevelDBChunkType.ENTITY), byteArrayOutputStream.toByteArray());
        }
    }

    @Nullable
    protected CompoundTag writeEntity(ChunkerColumn chunkerColumn, Entity entity) {
        Optional<CompoundTag> compoundTag = this.resolvers.entityResolver().from(entity);
        if (compoundTag.isPresent()) {
            return compoundTag.get();
        }
        this.converter.logMissingMapping(Converter.MissingMappingType.ENTITY, String.valueOf(entity.getEntityType()));
        return null;
    }

    protected void writeBlockEntities(ChunkerColumn column) throws Exception {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(1024);){
            try (BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(byteArrayOutputStream);
                 DataOutputStream writerStream = new DataOutputStream(bufferedOutputStream);){
                for (BlockEntity blockEntity : column.getBlockEntities()) {
                    try {
                        CompoundTag tag = this.writeBlockEntity(column, blockEntity);
                        if (tag == null) continue;
                        Tag.encodeNamed(Writer.toBedrockWriter(writerStream), "", tag);
                    }
                    catch (Exception e) {
                        this.converter.logNonFatalException(new Exception("Failed to process BlockEntity " + String.valueOf(blockEntity), e));
                    }
                }
            }
            this.database.put(LevelDBKey.key(this.dimension, column.getPosition(), LevelDBChunkType.BLOCK_ENTITY), byteArrayOutputStream.toByteArray());
        }
    }

    @Nullable
    protected CompoundTag writeBlockEntity(ChunkerColumn chunkerColumn, BlockEntity blockEntity) {
        Optional<CompoundTag> compoundTag = this.resolvers.blockEntityResolver().from(blockEntity);
        if (compoundTag.isPresent()) {
            return compoundTag.get();
        }
        this.converter.logMissingMapping(Converter.MissingMappingType.BLOCK_ENTITY, blockEntity.getClass().getSimpleName());
        return null;
    }

    protected void writeChunks(ChunkerColumn column) {
        BedrockChunkWriter chunkWriter = this.createChunkWriter(column);
        Task.asyncConsumeForEach("Writing Chunk", TaskWeight.NORMAL, chunkWriter::writeChunk, column.getChunks().values());
    }

    public BedrockChunkWriter createChunkWriter(ChunkerColumn column) {
        return new BedrockChunkWriter(this.converter, this.resolvers, this.database, this.dimension, column);
    }
}

