/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.itemstack;

import com.hivemc.chunker.conversion.encoding.base.Version;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.potion.ChunkerPotionType;
import com.hivemc.chunker.resolver.Resolver;
import com.hivemc.chunker.util.InvertibleMap;
import java.util.Optional;

public class BedrockPotionIDResolver
implements Resolver<Integer, ChunkerPotionType> {
    private final InvertibleMap<ChunkerPotionType, Integer> mapping = InvertibleMap.enumKeys(ChunkerPotionType.class);

    public BedrockPotionIDResolver(Version bedrockVersion) {
        this.mapping.put(ChunkerPotionType.EMPTY, -1);
        this.mapping.put(ChunkerPotionType.WATER, 0);
        this.mapping.put(ChunkerPotionType.MUNDANE, 1);
        this.mapping.put(ChunkerPotionType.LONG_MUNDANE, 2);
        this.mapping.put(ChunkerPotionType.THICK, 3);
        this.mapping.put(ChunkerPotionType.AWKWARD, 4);
        this.mapping.put(ChunkerPotionType.NIGHT_VISION, 5);
        this.mapping.put(ChunkerPotionType.LONG_NIGHT_VISION, 6);
        this.mapping.put(ChunkerPotionType.INVISIBILITY, 7);
        this.mapping.put(ChunkerPotionType.LONG_INVISIBILITY, 8);
        this.mapping.put(ChunkerPotionType.LEAPING, 9);
        this.mapping.put(ChunkerPotionType.LONG_LEAPING, 10);
        this.mapping.put(ChunkerPotionType.STRONG_LEAPING, 11);
        this.mapping.put(ChunkerPotionType.FIRE_RESISTANCE, 12);
        this.mapping.put(ChunkerPotionType.LONG_FIRE_RESISTANCE, 13);
        this.mapping.put(ChunkerPotionType.SWIFTNESS, 14);
        this.mapping.put(ChunkerPotionType.LONG_SWIFTNESS, 15);
        this.mapping.put(ChunkerPotionType.STRONG_SWIFTNESS, 16);
        this.mapping.put(ChunkerPotionType.SLOWNESS, 17);
        this.mapping.put(ChunkerPotionType.LONG_SLOWNESS, 18);
        this.mapping.put(ChunkerPotionType.WATER_BREATHING, 19);
        this.mapping.put(ChunkerPotionType.LONG_WATER_BREATHING, 20);
        this.mapping.put(ChunkerPotionType.HEALING, 21);
        this.mapping.put(ChunkerPotionType.STRONG_HEALING, 22);
        this.mapping.put(ChunkerPotionType.HARMING, 23);
        this.mapping.put(ChunkerPotionType.STRONG_HARMING, 24);
        this.mapping.put(ChunkerPotionType.POISON, 25);
        this.mapping.put(ChunkerPotionType.LONG_POISON, 26);
        this.mapping.put(ChunkerPotionType.STRONG_POISON, 27);
        this.mapping.put(ChunkerPotionType.REGENERATION, 28);
        this.mapping.put(ChunkerPotionType.LONG_REGENERATION, 29);
        this.mapping.put(ChunkerPotionType.STRONG_REGENERATION, 30);
        this.mapping.put(ChunkerPotionType.STRENGTH, 31);
        this.mapping.put(ChunkerPotionType.LONG_STRENGTH, 32);
        this.mapping.put(ChunkerPotionType.STRONG_STRENGTH, 33);
        this.mapping.put(ChunkerPotionType.WEAKNESS, 34);
        this.mapping.put(ChunkerPotionType.LONG_WEAKNESS, 35);
        this.mapping.put(ChunkerPotionType.WITHER, 36);
        this.mapping.put(ChunkerPotionType.TURTLE_MASTER, 37);
        this.mapping.put(ChunkerPotionType.LONG_TURTLE_MASTER, 38);
        this.mapping.put(ChunkerPotionType.STRONG_TURTLE_MASTER, 39);
        this.mapping.put(ChunkerPotionType.SLOW_FALLING, 40);
        this.mapping.put(ChunkerPotionType.LONG_SLOW_FALLING, 41);
        if (bedrockVersion.isGreaterThanOrEqual(1, 16, 0)) {
            this.mapping.put(ChunkerPotionType.STRONG_SLOWNESS, 42);
        }
        if (bedrockVersion.isGreaterThanOrEqual(1, 21, 0)) {
            this.mapping.put(ChunkerPotionType.WIND_CHARGED, 43);
            this.mapping.put(ChunkerPotionType.WEAVING, 44);
            this.mapping.put(ChunkerPotionType.OOZING, 45);
            this.mapping.put(ChunkerPotionType.INFESTED, 46);
        }
    }

    @Override
    public Optional<Integer> from(ChunkerPotionType input) {
        return Optional.ofNullable(this.mapping.forward().get((Object)input));
    }

    @Override
    public Optional<ChunkerPotionType> to(Integer input) {
        return Optional.ofNullable(this.mapping.inverse().get(input));
    }
}

