/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.itemstack;

import com.hivemc.chunker.conversion.encoding.base.Version;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.potion.ChunkerEffectType;
import com.hivemc.chunker.resolver.Resolver;
import com.hivemc.chunker.util.InvertibleMap;
import java.util.Optional;

public class BedrockEffectIDResolver
implements Resolver<Integer, ChunkerEffectType> {
    private final InvertibleMap<ChunkerEffectType, Integer> mapping = InvertibleMap.enumKeys(ChunkerEffectType.class);

    public BedrockEffectIDResolver(Version bedrockVersion) {
        this.mapping.put(ChunkerEffectType.EMPTY, 0);
        this.mapping.put(ChunkerEffectType.SPEED, 1);
        this.mapping.put(ChunkerEffectType.SLOWNESS, 2);
        this.mapping.put(ChunkerEffectType.HASTE, 3);
        this.mapping.put(ChunkerEffectType.MINING_FATIGUE, 4);
        this.mapping.put(ChunkerEffectType.STRENGTH, 5);
        this.mapping.put(ChunkerEffectType.INSTANT_HEALTH, 6);
        this.mapping.put(ChunkerEffectType.INSTANT_DAMAGE, 7);
        this.mapping.put(ChunkerEffectType.JUMP_BOOST, 8);
        this.mapping.put(ChunkerEffectType.NAUSEA, 9);
        this.mapping.put(ChunkerEffectType.REGENERATION, 10);
        this.mapping.put(ChunkerEffectType.RESISTANCE, 11);
        this.mapping.put(ChunkerEffectType.FIRE_RESISTANCE, 12);
        this.mapping.put(ChunkerEffectType.WATER_BREATHING, 13);
        this.mapping.put(ChunkerEffectType.INVISIBILITY, 14);
        this.mapping.put(ChunkerEffectType.BLINDNESS, 15);
        this.mapping.put(ChunkerEffectType.NIGHT_VISION, 16);
        this.mapping.put(ChunkerEffectType.HUNGER, 17);
        this.mapping.put(ChunkerEffectType.WEAKNESS, 18);
        this.mapping.put(ChunkerEffectType.POISON, 19);
        this.mapping.put(ChunkerEffectType.WITHER, 20);
        this.mapping.put(ChunkerEffectType.HEALTH_BOOST, 21);
        this.mapping.put(ChunkerEffectType.ABSORPTION, 22);
        this.mapping.put(ChunkerEffectType.SATURATION, 23);
        this.mapping.put(ChunkerEffectType.LEVITATION, 24);
        this.mapping.put(ChunkerEffectType.FATAL_POISON, 25);
        this.mapping.put(ChunkerEffectType.CONDUIT_POWER, 26);
        this.mapping.put(ChunkerEffectType.SLOW_FALLING, 27);
        this.mapping.put(ChunkerEffectType.BAD_OMEN, 28);
        this.mapping.put(ChunkerEffectType.HERO_OF_THE_VILLAGE, 29);
        if (bedrockVersion.isGreaterThanOrEqual(1, 18, 0)) {
            this.mapping.put(ChunkerEffectType.DARKNESS, 30);
        }
        if (bedrockVersion.isGreaterThanOrEqual(1, 21, 0)) {
            this.mapping.put(ChunkerEffectType.TRIAL_OMEN, 31);
            this.mapping.put(ChunkerEffectType.WIND_CHARGED, 32);
            this.mapping.put(ChunkerEffectType.WEAVING, 33);
            this.mapping.put(ChunkerEffectType.OOZING, 34);
            this.mapping.put(ChunkerEffectType.INFESTED, 35);
            this.mapping.put(ChunkerEffectType.RAID_OMEN, 36);
        }
    }

    @Override
    public Optional<Integer> from(ChunkerEffectType input) {
        return Optional.ofNullable(this.mapping.forward().get((Object)input));
    }

    @Override
    public Optional<ChunkerEffectType> to(Integer input) {
        return Optional.ofNullable(this.mapping.inverse().get(input));
    }
}

