/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.identifier;

import com.google.common.collect.ImmutableMultimap;
import com.hivemc.chunker.conversion.encoding.base.Converter;
import com.hivemc.chunker.conversion.encoding.base.Version;
import com.hivemc.chunker.conversion.encoding.base.resolver.identifier.ChunkerItemIdentifierResolver;
import com.hivemc.chunker.conversion.encoding.base.resolver.identifier.ItemMapping;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.itemstack.BedrockPotionIDResolver;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.ChunkerItemStackIdentifierType;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.ChunkerVanillaBlockType;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.item.ChunkerVanillaItemType;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.ChunkerItemProperty;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.horn.ChunkerHornInstrument;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.potion.ChunkerEffectType;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.potion.ChunkerPotionType;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.stew.ChunkerStewEffect;
import com.hivemc.chunker.conversion.intermediate.column.entity.type.ChunkerVanillaEntityType;
import java.util.Map;

public class BedrockItemIdentifierResolver
extends ChunkerItemIdentifierResolver {
    public BedrockItemIdentifierResolver(Converter converter, Version version, boolean reader) {
        super(converter, version, reader, false);
    }

    @Override
    public void registerMappings(Version version) {
        this.register(ItemMapping.of("minecraft:bucket", ChunkerVanillaItemType.BUCKET));
        this.register(ItemMapping.of("minecraft:redstone", ChunkerVanillaItemType.REDSTONE));
        this.register(ItemMapping.of("minecraft:minecart", ChunkerVanillaItemType.MINECART));
        this.registerDuplicateInput(ItemMapping.of("minecraft:minecart", ChunkerVanillaItemType.FURNACE_MINECART));
        this.register(ItemMapping.of("minecraft:map", ChunkerVanillaItemType.FILLED_MAP));
        this.register(ItemMapping.of("minecraft:fireball", ChunkerVanillaItemType.FIRE_CHARGE));
        this.register(ItemMapping.of("minecraft:frame", ChunkerVanillaItemType.ITEM_FRAME));
        this.register(ItemMapping.of("minecraft:muttonraw", ChunkerVanillaItemType.MUTTON));
        this.register(ItemMapping.of("minecraft:muttoncooked", ChunkerVanillaItemType.COOKED_MUTTON));
        BedrockPotionIDResolver potionIDResolver = new BedrockPotionIDResolver(version);
        this.register(ItemMapping.of("minecraft:arrow", ChunkerVanillaItemType.ARROW));
        this.register(ItemMapping.of("minecraft:arrow", 1, (ChunkerItemStackIdentifierType)ChunkerVanillaItemType.TIPPED_ARROW));
        for (ChunkerPotionType potionType : ChunkerPotionType.values()) {
            int id = potionIDResolver.from(potionType).orElse(-1);
            if (id < 1) continue;
            this.register(ItemMapping.of("minecraft:arrow", id + 1, ChunkerVanillaItemType.TIPPED_ARROW, ChunkerItemProperty.POTION, potionType));
        }
        this.registerDuplicateInput(ItemMapping.of("minecraft:arrow", ChunkerVanillaItemType.SPECTRAL_ARROW));
        Map<String, ChunkerVanillaItemType> potionTypes = Map.of("minecraft:potion", ChunkerVanillaItemType.POTION, "minecraft:splash_potion", ChunkerVanillaItemType.SPLASH_POTION, "minecraft:lingering_potion", ChunkerVanillaItemType.LINGERING_POTION);
        for (Map.Entry<String, ChunkerVanillaItemType> potionBottleType : potionTypes.entrySet()) {
            this.register(ItemMapping.of(potionBottleType.getKey(), potionBottleType.getValue()));
            for (ChunkerPotionType potionType : ChunkerPotionType.values()) {
                int id = potionIDResolver.from(potionType).orElse(-1);
                if (id < 0) continue;
                this.register(ItemMapping.of(potionBottleType.getKey(), id, potionBottleType.getValue(), ChunkerItemProperty.POTION, potionType));
            }
        }
        this.register(ItemMapping.of("minecraft:netherbrick", ChunkerVanillaItemType.NETHER_BRICK));
        this.register(ItemMapping.of("minecraft:totem", ChunkerVanillaItemType.TOTEM_OF_UNDYING));
        this.register(ItemMapping.of("minecraft:netherstar", ChunkerVanillaItemType.NETHER_STAR));
        this.register(ItemMapping.of("minecraft:horsearmoriron", ChunkerVanillaItemType.IRON_HORSE_ARMOR));
        this.register(ItemMapping.of("minecraft:horsearmorgold", ChunkerVanillaItemType.GOLDEN_HORSE_ARMOR));
        this.register(ItemMapping.of("minecraft:horsearmordiamond", ChunkerVanillaItemType.DIAMOND_HORSE_ARMOR));
        this.register(ItemMapping.of("minecraft:carrotonastick", ChunkerVanillaItemType.CARROT_ON_A_STICK));
        this.register(ItemMapping.of("minecraft:shield", ChunkerVanillaItemType.SHIELD));
        this.register(ItemMapping.flatten("minecraft:banner", ImmutableMultimap.builder().put(15, ChunkerVanillaItemType.WHITE_BANNER).put(12, ChunkerVanillaItemType.LIGHT_BLUE_BANNER).put(8, ChunkerVanillaItemType.GRAY_BANNER).put(6, ChunkerVanillaItemType.CYAN_BANNER).put(7, ChunkerVanillaItemType.LIGHT_GRAY_BANNER).put(2, ChunkerVanillaItemType.GREEN_BANNER).put(14, ChunkerVanillaItemType.ORANGE_BANNER).put(11, ChunkerVanillaItemType.YELLOW_BANNER).put(1, ChunkerVanillaItemType.RED_BANNER).put(9, ChunkerVanillaItemType.PINK_BANNER).put(3, ChunkerVanillaItemType.BROWN_BANNER).put(5, ChunkerVanillaItemType.PURPLE_BANNER).put(13, ChunkerVanillaItemType.MAGENTA_BANNER).put(10, ChunkerVanillaItemType.LIME_BANNER).put(4, ChunkerVanillaItemType.BLUE_BANNER).build()));
        this.register(ItemMapping.of("minecraft:banner", ChunkerVanillaItemType.BLACK_BANNER));
        this.register(ItemMapping.flatten("minecraft:bed", ImmutableMultimap.builder().put(1, ChunkerVanillaBlockType.ORANGE_BED).put(2, ChunkerVanillaBlockType.MAGENTA_BED).put(3, ChunkerVanillaBlockType.LIGHT_BLUE_BED).put(4, ChunkerVanillaBlockType.YELLOW_BED).put(5, ChunkerVanillaBlockType.LIME_BED).put(6, ChunkerVanillaBlockType.PINK_BED).put(7, ChunkerVanillaBlockType.GRAY_BED).put(8, ChunkerVanillaBlockType.LIGHT_GRAY_BED).put(9, ChunkerVanillaBlockType.CYAN_BED).put(10, ChunkerVanillaBlockType.PURPLE_BED).put(11, ChunkerVanillaBlockType.BLUE_BED).put(12, ChunkerVanillaBlockType.BROWN_BED).put(13, ChunkerVanillaBlockType.GREEN_BED).put(14, ChunkerVanillaBlockType.RED_BED).put(15, ChunkerVanillaBlockType.BLACK_BED).build()));
        this.register(ItemMapping.of("minecraft:bed", ChunkerVanillaBlockType.WHITE_BED));
        this.registerDuplicateOutput(ItemMapping.of("minecraft:bed", Map.of("direction", 0, "head_piece_bit", false, "occupied_bit", false), (ChunkerItemStackIdentifierType)ChunkerVanillaBlockType.WHITE_BED));
        this.registerDuplicateOutput(ItemMapping.of("minecraft:bed", Map.of("direction", 1, "head_piece_bit", false, "occupied_bit", false), (ChunkerItemStackIdentifierType)ChunkerVanillaBlockType.ORANGE_BED));
        this.registerDuplicateOutput(ItemMapping.of("minecraft:bed", Map.of("direction", 2, "head_piece_bit", false, "occupied_bit", false), (ChunkerItemStackIdentifierType)ChunkerVanillaBlockType.MAGENTA_BED));
        this.registerDuplicateOutput(ItemMapping.of("minecraft:bed", Map.of("direction", 3, "head_piece_bit", false, "occupied_bit", false), (ChunkerItemStackIdentifierType)ChunkerVanillaBlockType.LIGHT_BLUE_BED));
        this.registerDuplicateOutput(ItemMapping.of("minecraft:bed", Map.of("direction", 0, "head_piece_bit", false, "occupied_bit", true), (ChunkerItemStackIdentifierType)ChunkerVanillaBlockType.YELLOW_BED));
        this.registerDuplicateOutput(ItemMapping.of("minecraft:bed", Map.of("direction", 1, "head_piece_bit", false, "occupied_bit", true), (ChunkerItemStackIdentifierType)ChunkerVanillaBlockType.LIME_BED));
        this.registerDuplicateOutput(ItemMapping.of("minecraft:bed", Map.of("direction", 2, "head_piece_bit", false, "occupied_bit", true), (ChunkerItemStackIdentifierType)ChunkerVanillaBlockType.PINK_BED));
        this.registerDuplicateOutput(ItemMapping.of("minecraft:bed", Map.of("direction", 3, "head_piece_bit", false, "occupied_bit", true), (ChunkerItemStackIdentifierType)ChunkerVanillaBlockType.GRAY_BED));
        this.registerDuplicateOutput(ItemMapping.of("minecraft:bed", Map.of("direction", 0, "head_piece_bit", true, "occupied_bit", false), (ChunkerItemStackIdentifierType)ChunkerVanillaBlockType.LIGHT_GRAY_BED));
        this.registerDuplicateOutput(ItemMapping.of("minecraft:bed", Map.of("direction", 1, "head_piece_bit", true, "occupied_bit", false), (ChunkerItemStackIdentifierType)ChunkerVanillaBlockType.CYAN_BED));
        this.registerDuplicateOutput(ItemMapping.of("minecraft:bed", Map.of("direction", 2, "head_piece_bit", true, "occupied_bit", false), (ChunkerItemStackIdentifierType)ChunkerVanillaBlockType.CYAN_BED));
        this.registerDuplicateOutput(ItemMapping.of("minecraft:bed", Map.of("direction", 3, "head_piece_bit", true, "occupied_bit", false), (ChunkerItemStackIdentifierType)ChunkerVanillaBlockType.PURPLE_BED));
        this.registerDuplicateOutput(ItemMapping.of("minecraft:bed", Map.of("direction", 0, "head_piece_bit", true, "occupied_bit", true), (ChunkerItemStackIdentifierType)ChunkerVanillaBlockType.BROWN_BED));
        this.registerDuplicateOutput(ItemMapping.of("minecraft:bed", Map.of("direction", 1, "head_piece_bit", true, "occupied_bit", true), (ChunkerItemStackIdentifierType)ChunkerVanillaBlockType.GREEN_BED));
        this.registerDuplicateOutput(ItemMapping.of("minecraft:bed", Map.of("direction", 2, "head_piece_bit", true, "occupied_bit", true), (ChunkerItemStackIdentifierType)ChunkerVanillaBlockType.RED_BED));
        this.registerDuplicateOutput(ItemMapping.of("minecraft:bed", Map.of("direction", 3, "head_piece_bit", true, "occupied_bit", true), (ChunkerItemStackIdentifierType)ChunkerVanillaBlockType.BLACK_BED));
        this.register(ItemMapping.of("minecraft:sign", ChunkerVanillaItemType.OAK_SIGN));
        this.register(ItemMapping.of("minecraft:darkoak_sign", ChunkerVanillaItemType.DARK_OAK_SIGN));
        this.register(ItemMapping.flatten("minecraft:boat", ImmutableMultimap.builder().put(3, ChunkerVanillaItemType.JUNGLE_BOAT).put(1, ChunkerVanillaItemType.SPRUCE_BOAT).put(5, ChunkerVanillaItemType.DARK_OAK_BOAT).put(2, ChunkerVanillaItemType.BIRCH_BOAT).put(4, ChunkerVanillaItemType.ACACIA_BOAT).build()));
        this.register(ItemMapping.of("minecraft:boat", ChunkerVanillaItemType.OAK_BOAT));
        this.register(ItemMapping.of("minecraft:speckled_melon", ChunkerVanillaItemType.GLISTERING_MELON_SLICE));
        this.register(ItemMapping.of("minecraft:melon", ChunkerVanillaItemType.MELON_SLICE));
        this.register(ItemMapping.flatten("minecraft:dye", ImmutableMultimap.builder().put(1, ChunkerVanillaItemType.RED_DYE).put(2, ChunkerVanillaItemType.GREEN_DYE).put(3, ChunkerVanillaItemType.COCOA_BEANS).put(4, ChunkerVanillaItemType.LAPIS_LAZULI).put(5, ChunkerVanillaItemType.PURPLE_DYE).put(6, ChunkerVanillaItemType.CYAN_DYE).put(7, ChunkerVanillaItemType.LIGHT_GRAY_DYE).put(8, ChunkerVanillaItemType.GRAY_DYE).put(9, ChunkerVanillaItemType.PINK_DYE).put(10, ChunkerVanillaItemType.LIME_DYE).put(11, ChunkerVanillaItemType.YELLOW_DYE).put(12, ChunkerVanillaItemType.LIGHT_BLUE_DYE).put(13, ChunkerVanillaItemType.MAGENTA_DYE).put(14, ChunkerVanillaItemType.ORANGE_DYE).put(15, ChunkerVanillaItemType.BONE_MEAL).put(16, ChunkerVanillaItemType.BLACK_DYE).put(17, ChunkerVanillaItemType.BROWN_DYE).put(18, ChunkerVanillaItemType.BLUE_DYE).put(19, ChunkerVanillaItemType.WHITE_DYE).build()));
        this.register(ItemMapping.of("minecraft:dye", ChunkerVanillaItemType.INK_SAC));
        this.register(ItemMapping.flatten("minecraft:bucket", ImmutableMultimap.builder().put(1, ChunkerVanillaItemType.MILK_BUCKET).put(3, ChunkerVanillaItemType.SALMON_BUCKET).put(2, ChunkerVanillaItemType.COD_BUCKET).put(10, ChunkerVanillaItemType.LAVA_BUCKET).put(8, ChunkerVanillaItemType.WATER_BUCKET).put(4, ChunkerVanillaItemType.TROPICAL_FISH_BUCKET).put(5, ChunkerVanillaItemType.PUFFERFISH_BUCKET).build()));
        this.register(ItemMapping.of("minecraft:spawn_egg", ChunkerVanillaItemType.SPAWN_EGG));
        this.register(ItemMapping.of("minecraft:record_13", ChunkerVanillaItemType.MUSIC_DISC_13));
        this.register(ItemMapping.of("minecraft:record_cat", ChunkerVanillaItemType.MUSIC_DISC_CAT));
        this.register(ItemMapping.of("minecraft:record_blocks", ChunkerVanillaItemType.MUSIC_DISC_BLOCKS));
        this.register(ItemMapping.of("minecraft:record_chirp", ChunkerVanillaItemType.MUSIC_DISC_CHIRP));
        this.register(ItemMapping.of("minecraft:record_far", ChunkerVanillaItemType.MUSIC_DISC_FAR));
        this.register(ItemMapping.of("minecraft:record_mall", ChunkerVanillaItemType.MUSIC_DISC_MALL));
        this.register(ItemMapping.of("minecraft:record_mellohi", ChunkerVanillaItemType.MUSIC_DISC_MELLOHI));
        this.register(ItemMapping.of("minecraft:record_stal", ChunkerVanillaItemType.MUSIC_DISC_STAL));
        this.register(ItemMapping.of("minecraft:record_strad", ChunkerVanillaItemType.MUSIC_DISC_STRAD));
        this.register(ItemMapping.of("minecraft:record_ward", ChunkerVanillaItemType.MUSIC_DISC_WARD));
        this.register(ItemMapping.of("minecraft:record_11", ChunkerVanillaItemType.MUSIC_DISC_11));
        this.register(ItemMapping.of("minecraft:record_wait", ChunkerVanillaItemType.MUSIC_DISC_WAIT));
        this.register(ItemMapping.of("minecraft:comparator", ChunkerVanillaBlockType.COMPARATOR));
        this.register(ItemMapping.of("minecraft:repeater", ChunkerVanillaBlockType.REPEATER));
        this.register(ItemMapping.of("minecraft:campfire", ChunkerVanillaBlockType.CAMPFIRE));
        this.register(ItemMapping.of("minecraft:soul_campfire", ChunkerVanillaBlockType.SOUL_CAMPFIRE));
        this.register(ItemMapping.of("minecraft:hopper", ChunkerVanillaBlockType.HOPPER));
        this.register(ItemMapping.of("minecraft:cauldron", ChunkerVanillaBlockType.CAULDRON));
        this.register(ItemMapping.of("minecraft:brewing_stand", ChunkerVanillaBlockType.BREWING_STAND));
        this.register(ItemMapping.of("minecraft:cake", ChunkerVanillaBlockType.CAKE));
        this.register(ItemMapping.of("minecraft:chain", ChunkerVanillaBlockType.CHAIN));
        this.register(ItemMapping.of("minecraft:flower_pot", ChunkerVanillaBlockType.FLOWER_POT));
        this.register(ItemMapping.of("minecraft:emptymap", ChunkerVanillaItemType.MAP));
        this.register(ItemMapping.of("minecraft:horsearmorleather", ChunkerVanillaItemType.LEATHER_HORSE_ARMOR));
        this.register(ItemMapping.flatten("minecraft:banner_pattern", ImmutableMultimap.builder().put(1, ChunkerVanillaItemType.SKULL_BANNER_PATTERN).put(2, ChunkerVanillaItemType.FLOWER_BANNER_PATTERN).put(3, ChunkerVanillaItemType.MOJANG_BANNER_PATTERN).put(4, ChunkerVanillaItemType.FIELD_MASONED_BANNER_PATTERN).put(5, ChunkerVanillaItemType.BORDURE_INDENTED_BANNER_PATTERN).put(6, ChunkerVanillaItemType.PIGLIN_BANNER_PATTERN).put(7, ChunkerVanillaItemType.GLOBE_BANNER_PATTERN).build()));
        this.register(ItemMapping.of("minecraft:banner_pattern", ChunkerVanillaItemType.CREEPER_BANNER_PATTERN));
        this.register(ItemMapping.of("minecraft:coal", ChunkerVanillaItemType.COAL));
        this.register(ItemMapping.of("minecraft:coal", 1, (ChunkerItemStackIdentifierType)ChunkerVanillaItemType.CHARCOAL));
        this.register(ItemMapping.of("minecraft:appleenchanted", ChunkerVanillaItemType.ENCHANTED_GOLDEN_APPLE));
        this.register(ItemMapping.of("minecraft:fish", ChunkerVanillaItemType.COD));
        this.register(ItemMapping.of("minecraft:clownfish", ChunkerVanillaItemType.TROPICAL_FISH));
        this.register(ItemMapping.of("minecraft:cooked_fish", ChunkerVanillaItemType.COOKED_COD));
        this.register(ItemMapping.of("minecraft:fireworks", ChunkerVanillaItemType.FIREWORK_ROCKET));
        this.register(ItemMapping.of("minecraft:fireworkscharge", ChunkerVanillaItemType.FIREWORK_STAR));
        this.registerDuplicateOutput(ItemMapping.of("minecraft:fireworks_charge", ChunkerVanillaItemType.FIREWORK_STAR));
        this.register(ItemMapping.of("minecraft:chorus_fruit_popped", ChunkerVanillaItemType.POPPED_CHORUS_FRUIT));
        this.register(ItemMapping.of("minecraft:book", ChunkerVanillaItemType.BOOK));
        this.registerDuplicateInput(ItemMapping.of("minecraft:book", ChunkerVanillaItemType.KNOWLEDGE_BOOK));
        this.register(ItemMapping.of("minecraft:wooden_door", ChunkerVanillaBlockType.OAK_DOOR));
        this.register(ItemMapping.of("minecraft:spruce_door", ChunkerVanillaBlockType.SPRUCE_DOOR));
        this.register(ItemMapping.of("minecraft:birch_door", ChunkerVanillaBlockType.BIRCH_DOOR));
        this.register(ItemMapping.of("minecraft:jungle_door", ChunkerVanillaBlockType.JUNGLE_DOOR));
        this.register(ItemMapping.of("minecraft:acacia_door", ChunkerVanillaBlockType.ACACIA_DOOR));
        this.register(ItemMapping.of("minecraft:dark_oak_door", ChunkerVanillaBlockType.DARK_OAK_DOOR));
        this.register(ItemMapping.of("minecraft:iron_door", ChunkerVanillaBlockType.IRON_DOOR));
        this.register(ItemMapping.of("minecraft:crimson_door", ChunkerVanillaBlockType.CRIMSON_DOOR));
        this.register(ItemMapping.of("minecraft:warped_door", ChunkerVanillaBlockType.WARPED_DOOR));
        this.register(ItemMapping.of("minecraft:kelp", ChunkerVanillaBlockType.KELP));
        this.register(ItemMapping.of("minecraft:reeds", ChunkerVanillaBlockType.SUGAR_CANE));
        this.register(ItemMapping.of("minecraft:turtle_shell_piece", ChunkerVanillaItemType.TURTLE_SCUTE));
        this.register(ItemMapping.of("minecraft:stick", ChunkerVanillaItemType.STICK));
        this.registerDuplicateInput(ItemMapping.of("minecraft:stick", ChunkerVanillaItemType.DEBUG_STICK));
        this.register(ItemMapping.of("minecraft:nether_sprouts", ChunkerVanillaBlockType.NETHER_SPROUTS));
        this.register(ItemMapping.flatten("minecraft:skull", ImmutableMultimap.builder().put(1, ChunkerVanillaBlockType.WITHER_SKELETON_SKULL).put(2, ChunkerVanillaBlockType.ZOMBIE_HEAD).put(3, ChunkerVanillaBlockType.PLAYER_HEAD).put(4, ChunkerVanillaBlockType.CREEPER_HEAD).put(5, ChunkerVanillaBlockType.DRAGON_HEAD).put(6, ChunkerVanillaBlockType.PIGLIN_HEAD).build()));
        this.register(ItemMapping.of("minecraft:skull", ChunkerVanillaBlockType.SKELETON_SKULL));
        this.registerDuplicateOutput(ItemMapping.of("minecraft:skull", Map.of("facing_direction", 0, "no_drop_bit", false), (ChunkerItemStackIdentifierType)ChunkerVanillaBlockType.SKELETON_SKULL));
        this.registerDuplicateOutput(ItemMapping.of("minecraft:skull", Map.of("facing_direction", 1, "no_drop_bit", false), (ChunkerItemStackIdentifierType)ChunkerVanillaBlockType.WITHER_SKELETON_SKULL));
        this.registerDuplicateOutput(ItemMapping.of("minecraft:skull", Map.of("facing_direction", 2, "no_drop_bit", false), (ChunkerItemStackIdentifierType)ChunkerVanillaBlockType.ZOMBIE_HEAD));
        this.registerDuplicateOutput(ItemMapping.of("minecraft:skull", Map.of("facing_direction", 3, "no_drop_bit", false), (ChunkerItemStackIdentifierType)ChunkerVanillaBlockType.PLAYER_HEAD));
        this.registerDuplicateOutput(ItemMapping.of("minecraft:skull", Map.of("facing_direction", 4, "no_drop_bit", false), (ChunkerItemStackIdentifierType)ChunkerVanillaBlockType.CREEPER_HEAD));
        this.registerDuplicateOutput(ItemMapping.of("minecraft:skull", Map.of("facing_direction", 5, "no_drop_bit", false), (ChunkerItemStackIdentifierType)ChunkerVanillaBlockType.DRAGON_HEAD));
        this.registerDuplicateOutput(ItemMapping.of("minecraft:skull", Map.of("facing_direction", 6, "no_drop_bit", false), (ChunkerItemStackIdentifierType)ChunkerVanillaBlockType.PIGLIN_HEAD));
        this.register(ItemMapping.of("minecraft:seagrass", ChunkerVanillaBlockType.SEAGRASS));
        this.register(ItemMapping.of("minecraft:sticky_piston", ChunkerVanillaBlockType.STICKY_PISTON));
        this.register(ItemMapping.of("minecraft:piston", ChunkerVanillaBlockType.PISTON));
        this.register(ItemMapping.of("minecraft:acacia_sign", ChunkerVanillaItemType.ACACIA_SIGN));
        this.register(ItemMapping.of("minecraft:apple", ChunkerVanillaItemType.APPLE));
        this.register(ItemMapping.of("minecraft:armor_stand", ChunkerVanillaItemType.ARMOR_STAND));
        this.register(ItemMapping.of("minecraft:baked_potato", ChunkerVanillaItemType.BAKED_POTATO));
        this.register(ItemMapping.of("minecraft:beef", ChunkerVanillaItemType.BEEF));
        this.register(ItemMapping.of("minecraft:beetroot", ChunkerVanillaItemType.BEETROOT));
        this.register(ItemMapping.of("minecraft:beetroot_seeds", ChunkerVanillaItemType.BEETROOT_SEEDS));
        this.register(ItemMapping.of("minecraft:beetroot_soup", ChunkerVanillaItemType.BEETROOT_SOUP));
        this.register(ItemMapping.of("minecraft:birch_sign", ChunkerVanillaItemType.BIRCH_SIGN));
        this.register(ItemMapping.of("minecraft:blaze_powder", ChunkerVanillaItemType.BLAZE_POWDER));
        this.register(ItemMapping.of("minecraft:blaze_rod", ChunkerVanillaItemType.BLAZE_ROD));
        this.register(ItemMapping.of("minecraft:bone", ChunkerVanillaItemType.BONE));
        this.register(ItemMapping.of("minecraft:bow", ChunkerVanillaItemType.BOW));
        this.register(ItemMapping.of("minecraft:bowl", ChunkerVanillaItemType.BOWL));
        this.register(ItemMapping.of("minecraft:bread", ChunkerVanillaItemType.BREAD));
        this.register(ItemMapping.of("minecraft:brick", ChunkerVanillaItemType.BRICK));
        this.register(ItemMapping.of("minecraft:carrot", ChunkerVanillaItemType.CARROT));
        this.register(ItemMapping.of("minecraft:chainmail_boots", ChunkerVanillaItemType.CHAINMAIL_BOOTS));
        this.register(ItemMapping.of("minecraft:chainmail_chestplate", ChunkerVanillaItemType.CHAINMAIL_CHESTPLATE));
        this.register(ItemMapping.of("minecraft:chainmail_helmet", ChunkerVanillaItemType.CHAINMAIL_HELMET));
        this.register(ItemMapping.of("minecraft:chainmail_leggings", ChunkerVanillaItemType.CHAINMAIL_LEGGINGS));
        this.register(ItemMapping.of("minecraft:chest_minecart", ChunkerVanillaItemType.CHEST_MINECART));
        this.register(ItemMapping.of("minecraft:chicken", ChunkerVanillaItemType.CHICKEN));
        this.register(ItemMapping.of("minecraft:chorus_fruit", ChunkerVanillaItemType.CHORUS_FRUIT));
        this.register(ItemMapping.of("minecraft:clay_ball", ChunkerVanillaItemType.CLAY_BALL));
        this.register(ItemMapping.of("minecraft:clock", ChunkerVanillaItemType.CLOCK));
        this.register(ItemMapping.of("minecraft:command_block_minecart", ChunkerVanillaItemType.COMMAND_BLOCK_MINECART));
        this.register(ItemMapping.of("minecraft:compass", ChunkerVanillaItemType.COMPASS));
        this.register(ItemMapping.of("minecraft:cooked_beef", ChunkerVanillaItemType.COOKED_BEEF));
        this.register(ItemMapping.of("minecraft:cooked_chicken", ChunkerVanillaItemType.COOKED_CHICKEN));
        this.register(ItemMapping.of("minecraft:cooked_porkchop", ChunkerVanillaItemType.COOKED_PORKCHOP));
        this.register(ItemMapping.of("minecraft:cooked_rabbit", ChunkerVanillaItemType.COOKED_RABBIT));
        this.register(ItemMapping.of("minecraft:cooked_salmon", ChunkerVanillaItemType.COOKED_SALMON));
        this.register(ItemMapping.of("minecraft:cookie", ChunkerVanillaItemType.COOKIE));
        this.register(ItemMapping.of("minecraft:crossbow", ChunkerVanillaItemType.CROSSBOW));
        this.register(ItemMapping.of("minecraft:diamond", ChunkerVanillaItemType.DIAMOND));
        this.register(ItemMapping.of("minecraft:diamond_axe", ChunkerVanillaItemType.DIAMOND_AXE));
        this.register(ItemMapping.of("minecraft:diamond_boots", ChunkerVanillaItemType.DIAMOND_BOOTS));
        this.register(ItemMapping.of("minecraft:diamond_chestplate", ChunkerVanillaItemType.DIAMOND_CHESTPLATE));
        this.register(ItemMapping.of("minecraft:diamond_helmet", ChunkerVanillaItemType.DIAMOND_HELMET));
        this.register(ItemMapping.of("minecraft:diamond_hoe", ChunkerVanillaItemType.DIAMOND_HOE));
        this.register(ItemMapping.of("minecraft:diamond_leggings", ChunkerVanillaItemType.DIAMOND_LEGGINGS));
        this.register(ItemMapping.of("minecraft:diamond_pickaxe", ChunkerVanillaItemType.DIAMOND_PICKAXE));
        this.register(ItemMapping.of("minecraft:diamond_shovel", ChunkerVanillaItemType.DIAMOND_SHOVEL));
        this.register(ItemMapping.of("minecraft:diamond_sword", ChunkerVanillaItemType.DIAMOND_SWORD));
        this.register(ItemMapping.of("minecraft:dragon_breath", ChunkerVanillaItemType.DRAGON_BREATH));
        this.register(ItemMapping.of("minecraft:dried_kelp", ChunkerVanillaItemType.DRIED_KELP));
        this.register(ItemMapping.of("minecraft:egg", ChunkerVanillaItemType.EGG));
        this.register(ItemMapping.of("minecraft:elytra", ChunkerVanillaItemType.ELYTRA));
        this.register(ItemMapping.of("minecraft:emerald", ChunkerVanillaItemType.EMERALD));
        this.register(ItemMapping.of("minecraft:enchanted_book", ChunkerVanillaItemType.ENCHANTED_BOOK));
        this.register(ItemMapping.of("minecraft:end_crystal", ChunkerVanillaItemType.END_CRYSTAL));
        this.register(ItemMapping.of("minecraft:ender_eye", ChunkerVanillaItemType.ENDER_EYE));
        this.register(ItemMapping.of("minecraft:ender_pearl", ChunkerVanillaItemType.ENDER_PEARL));
        this.register(ItemMapping.of("minecraft:experience_bottle", ChunkerVanillaItemType.EXPERIENCE_BOTTLE));
        this.register(ItemMapping.of("minecraft:feather", ChunkerVanillaItemType.FEATHER));
        this.register(ItemMapping.of("minecraft:fermented_spider_eye", ChunkerVanillaItemType.FERMENTED_SPIDER_EYE));
        this.register(ItemMapping.of("minecraft:fishing_rod", ChunkerVanillaItemType.FISHING_ROD));
        this.register(ItemMapping.of("minecraft:flint", ChunkerVanillaItemType.FLINT));
        this.register(ItemMapping.of("minecraft:flint_and_steel", ChunkerVanillaItemType.FLINT_AND_STEEL));
        this.register(ItemMapping.of("minecraft:ghast_tear", ChunkerVanillaItemType.GHAST_TEAR));
        this.register(ItemMapping.of("minecraft:glass_bottle", ChunkerVanillaItemType.GLASS_BOTTLE));
        this.register(ItemMapping.of("minecraft:glowstone_dust", ChunkerVanillaItemType.GLOWSTONE_DUST));
        this.register(ItemMapping.of("minecraft:gold_ingot", ChunkerVanillaItemType.GOLD_INGOT));
        this.register(ItemMapping.of("minecraft:gold_nugget", ChunkerVanillaItemType.GOLD_NUGGET));
        this.register(ItemMapping.of("minecraft:golden_apple", ChunkerVanillaItemType.GOLDEN_APPLE));
        this.register(ItemMapping.of("minecraft:golden_axe", ChunkerVanillaItemType.GOLDEN_AXE));
        this.register(ItemMapping.of("minecraft:golden_boots", ChunkerVanillaItemType.GOLDEN_BOOTS));
        this.register(ItemMapping.of("minecraft:golden_carrot", ChunkerVanillaItemType.GOLDEN_CARROT));
        this.register(ItemMapping.of("minecraft:golden_chestplate", ChunkerVanillaItemType.GOLDEN_CHESTPLATE));
        this.register(ItemMapping.of("minecraft:golden_helmet", ChunkerVanillaItemType.GOLDEN_HELMET));
        this.register(ItemMapping.of("minecraft:golden_hoe", ChunkerVanillaItemType.GOLDEN_HOE));
        this.register(ItemMapping.of("minecraft:golden_leggings", ChunkerVanillaItemType.GOLDEN_LEGGINGS));
        this.register(ItemMapping.of("minecraft:golden_pickaxe", ChunkerVanillaItemType.GOLDEN_PICKAXE));
        this.register(ItemMapping.of("minecraft:golden_shovel", ChunkerVanillaItemType.GOLDEN_SHOVEL));
        this.register(ItemMapping.of("minecraft:golden_sword", ChunkerVanillaItemType.GOLDEN_SWORD));
        this.register(ItemMapping.of("minecraft:gunpowder", ChunkerVanillaItemType.GUNPOWDER));
        this.register(ItemMapping.of("minecraft:heart_of_the_sea", ChunkerVanillaItemType.HEART_OF_THE_SEA));
        this.register(ItemMapping.of("minecraft:hopper_minecart", ChunkerVanillaItemType.HOPPER_MINECART));
        this.register(ItemMapping.of("minecraft:iron_axe", ChunkerVanillaItemType.IRON_AXE));
        this.register(ItemMapping.of("minecraft:iron_boots", ChunkerVanillaItemType.IRON_BOOTS));
        this.register(ItemMapping.of("minecraft:iron_chestplate", ChunkerVanillaItemType.IRON_CHESTPLATE));
        this.register(ItemMapping.of("minecraft:iron_helmet", ChunkerVanillaItemType.IRON_HELMET));
        this.register(ItemMapping.of("minecraft:iron_hoe", ChunkerVanillaItemType.IRON_HOE));
        this.register(ItemMapping.of("minecraft:iron_ingot", ChunkerVanillaItemType.IRON_INGOT));
        this.register(ItemMapping.of("minecraft:iron_leggings", ChunkerVanillaItemType.IRON_LEGGINGS));
        this.register(ItemMapping.of("minecraft:iron_nugget", ChunkerVanillaItemType.IRON_NUGGET));
        this.register(ItemMapping.of("minecraft:iron_pickaxe", ChunkerVanillaItemType.IRON_PICKAXE));
        this.register(ItemMapping.of("minecraft:iron_shovel", ChunkerVanillaItemType.IRON_SHOVEL));
        this.register(ItemMapping.of("minecraft:iron_sword", ChunkerVanillaItemType.IRON_SWORD));
        this.register(ItemMapping.of("minecraft:jungle_sign", ChunkerVanillaItemType.JUNGLE_SIGN));
        this.register(ItemMapping.of("minecraft:lead", ChunkerVanillaItemType.LEAD));
        this.register(ItemMapping.of("minecraft:leather", ChunkerVanillaItemType.LEATHER));
        this.register(ItemMapping.of("minecraft:leather_boots", ChunkerVanillaItemType.LEATHER_BOOTS));
        this.register(ItemMapping.of("minecraft:leather_chestplate", ChunkerVanillaItemType.LEATHER_CHESTPLATE));
        this.register(ItemMapping.of("minecraft:leather_helmet", ChunkerVanillaItemType.LEATHER_HELMET));
        this.register(ItemMapping.of("minecraft:leather_leggings", ChunkerVanillaItemType.LEATHER_LEGGINGS));
        this.register(ItemMapping.of("minecraft:magma_cream", ChunkerVanillaItemType.MAGMA_CREAM));
        this.register(ItemMapping.of("minecraft:melon_seeds", ChunkerVanillaItemType.MELON_SEEDS));
        this.register(ItemMapping.of("minecraft:mushroom_stew", ChunkerVanillaItemType.MUSHROOM_STEW));
        this.register(ItemMapping.of("minecraft:name_tag", ChunkerVanillaItemType.NAME_TAG));
        this.register(ItemMapping.of("minecraft:nautilus_shell", ChunkerVanillaItemType.NAUTILUS_SHELL));
        this.register(ItemMapping.of("minecraft:nether_wart", ChunkerVanillaItemType.NETHER_WART));
        this.register(ItemMapping.of("minecraft:painting", ChunkerVanillaItemType.PAINTING));
        this.register(ItemMapping.of("minecraft:paper", ChunkerVanillaItemType.PAPER));
        this.register(ItemMapping.of("minecraft:phantom_membrane", ChunkerVanillaItemType.PHANTOM_MEMBRANE));
        this.register(ItemMapping.of("minecraft:poisonous_potato", ChunkerVanillaItemType.POISONOUS_POTATO));
        this.register(ItemMapping.of("minecraft:porkchop", ChunkerVanillaItemType.PORKCHOP));
        this.register(ItemMapping.of("minecraft:potato", ChunkerVanillaItemType.POTATO));
        this.register(ItemMapping.of("minecraft:prismarine_crystals", ChunkerVanillaItemType.PRISMARINE_CRYSTALS));
        this.register(ItemMapping.of("minecraft:prismarine_shard", ChunkerVanillaItemType.PRISMARINE_SHARD));
        this.register(ItemMapping.of("minecraft:pufferfish", ChunkerVanillaItemType.PUFFERFISH));
        this.register(ItemMapping.of("minecraft:pumpkin_pie", ChunkerVanillaItemType.PUMPKIN_PIE));
        this.register(ItemMapping.of("minecraft:pumpkin_seeds", ChunkerVanillaItemType.PUMPKIN_SEEDS));
        this.register(ItemMapping.of("minecraft:quartz", ChunkerVanillaItemType.QUARTZ));
        this.register(ItemMapping.of("minecraft:rabbit", ChunkerVanillaItemType.RABBIT));
        this.register(ItemMapping.of("minecraft:rabbit_foot", ChunkerVanillaItemType.RABBIT_FOOT));
        this.register(ItemMapping.of("minecraft:rabbit_hide", ChunkerVanillaItemType.RABBIT_HIDE));
        this.register(ItemMapping.of("minecraft:rabbit_stew", ChunkerVanillaItemType.RABBIT_STEW));
        this.register(ItemMapping.of("minecraft:rotten_flesh", ChunkerVanillaItemType.ROTTEN_FLESH));
        this.register(ItemMapping.of("minecraft:saddle", ChunkerVanillaItemType.SADDLE));
        this.register(ItemMapping.of("minecraft:salmon", ChunkerVanillaItemType.SALMON));
        this.register(ItemMapping.of("minecraft:shears", ChunkerVanillaItemType.SHEARS));
        this.register(ItemMapping.of("minecraft:shulker_shell", ChunkerVanillaItemType.SHULKER_SHELL));
        this.register(ItemMapping.of("minecraft:slime_ball", ChunkerVanillaItemType.SLIME_BALL));
        this.register(ItemMapping.of("minecraft:snowball", ChunkerVanillaItemType.SNOWBALL));
        this.register(ItemMapping.of("minecraft:spider_eye", ChunkerVanillaItemType.SPIDER_EYE));
        this.register(ItemMapping.of("minecraft:spruce_sign", ChunkerVanillaItemType.SPRUCE_SIGN));
        this.register(ItemMapping.of("minecraft:stone_axe", ChunkerVanillaItemType.STONE_AXE));
        this.register(ItemMapping.of("minecraft:stone_hoe", ChunkerVanillaItemType.STONE_HOE));
        this.register(ItemMapping.of("minecraft:stone_pickaxe", ChunkerVanillaItemType.STONE_PICKAXE));
        this.register(ItemMapping.of("minecraft:stone_shovel", ChunkerVanillaItemType.STONE_SHOVEL));
        this.register(ItemMapping.of("minecraft:stone_sword", ChunkerVanillaItemType.STONE_SWORD));
        this.register(ItemMapping.of("minecraft:string", ChunkerVanillaItemType.STRING));
        this.register(ItemMapping.of("minecraft:sugar", ChunkerVanillaItemType.SUGAR));
        this.register(ItemMapping.of("minecraft:sweet_berries", ChunkerVanillaItemType.SWEET_BERRIES));
        this.register(ItemMapping.of("minecraft:tnt_minecart", ChunkerVanillaItemType.TNT_MINECART));
        this.register(ItemMapping.of("minecraft:trident", ChunkerVanillaItemType.TRIDENT));
        this.register(ItemMapping.of("minecraft:turtle_helmet", ChunkerVanillaItemType.TURTLE_HELMET));
        this.register(ItemMapping.of("minecraft:wheat", ChunkerVanillaItemType.WHEAT));
        this.register(ItemMapping.of("minecraft:wheat_seeds", ChunkerVanillaItemType.WHEAT_SEEDS));
        this.register(ItemMapping.of("minecraft:wooden_axe", ChunkerVanillaItemType.WOODEN_AXE));
        this.register(ItemMapping.of("minecraft:wooden_hoe", ChunkerVanillaItemType.WOODEN_HOE));
        this.register(ItemMapping.of("minecraft:wooden_pickaxe", ChunkerVanillaItemType.WOODEN_PICKAXE));
        this.register(ItemMapping.of("minecraft:wooden_shovel", ChunkerVanillaItemType.WOODEN_SHOVEL));
        this.register(ItemMapping.of("minecraft:wooden_sword", ChunkerVanillaItemType.WOODEN_SWORD));
        this.register(ItemMapping.of("minecraft:writable_book", ChunkerVanillaItemType.WRITABLE_BOOK));
        this.register(ItemMapping.of("minecraft:written_book", ChunkerVanillaItemType.WRITTEN_BOOK));
        if (version.isGreaterThanOrEqual(1, 13, 0)) {
            this.register(ItemMapping.of("minecraft:suspicious_stew", 0, ChunkerVanillaItemType.SUSPICIOUS_STEW, ChunkerItemProperty.STEW_EFFECT, new ChunkerStewEffect(Map.of(ChunkerEffectType.NIGHT_VISION, 100))));
            this.register(ItemMapping.of("minecraft:suspicious_stew", 1, ChunkerVanillaItemType.SUSPICIOUS_STEW, ChunkerItemProperty.STEW_EFFECT, new ChunkerStewEffect(Map.of(ChunkerEffectType.JUMP_BOOST, 120))));
            this.register(ItemMapping.of("minecraft:suspicious_stew", 2, ChunkerVanillaItemType.SUSPICIOUS_STEW, ChunkerItemProperty.STEW_EFFECT, new ChunkerStewEffect(Map.of(ChunkerEffectType.WEAKNESS, 180))));
            this.register(ItemMapping.of("minecraft:suspicious_stew", 3, ChunkerVanillaItemType.SUSPICIOUS_STEW, ChunkerItemProperty.STEW_EFFECT, new ChunkerStewEffect(Map.of(ChunkerEffectType.BLINDNESS, 160))));
            this.register(ItemMapping.of("minecraft:suspicious_stew", 4, ChunkerVanillaItemType.SUSPICIOUS_STEW, ChunkerItemProperty.STEW_EFFECT, new ChunkerStewEffect(Map.of(ChunkerEffectType.POISON, 240))));
            this.register(ItemMapping.of("minecraft:suspicious_stew", 5, ChunkerVanillaItemType.SUSPICIOUS_STEW, ChunkerItemProperty.STEW_EFFECT, new ChunkerStewEffect(Map.of(ChunkerEffectType.SATURATION, 7))));
            this.register(ItemMapping.of("minecraft:suspicious_stew", 6, ChunkerVanillaItemType.SUSPICIOUS_STEW, ChunkerItemProperty.STEW_EFFECT, new ChunkerStewEffect(Map.of(ChunkerEffectType.SATURATION, 6))));
            this.register(ItemMapping.of("minecraft:suspicious_stew", 7, ChunkerVanillaItemType.SUSPICIOUS_STEW, ChunkerItemProperty.STEW_EFFECT, new ChunkerStewEffect(Map.of(ChunkerEffectType.FIRE_RESISTANCE, 60))));
            this.register(ItemMapping.of("minecraft:suspicious_stew", 8, ChunkerVanillaItemType.SUSPICIOUS_STEW, ChunkerItemProperty.STEW_EFFECT, new ChunkerStewEffect(Map.of(ChunkerEffectType.REGENERATION, 160))));
            this.register(ItemMapping.of("minecraft:suspicious_stew", 9, ChunkerVanillaItemType.SUSPICIOUS_STEW, ChunkerItemProperty.STEW_EFFECT, new ChunkerStewEffect(Map.of(ChunkerEffectType.WITHER, 160))));
            this.register(ItemMapping.of("minecraft:suspicious_stew", 10, ChunkerVanillaItemType.SUSPICIOUS_STEW, ChunkerItemProperty.STEW_EFFECT, new ChunkerStewEffect(Map.of(ChunkerEffectType.NIGHT_VISION, 80))));
            this.register(ItemMapping.of("minecraft:suspicious_stew", ChunkerVanillaItemType.SUSPICIOUS_STEW));
        }
        if (version.isGreaterThanOrEqual(1, 14, 0)) {
            this.register(ItemMapping.of("minecraft:honey_bottle", ChunkerVanillaItemType.HONEY_BOTTLE));
            this.register(ItemMapping.of("minecraft:honeycomb", ChunkerVanillaItemType.HONEYCOMB));
        }
        if (version.isGreaterThanOrEqual(1, 16, 0)) {
            this.register(ItemMapping.of("minecraft:netherite_scrap", ChunkerVanillaItemType.NETHERITE_SCRAP));
            this.register(ItemMapping.of("minecraft:warped_fungus_on_a_stick", ChunkerVanillaItemType.WARPED_FUNGUS_ON_A_STICK));
            this.register(ItemMapping.of("minecraft:netherite_ingot", ChunkerVanillaItemType.NETHERITE_INGOT));
            this.register(ItemMapping.of("minecraft:netherite_axe", ChunkerVanillaItemType.NETHERITE_AXE));
            this.register(ItemMapping.of("minecraft:netherite_boots", ChunkerVanillaItemType.NETHERITE_BOOTS));
            this.register(ItemMapping.of("minecraft:netherite_chestplate", ChunkerVanillaItemType.NETHERITE_CHESTPLATE));
            this.register(ItemMapping.of("minecraft:netherite_helmet", ChunkerVanillaItemType.NETHERITE_HELMET));
            this.register(ItemMapping.of("minecraft:netherite_hoe", ChunkerVanillaItemType.NETHERITE_HOE));
            this.register(ItemMapping.of("minecraft:netherite_leggings", ChunkerVanillaItemType.NETHERITE_LEGGINGS));
            this.register(ItemMapping.of("minecraft:netherite_pickaxe", ChunkerVanillaItemType.NETHERITE_PICKAXE));
            this.register(ItemMapping.of("minecraft:netherite_shovel", ChunkerVanillaItemType.NETHERITE_SHOVEL));
            this.register(ItemMapping.of("minecraft:netherite_sword", ChunkerVanillaItemType.NETHERITE_SWORD));
            this.register(ItemMapping.of("minecraft:crimson_sign", ChunkerVanillaItemType.CRIMSON_SIGN));
            this.register(ItemMapping.of("minecraft:warped_sign", ChunkerVanillaItemType.WARPED_SIGN));
            this.register(ItemMapping.of("minecraft:lodestonecompass", ChunkerVanillaItemType.LODESTONE_COMPASS));
            this.register(ItemMapping.of("minecraft:record_pigstep", ChunkerVanillaItemType.MUSIC_DISC_PIGSTEP));
        }
        if (version.isGreaterThanOrEqual(1, 16, 100)) {
            this.registerOverrideOutput(ItemMapping.of("minecraft:fire_charge", ChunkerVanillaItemType.FIRE_CHARGE));
            this.registerOverrideOutput(ItemMapping.of("minecraft:mutton", ChunkerVanillaItemType.MUTTON));
            this.registerOverrideOutput(ItemMapping.of("minecraft:cooked_mutton", ChunkerVanillaItemType.COOKED_MUTTON));
            this.registerOverrideOutput(ItemMapping.of("minecraft:carrot_on_a_stick", ChunkerVanillaItemType.CARROT_ON_A_STICK));
            this.registerOverrideOutput(ItemMapping.of("minecraft:diamond_horse_armor", ChunkerVanillaItemType.DIAMOND_HORSE_ARMOR));
            this.registerOverrideOutput(ItemMapping.of("minecraft:totem_of_undying", ChunkerVanillaItemType.TOTEM_OF_UNDYING));
            this.registerOverrideOutput(ItemMapping.of("minecraft:nether_star", ChunkerVanillaItemType.NETHER_STAR));
            this.registerOverrideOutput(ItemMapping.of("minecraft:iron_horse_armor", ChunkerVanillaItemType.IRON_HORSE_ARMOR));
            this.registerOverrideOutput(ItemMapping.of("minecraft:golden_horse_armor", ChunkerVanillaItemType.GOLDEN_HORSE_ARMOR));
            this.registerOverrideOutput(ItemMapping.of("minecraft:glistering_melon_slice", ChunkerVanillaItemType.GLISTERING_MELON_SLICE));
            this.registerOverrideOutput(ItemMapping.of("minecraft:melon_slice", ChunkerVanillaItemType.MELON_SLICE));
            this.registerOverrideOutput(ItemMapping.of("minecraft:leather_horse_armor", ChunkerVanillaItemType.LEATHER_HORSE_ARMOR));
            this.registerOverrideOutput(ItemMapping.of("minecraft:empty_map", ChunkerVanillaItemType.MAP));
            this.registerOverrideOutput(ItemMapping.of("minecraft:cod", ChunkerVanillaItemType.COD));
            this.registerOverrideOutput(ItemMapping.of("minecraft:tropical_fish", ChunkerVanillaItemType.TROPICAL_FISH));
            this.registerOverrideOutput(ItemMapping.of("minecraft:cooked_cod", ChunkerVanillaItemType.COOKED_COD));
            this.registerOverrideOutput(ItemMapping.of("minecraft:firework_rocket", ChunkerVanillaItemType.FIREWORK_ROCKET));
            this.registerOverrideOutput(ItemMapping.of("minecraft:firework_star", ChunkerVanillaItemType.FIREWORK_STAR));
            this.registerOverrideOutput(ItemMapping.of("minecraft:charcoal", ChunkerVanillaItemType.CHARCOAL));
            this.registerOverrideOutput(ItemMapping.of("minecraft:lodestone_compass", ChunkerVanillaItemType.LODESTONE_COMPASS));
            this.registerOverrideOutput(ItemMapping.of("minecraft:filled_map", ChunkerVanillaItemType.FILLED_MAP));
            this.registerOverrideOutput(ItemMapping.of("minecraft:enchanted_golden_apple", ChunkerVanillaItemType.ENCHANTED_GOLDEN_APPLE));
            this.registerOverrideOutput(ItemMapping.of("minecraft:popped_chorus_fruit", ChunkerVanillaItemType.POPPED_CHORUS_FRUIT));
            this.registerOverrideOutput(ItemMapping.of("minecraft:sugar_cane", ChunkerVanillaBlockType.SUGAR_CANE));
            this.registerOverrideOutput(ItemMapping.of("minecraft:scute", ChunkerVanillaItemType.TURTLE_SCUTE));
            this.registerOverrideOutput(ItemMapping.of("minecraft:oak_sign", ChunkerVanillaItemType.OAK_SIGN));
            this.registerOverrideOutput(ItemMapping.of("minecraft:dark_oak_sign", ChunkerVanillaItemType.DARK_OAK_SIGN));
            this.registerOverrideOutput(ItemMapping.of("minecraft:water_bucket", ChunkerVanillaItemType.WATER_BUCKET));
            this.registerOverrideOutput(ItemMapping.of("minecraft:lava_bucket", ChunkerVanillaItemType.LAVA_BUCKET));
            this.registerOverrideOutput(ItemMapping.of("minecraft:milk_bucket", ChunkerVanillaItemType.MILK_BUCKET));
            this.registerOverrideOutput(ItemMapping.of("minecraft:pufferfish_bucket", ChunkerVanillaItemType.PUFFERFISH_BUCKET));
            this.registerOverrideOutput(ItemMapping.of("minecraft:salmon_bucket", ChunkerVanillaItemType.SALMON_BUCKET));
            this.registerOverrideOutput(ItemMapping.of("minecraft:cod_bucket", ChunkerVanillaItemType.COD_BUCKET));
            this.registerOverrideOutput(ItemMapping.of("minecraft:tropical_fish_bucket", ChunkerVanillaItemType.TROPICAL_FISH_BUCKET));
            this.registerOverrideOutput(ItemMapping.of("minecraft:oak_boat", ChunkerVanillaItemType.OAK_BOAT));
            this.registerOverrideOutput(ItemMapping.of("minecraft:spruce_boat", ChunkerVanillaItemType.SPRUCE_BOAT));
            this.registerOverrideOutput(ItemMapping.of("minecraft:birch_boat", ChunkerVanillaItemType.BIRCH_BOAT));
            this.registerOverrideOutput(ItemMapping.of("minecraft:jungle_boat", ChunkerVanillaItemType.JUNGLE_BOAT));
            this.registerOverrideOutput(ItemMapping.of("minecraft:acacia_boat", ChunkerVanillaItemType.ACACIA_BOAT));
            this.registerOverrideOutput(ItemMapping.of("minecraft:dark_oak_boat", ChunkerVanillaItemType.DARK_OAK_BOAT));
            this.registerOverrideOutput(ItemMapping.of("minecraft:ink_sac", ChunkerVanillaItemType.INK_SAC));
            this.registerOverrideOutput(ItemMapping.of("minecraft:red_dye", ChunkerVanillaItemType.RED_DYE));
            this.registerOverrideOutput(ItemMapping.of("minecraft:green_dye", ChunkerVanillaItemType.GREEN_DYE));
            this.registerOverrideOutput(ItemMapping.of("minecraft:cocoa_beans", ChunkerVanillaItemType.COCOA_BEANS));
            this.registerOverrideOutput(ItemMapping.of("minecraft:lapis_lazuli", ChunkerVanillaItemType.LAPIS_LAZULI));
            this.registerOverrideOutput(ItemMapping.of("minecraft:purple_dye", ChunkerVanillaItemType.PURPLE_DYE));
            this.registerOverrideOutput(ItemMapping.of("minecraft:cyan_dye", ChunkerVanillaItemType.CYAN_DYE));
            this.registerOverrideOutput(ItemMapping.of("minecraft:light_gray_dye", ChunkerVanillaItemType.LIGHT_GRAY_DYE));
            this.registerOverrideOutput(ItemMapping.of("minecraft:gray_dye", ChunkerVanillaItemType.GRAY_DYE));
            this.registerOverrideOutput(ItemMapping.of("minecraft:pink_dye", ChunkerVanillaItemType.PINK_DYE));
            this.registerOverrideOutput(ItemMapping.of("minecraft:lime_dye", ChunkerVanillaItemType.LIME_DYE));
            this.registerOverrideOutput(ItemMapping.of("minecraft:yellow_dye", ChunkerVanillaItemType.YELLOW_DYE));
            this.registerOverrideOutput(ItemMapping.of("minecraft:light_blue_dye", ChunkerVanillaItemType.LIGHT_BLUE_DYE));
            this.registerOverrideOutput(ItemMapping.of("minecraft:magenta_dye", ChunkerVanillaItemType.MAGENTA_DYE));
            this.registerOverrideOutput(ItemMapping.of("minecraft:orange_dye", ChunkerVanillaItemType.ORANGE_DYE));
            this.registerOverrideOutput(ItemMapping.of("minecraft:bone_meal", ChunkerVanillaItemType.BONE_MEAL));
            this.registerOverrideOutput(ItemMapping.of("minecraft:brown_dye", ChunkerVanillaItemType.BROWN_DYE));
            this.registerOverrideOutput(ItemMapping.of("minecraft:blue_dye", ChunkerVanillaItemType.BLUE_DYE));
            this.registerOverrideOutput(ItemMapping.of("minecraft:white_dye", ChunkerVanillaItemType.WHITE_DYE));
            this.registerOverrideOutput(ItemMapping.of("minecraft:black_dye", ChunkerVanillaItemType.BLACK_DYE));
            this.registerOverrideOutput(ItemMapping.of("minecraft:music_disc_13", ChunkerVanillaItemType.MUSIC_DISC_13));
            this.registerOverrideOutput(ItemMapping.of("minecraft:music_disc_cat", ChunkerVanillaItemType.MUSIC_DISC_CAT));
            this.registerOverrideOutput(ItemMapping.of("minecraft:music_disc_blocks", ChunkerVanillaItemType.MUSIC_DISC_BLOCKS));
            this.registerOverrideOutput(ItemMapping.of("minecraft:music_disc_chirp", ChunkerVanillaItemType.MUSIC_DISC_CHIRP));
            this.registerOverrideOutput(ItemMapping.of("minecraft:music_disc_far", ChunkerVanillaItemType.MUSIC_DISC_FAR));
            this.registerOverrideOutput(ItemMapping.of("minecraft:music_disc_mall", ChunkerVanillaItemType.MUSIC_DISC_MALL));
            this.registerOverrideOutput(ItemMapping.of("minecraft:music_disc_mellohi", ChunkerVanillaItemType.MUSIC_DISC_MELLOHI));
            this.registerOverrideOutput(ItemMapping.of("minecraft:music_disc_stal", ChunkerVanillaItemType.MUSIC_DISC_STAL));
            this.registerOverrideOutput(ItemMapping.of("minecraft:music_disc_strad", ChunkerVanillaItemType.MUSIC_DISC_STRAD));
            this.registerOverrideOutput(ItemMapping.of("minecraft:music_disc_ward", ChunkerVanillaItemType.MUSIC_DISC_WARD));
            this.registerOverrideOutput(ItemMapping.of("minecraft:music_disc_11", ChunkerVanillaItemType.MUSIC_DISC_11));
            this.registerOverrideOutput(ItemMapping.of("minecraft:music_disc_wait", ChunkerVanillaItemType.MUSIC_DISC_WAIT));
            this.registerOverrideOutput(ItemMapping.of("minecraft:music_disc_pigstep", ChunkerVanillaItemType.MUSIC_DISC_PIGSTEP));
            this.registerOverrideOutput(ItemMapping.of("minecraft:flower_banner_pattern", ChunkerVanillaItemType.FLOWER_BANNER_PATTERN));
            this.registerOverrideOutput(ItemMapping.of("minecraft:creeper_banner_pattern", ChunkerVanillaItemType.CREEPER_BANNER_PATTERN));
            this.registerOverrideOutput(ItemMapping.of("minecraft:skull_banner_pattern", ChunkerVanillaItemType.SKULL_BANNER_PATTERN));
            this.registerOverrideOutput(ItemMapping.of("minecraft:mojang_banner_pattern", ChunkerVanillaItemType.MOJANG_BANNER_PATTERN));
            this.registerOverrideOutput(ItemMapping.of("minecraft:bordure_indented_banner_pattern", ChunkerVanillaItemType.BORDURE_INDENTED_BANNER_PATTERN));
            this.registerOverrideOutput(ItemMapping.of("minecraft:field_masoned_banner_pattern", ChunkerVanillaItemType.FIELD_MASONED_BANNER_PATTERN));
            this.registerOverrideOutput(ItemMapping.of("minecraft:piglin_banner_pattern", ChunkerVanillaItemType.PIGLIN_BANNER_PATTERN));
            this.register(ItemMapping.of("minecraft:bat_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.BAT));
            this.register(ItemMapping.of("minecraft:bee_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.BEE));
            this.register(ItemMapping.of("minecraft:blaze_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.BLAZE));
            this.register(ItemMapping.of("minecraft:cat_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.CAT));
            this.register(ItemMapping.of("minecraft:cave_spider_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.CAVE_SPIDER));
            this.register(ItemMapping.of("minecraft:chicken_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.CHICKEN));
            this.register(ItemMapping.of("minecraft:cod_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.COD));
            this.register(ItemMapping.of("minecraft:cow_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.COW));
            this.register(ItemMapping.of("minecraft:creeper_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.CREEPER));
            this.register(ItemMapping.of("minecraft:dolphin_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.DOLPHIN));
            this.register(ItemMapping.of("minecraft:donkey_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.DONKEY));
            this.register(ItemMapping.of("minecraft:drowned_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.DROWNED));
            this.register(ItemMapping.of("minecraft:elder_guardian_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.ELDER_GUARDIAN));
            this.register(ItemMapping.of("minecraft:enderman_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.ENDERMAN));
            this.register(ItemMapping.of("minecraft:endermite_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.ENDERMITE));
            this.register(ItemMapping.of("minecraft:evoker_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.EVOKER));
            this.register(ItemMapping.of("minecraft:fox_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.FOX));
            this.register(ItemMapping.of("minecraft:ghast_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.GHAST));
            this.register(ItemMapping.of("minecraft:guardian_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.GUARDIAN));
            this.register(ItemMapping.of("minecraft:hoglin_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.HOGLIN));
            this.register(ItemMapping.of("minecraft:horse_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.HORSE));
            this.register(ItemMapping.of("minecraft:husk_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.HUSK));
            this.register(ItemMapping.of("minecraft:llama_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.LLAMA));
            this.register(ItemMapping.of("minecraft:magma_cube_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.MAGMA_CUBE));
            this.register(ItemMapping.of("minecraft:mooshroom_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.MOOSHROOM));
            this.register(ItemMapping.of("minecraft:mule_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.MULE));
            this.register(ItemMapping.of("minecraft:ocelot_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.OCELOT));
            this.register(ItemMapping.of("minecraft:panda_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.PANDA));
            this.register(ItemMapping.of("minecraft:parrot_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.PARROT));
            this.register(ItemMapping.of("minecraft:phantom_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.PHANTOM));
            this.register(ItemMapping.of("minecraft:pig_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.PIG));
            this.register(ItemMapping.of("minecraft:piglin_brute_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.PIGLIN_BRUTE));
            this.register(ItemMapping.of("minecraft:piglin_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.PIGLIN));
            this.register(ItemMapping.of("minecraft:pillager_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.PILLAGER));
            this.register(ItemMapping.of("minecraft:polar_bear_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.POLAR_BEAR));
            this.register(ItemMapping.of("minecraft:pufferfish_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.PUFFERFISH));
            this.register(ItemMapping.of("minecraft:rabbit_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.RABBIT));
            this.register(ItemMapping.of("minecraft:ravager_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.RAVAGER));
            this.register(ItemMapping.of("minecraft:salmon_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.SALMON));
            this.register(ItemMapping.of("minecraft:sheep_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.SHEEP));
            this.register(ItemMapping.of("minecraft:shulker_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.SHULKER));
            this.register(ItemMapping.of("minecraft:silverfish_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.SILVERFISH));
            this.register(ItemMapping.of("minecraft:skeleton_horse_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.SKELETON_HORSE));
            this.register(ItemMapping.of("minecraft:skeleton_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.SKELETON));
            this.register(ItemMapping.of("minecraft:slime_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.SLIME));
            this.register(ItemMapping.of("minecraft:spider_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.SPIDER));
            this.register(ItemMapping.of("minecraft:squid_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.SQUID));
            this.register(ItemMapping.of("minecraft:stray_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.STRAY));
            this.register(ItemMapping.of("minecraft:strider_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.STRIDER));
            this.register(ItemMapping.of("minecraft:tropical_fish_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.TROPICAL_FISH));
            this.register(ItemMapping.of("minecraft:turtle_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.TURTLE));
            this.register(ItemMapping.of("minecraft:vex_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.VEX));
            this.register(ItemMapping.of("minecraft:villager_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.VILLAGER));
            this.register(ItemMapping.of("minecraft:vindicator_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.VINDICATOR));
            this.register(ItemMapping.of("minecraft:wandering_trader_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.WANDERING_TRADER));
            this.register(ItemMapping.of("minecraft:witch_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.WITCH));
            this.register(ItemMapping.of("minecraft:wither_skeleton_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.WITHER_SKELETON));
            this.register(ItemMapping.of("minecraft:wolf_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.WOLF));
            this.register(ItemMapping.of("minecraft:zoglin_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.ZOGLIN));
            this.register(ItemMapping.of("minecraft:zombie_horse_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.ZOMBIE_HORSE));
            this.register(ItemMapping.of("minecraft:zombie_pigman_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.ZOMBIFIED_PIGLIN));
            this.register(ItemMapping.of("minecraft:zombie_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.ZOMBIE));
            this.register(ItemMapping.of("minecraft:zombie_villager_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.ZOMBIE_VILLAGER));
        }
        if (version.isGreaterThanOrEqual(1, 17, 0)) {
            this.register(ItemMapping.of("minecraft:glow_frame", ChunkerVanillaItemType.GLOW_ITEM_FRAME));
            this.register(ItemMapping.of("minecraft:amethyst_shard", ChunkerVanillaItemType.AMETHYST_SHARD));
            this.register(ItemMapping.of("minecraft:axolotl_bucket", ChunkerVanillaItemType.AXOLOTL_BUCKET));
            this.register(ItemMapping.of("minecraft:copper_ingot", ChunkerVanillaItemType.COPPER_INGOT));
            this.register(ItemMapping.of("minecraft:glow_berries", ChunkerVanillaItemType.GLOW_BERRIES));
            this.register(ItemMapping.of("minecraft:glow_ink_sac", ChunkerVanillaItemType.GLOW_INK_SAC));
            this.register(ItemMapping.of("minecraft:powder_snow_bucket", ChunkerVanillaItemType.POWDER_SNOW_BUCKET));
            this.register(ItemMapping.of("minecraft:raw_copper", ChunkerVanillaItemType.RAW_COPPER));
            this.register(ItemMapping.of("minecraft:raw_gold", ChunkerVanillaItemType.RAW_GOLD));
            this.register(ItemMapping.of("minecraft:raw_iron", ChunkerVanillaItemType.RAW_IRON));
            this.register(ItemMapping.of("minecraft:spyglass", ChunkerVanillaItemType.SPYGLASS));
            this.register(ItemMapping.of("minecraft:axolotl_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.AXOLOTL));
            this.register(ItemMapping.of("minecraft:glow_squid_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.GLOW_SQUID));
            this.register(ItemMapping.of("minecraft:goat_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.GOAT));
            if (version.isLessThan(1, 18, 30) || version.isGreaterThanOrEqual(1, 19, 0)) {
                this.register(ItemMapping.of("minecraft:goat_horn", ChunkerVanillaItemType.GOAT_HORN));
                this.register(ItemMapping.of("minecraft:goat_horn", 0, ChunkerVanillaItemType.GOAT_HORN, ChunkerItemProperty.HORN_INSTRUMENT, ChunkerHornInstrument.PONDER_GOAT_HORN));
                this.register(ItemMapping.of("minecraft:goat_horn", 1, ChunkerVanillaItemType.GOAT_HORN, ChunkerItemProperty.HORN_INSTRUMENT, ChunkerHornInstrument.SING_GOAT_HORN));
                this.register(ItemMapping.of("minecraft:goat_horn", 2, ChunkerVanillaItemType.GOAT_HORN, ChunkerItemProperty.HORN_INSTRUMENT, ChunkerHornInstrument.SEEK_GOAT_HORN));
                this.register(ItemMapping.of("minecraft:goat_horn", 3, ChunkerVanillaItemType.GOAT_HORN, ChunkerItemProperty.HORN_INSTRUMENT, ChunkerHornInstrument.FEEL_GOAT_HORN));
                this.register(ItemMapping.of("minecraft:goat_horn", 4, ChunkerVanillaItemType.GOAT_HORN, ChunkerItemProperty.HORN_INSTRUMENT, ChunkerHornInstrument.ADMIRE_GOAT_HORN));
                this.register(ItemMapping.of("minecraft:goat_horn", 5, ChunkerVanillaItemType.GOAT_HORN, ChunkerItemProperty.HORN_INSTRUMENT, ChunkerHornInstrument.CALL_GOAT_HORN));
                this.register(ItemMapping.of("minecraft:goat_horn", 6, ChunkerVanillaItemType.GOAT_HORN, ChunkerItemProperty.HORN_INSTRUMENT, ChunkerHornInstrument.YEARN_GOAT_HORN));
                this.register(ItemMapping.of("minecraft:goat_horn", 7, ChunkerVanillaItemType.GOAT_HORN, ChunkerItemProperty.HORN_INSTRUMENT, ChunkerHornInstrument.DREAM_GOAT_HORN));
            }
        }
        if (version.isGreaterThanOrEqual(1, 18, 0)) {
            this.register(ItemMapping.of("minecraft:music_disc_otherside", ChunkerVanillaItemType.MUSIC_DISC_OTHERSIDE));
            this.registerDuplicateOutput(ItemMapping.of("minecraft:record_otherside", ChunkerVanillaItemType.MUSIC_DISC_OTHERSIDE));
        }
        if (version.isGreaterThanOrEqual(1, 18, 10)) {
            this.register(ItemMapping.of("minecraft:allay_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.ALLAY));
            this.register(ItemMapping.of("minecraft:frog_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.FROG));
            this.register(ItemMapping.of("minecraft:tadpole_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.TADPOLE));
            this.register(ItemMapping.of("minecraft:tadpole_bucket", ChunkerVanillaItemType.TADPOLE_BUCKET));
            this.registerOverrideOutput(ItemMapping.of("minecraft:globe_banner_pattern", ChunkerVanillaItemType.GLOBE_BANNER_PATTERN));
        }
        if (version.isGreaterThanOrEqual(1, 18, 30)) {
            this.register(ItemMapping.of("minecraft:warden_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.WARDEN));
            this.register(ItemMapping.flatten("minecraft:chest_boat", ImmutableMultimap.builder().put(1, ChunkerVanillaItemType.SPRUCE_CHEST_BOAT).put(2, ChunkerVanillaItemType.BIRCH_CHEST_BOAT).put(3, ChunkerVanillaItemType.JUNGLE_CHEST_BOAT).put(4, ChunkerVanillaItemType.ACACIA_CHEST_BOAT).put(5, ChunkerVanillaItemType.DARK_OAK_CHEST_BOAT).build()));
            this.register(ItemMapping.of("minecraft:chest_boat", ChunkerVanillaItemType.OAK_CHEST_BOAT));
            this.registerOverrideOutput(ItemMapping.of("minecraft:acacia_chest_boat", ChunkerVanillaItemType.ACACIA_CHEST_BOAT));
            this.registerOverrideOutput(ItemMapping.of("minecraft:birch_chest_boat", ChunkerVanillaItemType.BIRCH_CHEST_BOAT));
            this.registerOverrideOutput(ItemMapping.of("minecraft:dark_oak_chest_boat", ChunkerVanillaItemType.DARK_OAK_CHEST_BOAT));
            this.registerOverrideOutput(ItemMapping.of("minecraft:jungle_chest_boat", ChunkerVanillaItemType.JUNGLE_CHEST_BOAT));
            this.registerOverrideOutput(ItemMapping.of("minecraft:oak_chest_boat", ChunkerVanillaItemType.OAK_CHEST_BOAT));
            this.registerOverrideOutput(ItemMapping.of("minecraft:spruce_chest_boat", ChunkerVanillaItemType.SPRUCE_CHEST_BOAT));
        }
        if (version.isGreaterThanOrEqual(1, 19, 0)) {
            this.register(ItemMapping.of("minecraft:mangrove_boat", ChunkerVanillaItemType.MANGROVE_BOAT));
            this.register(ItemMapping.of("minecraft:mangrove_chest_boat", ChunkerVanillaItemType.MANGROVE_CHEST_BOAT));
            this.register(ItemMapping.of("minecraft:music_disc_5", ChunkerVanillaItemType.MUSIC_DISC_5));
            this.register(ItemMapping.of("minecraft:mangrove_door", ChunkerVanillaBlockType.MANGROVE_DOOR));
            this.register(ItemMapping.of("minecraft:disc_fragment_5", ChunkerVanillaItemType.DISC_FRAGMENT_5));
            this.register(ItemMapping.of("minecraft:echo_shard", ChunkerVanillaItemType.ECHO_SHARD));
            this.register(ItemMapping.of("minecraft:mangrove_sign", ChunkerVanillaItemType.MANGROVE_SIGN));
            this.register(ItemMapping.of("minecraft:recovery_compass", ChunkerVanillaItemType.RECOVERY_COMPASS));
        }
        if (version.isGreaterThanOrEqual(1, 19, 10)) {
            this.register(ItemMapping.of("minecraft:trader_llama_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.TRADER_LLAMA));
        }
        if (version.isGreaterThanOrEqual(1, 19, 50)) {
            this.register(ItemMapping.of("minecraft:acacia_hanging_sign", ChunkerVanillaItemType.ACACIA_HANGING_SIGN));
            this.register(ItemMapping.of("minecraft:bamboo_hanging_sign", ChunkerVanillaItemType.BAMBOO_HANGING_SIGN));
            this.register(ItemMapping.of("minecraft:birch_hanging_sign", ChunkerVanillaItemType.BIRCH_HANGING_SIGN));
            this.register(ItemMapping.of("minecraft:crimson_hanging_sign", ChunkerVanillaItemType.CRIMSON_HANGING_SIGN));
            this.register(ItemMapping.of("minecraft:dark_oak_hanging_sign", ChunkerVanillaItemType.DARK_OAK_HANGING_SIGN));
            this.register(ItemMapping.of("minecraft:jungle_hanging_sign", ChunkerVanillaItemType.JUNGLE_HANGING_SIGN));
            this.register(ItemMapping.of("minecraft:mangrove_hanging_sign", ChunkerVanillaItemType.MANGROVE_HANGING_SIGN));
            this.register(ItemMapping.of("minecraft:oak_hanging_sign", ChunkerVanillaItemType.OAK_HANGING_SIGN));
            this.register(ItemMapping.of("minecraft:spruce_hanging_sign", ChunkerVanillaItemType.SPRUCE_HANGING_SIGN));
            this.register(ItemMapping.of("minecraft:warped_hanging_sign", ChunkerVanillaItemType.WARPED_HANGING_SIGN));
            this.register(ItemMapping.of("minecraft:bamboo_chest_raft", ChunkerVanillaItemType.BAMBOO_CHEST_RAFT));
            this.register(ItemMapping.of("minecraft:bamboo_raft", ChunkerVanillaItemType.BAMBOO_RAFT));
            this.register(ItemMapping.of("minecraft:bamboo_sign", ChunkerVanillaItemType.BAMBOO_SIGN));
            this.register(ItemMapping.of("minecraft:bamboo_door", ChunkerVanillaBlockType.BAMBOO_DOOR));
            this.register(ItemMapping.of("minecraft:camel_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.CAMEL));
        }
        if (version.isGreaterThanOrEqual(1, 19, 50)) {
            this.register(ItemMapping.of("minecraft:ender_dragon_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.ENDER_DRAGON));
            this.register(ItemMapping.of("minecraft:iron_golem_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.IRON_GOLEM));
            this.register(ItemMapping.of("minecraft:snow_golem_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.SNOW_GOLEM));
            this.register(ItemMapping.of("minecraft:wither_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.WITHER));
            this.register(ItemMapping.of("minecraft:sniffer_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.SNIFFER));
        }
        if (version.isGreaterThanOrEqual(1, 19, 70)) {
            this.register(ItemMapping.of("minecraft:brush", ChunkerVanillaItemType.BRUSH));
            this.register(ItemMapping.of("minecraft:torchflower_seeds", ChunkerVanillaItemType.TORCHFLOWER_SEEDS));
            this.register(ItemMapping.of("minecraft:archer_pottery_shard", ChunkerVanillaItemType.ARCHER_POTTERY_SHERD));
            this.register(ItemMapping.of("minecraft:arms_up_pottery_shard", ChunkerVanillaItemType.ARMS_UP_POTTERY_SHERD));
            this.register(ItemMapping.of("minecraft:prize_pottery_shard", ChunkerVanillaItemType.PRIZE_POTTERY_SHERD));
            this.register(ItemMapping.of("minecraft:skull_pottery_shard", ChunkerVanillaItemType.SKULL_POTTERY_SHERD));
        }
        if (version.isGreaterThanOrEqual(1, 19, 80)) {
            this.register(ItemMapping.of("minecraft:cherry_door", ChunkerVanillaBlockType.CHERRY_DOOR));
            this.register(ItemMapping.of("minecraft:cherry_hanging_sign", ChunkerVanillaItemType.CHERRY_HANGING_SIGN));
            this.register(ItemMapping.of("minecraft:cherry_boat", ChunkerVanillaItemType.CHERRY_BOAT));
            this.register(ItemMapping.of("minecraft:cherry_chest_boat", ChunkerVanillaItemType.CHERRY_CHEST_BOAT));
            this.register(ItemMapping.of("minecraft:cherry_sign", ChunkerVanillaItemType.CHERRY_SIGN));
            this.register(ItemMapping.of("minecraft:coast_armor_trim_smithing_template", ChunkerVanillaItemType.COAST_ARMOR_TRIM_SMITHING_TEMPLATE));
            this.register(ItemMapping.of("minecraft:dune_armor_trim_smithing_template", ChunkerVanillaItemType.DUNE_ARMOR_TRIM_SMITHING_TEMPLATE));
            this.register(ItemMapping.of("minecraft:eye_armor_trim_smithing_template", ChunkerVanillaItemType.EYE_ARMOR_TRIM_SMITHING_TEMPLATE));
            this.register(ItemMapping.of("minecraft:host_armor_trim_smithing_template", ChunkerVanillaItemType.HOST_ARMOR_TRIM_SMITHING_TEMPLATE));
            this.register(ItemMapping.of("minecraft:netherite_upgrade_smithing_template", ChunkerVanillaItemType.NETHERITE_UPGRADE_SMITHING_TEMPLATE));
            this.register(ItemMapping.of("minecraft:raiser_armor_trim_smithing_template", ChunkerVanillaItemType.RAISER_ARMOR_TRIM_SMITHING_TEMPLATE));
            this.register(ItemMapping.of("minecraft:rib_armor_trim_smithing_template", ChunkerVanillaItemType.RIB_ARMOR_TRIM_SMITHING_TEMPLATE));
            this.register(ItemMapping.of("minecraft:sentry_armor_trim_smithing_template", ChunkerVanillaItemType.SENTRY_ARMOR_TRIM_SMITHING_TEMPLATE));
            this.register(ItemMapping.of("minecraft:shaper_armor_trim_smithing_template", ChunkerVanillaItemType.SHAPER_ARMOR_TRIM_SMITHING_TEMPLATE));
            this.register(ItemMapping.of("minecraft:silence_armor_trim_smithing_template", ChunkerVanillaItemType.SILENCE_ARMOR_TRIM_SMITHING_TEMPLATE));
            this.register(ItemMapping.of("minecraft:snout_armor_trim_smithing_template", ChunkerVanillaItemType.SNOUT_ARMOR_TRIM_SMITHING_TEMPLATE));
            this.register(ItemMapping.of("minecraft:spire_armor_trim_smithing_template", ChunkerVanillaItemType.SPIRE_ARMOR_TRIM_SMITHING_TEMPLATE));
            this.register(ItemMapping.of("minecraft:tide_armor_trim_smithing_template", ChunkerVanillaItemType.TIDE_ARMOR_TRIM_SMITHING_TEMPLATE));
            this.register(ItemMapping.of("minecraft:vex_armor_trim_smithing_template", ChunkerVanillaItemType.VEX_ARMOR_TRIM_SMITHING_TEMPLATE));
            this.register(ItemMapping.of("minecraft:ward_armor_trim_smithing_template", ChunkerVanillaItemType.WARD_ARMOR_TRIM_SMITHING_TEMPLATE));
            this.register(ItemMapping.of("minecraft:wayfinder_armor_trim_smithing_template", ChunkerVanillaItemType.WAYFINDER_ARMOR_TRIM_SMITHING_TEMPLATE));
            this.register(ItemMapping.of("minecraft:wild_armor_trim_smithing_template", ChunkerVanillaItemType.WILD_ARMOR_TRIM_SMITHING_TEMPLATE));
            this.register(ItemMapping.of("minecraft:angler_pottery_shard", ChunkerVanillaItemType.ANGLER_POTTERY_SHERD));
            this.register(ItemMapping.of("minecraft:blade_pottery_shard", ChunkerVanillaItemType.BLADE_POTTERY_SHERD));
            this.register(ItemMapping.of("minecraft:brewer_pottery_shard", ChunkerVanillaItemType.BREWER_POTTERY_SHERD));
            this.register(ItemMapping.of("minecraft:burn_pottery_shard", ChunkerVanillaItemType.BURN_POTTERY_SHERD));
            this.register(ItemMapping.of("minecraft:danger_pottery_shard", ChunkerVanillaItemType.DANGER_POTTERY_SHERD));
            this.register(ItemMapping.of("minecraft:explorer_pottery_shard", ChunkerVanillaItemType.EXPLORER_POTTERY_SHERD));
            this.register(ItemMapping.of("minecraft:friend_pottery_shard", ChunkerVanillaItemType.FRIEND_POTTERY_SHERD));
            this.register(ItemMapping.of("minecraft:heart_pottery_shard", ChunkerVanillaItemType.HEART_POTTERY_SHERD));
            this.register(ItemMapping.of("minecraft:heartbreak_pottery_shard", ChunkerVanillaItemType.HEARTBREAK_POTTERY_SHERD));
            this.register(ItemMapping.of("minecraft:howl_pottery_shard", ChunkerVanillaItemType.HOWL_POTTERY_SHERD));
            this.register(ItemMapping.of("minecraft:miner_pottery_shard", ChunkerVanillaItemType.MINER_POTTERY_SHERD));
            this.register(ItemMapping.of("minecraft:mourner_pottery_shard", ChunkerVanillaItemType.MOURNER_POTTERY_SHERD));
            this.register(ItemMapping.of("minecraft:plenty_pottery_shard", ChunkerVanillaItemType.PLENTY_POTTERY_SHERD));
            this.register(ItemMapping.of("minecraft:sheaf_pottery_shard", ChunkerVanillaItemType.SHEAF_POTTERY_SHERD));
            this.register(ItemMapping.of("minecraft:shelter_pottery_shard", ChunkerVanillaItemType.SHELTER_POTTERY_SHERD));
            this.register(ItemMapping.of("minecraft:snort_pottery_shard", ChunkerVanillaItemType.SNORT_POTTERY_SHERD));
        }
        if (version.isGreaterThanOrEqual(1, 20, 0)) {
            this.registerOverrideOutput(ItemMapping.of("minecraft:archer_pottery_sherd", ChunkerVanillaItemType.ARCHER_POTTERY_SHERD));
            this.registerOverrideOutput(ItemMapping.of("minecraft:arms_up_pottery_sherd", ChunkerVanillaItemType.ARMS_UP_POTTERY_SHERD));
            this.registerOverrideOutput(ItemMapping.of("minecraft:prize_pottery_sherd", ChunkerVanillaItemType.PRIZE_POTTERY_SHERD));
            this.registerOverrideOutput(ItemMapping.of("minecraft:skull_pottery_sherd", ChunkerVanillaItemType.SKULL_POTTERY_SHERD));
            this.registerOverrideOutput(ItemMapping.of("minecraft:angler_pottery_sherd", ChunkerVanillaItemType.ANGLER_POTTERY_SHERD));
            this.registerOverrideOutput(ItemMapping.of("minecraft:blade_pottery_sherd", ChunkerVanillaItemType.BLADE_POTTERY_SHERD));
            this.registerOverrideOutput(ItemMapping.of("minecraft:brewer_pottery_sherd", ChunkerVanillaItemType.BREWER_POTTERY_SHERD));
            this.registerOverrideOutput(ItemMapping.of("minecraft:burn_pottery_sherd", ChunkerVanillaItemType.BURN_POTTERY_SHERD));
            this.registerOverrideOutput(ItemMapping.of("minecraft:danger_pottery_sherd", ChunkerVanillaItemType.DANGER_POTTERY_SHERD));
            this.registerOverrideOutput(ItemMapping.of("minecraft:explorer_pottery_sherd", ChunkerVanillaItemType.EXPLORER_POTTERY_SHERD));
            this.registerOverrideOutput(ItemMapping.of("minecraft:friend_pottery_sherd", ChunkerVanillaItemType.FRIEND_POTTERY_SHERD));
            this.registerOverrideOutput(ItemMapping.of("minecraft:heart_pottery_sherd", ChunkerVanillaItemType.HEART_POTTERY_SHERD));
            this.registerOverrideOutput(ItemMapping.of("minecraft:heartbreak_pottery_sherd", ChunkerVanillaItemType.HEARTBREAK_POTTERY_SHERD));
            this.registerOverrideOutput(ItemMapping.of("minecraft:howl_pottery_sherd", ChunkerVanillaItemType.HOWL_POTTERY_SHERD));
            this.registerOverrideOutput(ItemMapping.of("minecraft:miner_pottery_sherd", ChunkerVanillaItemType.MINER_POTTERY_SHERD));
            this.registerOverrideOutput(ItemMapping.of("minecraft:mourner_pottery_sherd", ChunkerVanillaItemType.MOURNER_POTTERY_SHERD));
            this.registerOverrideOutput(ItemMapping.of("minecraft:plenty_pottery_sherd", ChunkerVanillaItemType.PLENTY_POTTERY_SHERD));
            this.registerOverrideOutput(ItemMapping.of("minecraft:sheaf_pottery_sherd", ChunkerVanillaItemType.SHEAF_POTTERY_SHERD));
            this.registerOverrideOutput(ItemMapping.of("minecraft:shelter_pottery_sherd", ChunkerVanillaItemType.SHELTER_POTTERY_SHERD));
            this.registerOverrideOutput(ItemMapping.of("minecraft:snort_pottery_sherd", ChunkerVanillaItemType.SNORT_POTTERY_SHERD));
            this.register(ItemMapping.of("minecraft:pitcher_pod", ChunkerVanillaItemType.PITCHER_POD));
            this.register(ItemMapping.of("minecraft:music_disc_relic", ChunkerVanillaItemType.MUSIC_DISC_RELIC));
        }
        if (version.isGreaterThanOrEqual(1, 20, 50)) {
            this.register(ItemMapping.of("minecraft:copper_door", ChunkerVanillaBlockType.COPPER_DOOR));
            this.register(ItemMapping.of("minecraft:exposed_copper_door", ChunkerVanillaBlockType.EXPOSED_COPPER_DOOR));
            this.register(ItemMapping.of("minecraft:oxidized_copper_door", ChunkerVanillaBlockType.OXIDIZED_COPPER_DOOR));
            this.register(ItemMapping.of("minecraft:waxed_copper_door", ChunkerVanillaBlockType.WAXED_COPPER_DOOR));
            this.register(ItemMapping.of("minecraft:weathered_copper_door", ChunkerVanillaBlockType.WEATHERED_COPPER_DOOR));
            this.register(ItemMapping.of("minecraft:waxed_exposed_copper_door", ChunkerVanillaBlockType.WAXED_EXPOSED_COPPER_DOOR));
            this.register(ItemMapping.of("minecraft:waxed_oxidized_copper_door", ChunkerVanillaBlockType.WAXED_OXIDIZED_COPPER_DOOR));
            this.register(ItemMapping.of("minecraft:waxed_weathered_copper_door", ChunkerVanillaBlockType.WAXED_WEATHERED_COPPER_DOOR));
        }
        if (version.isGreaterThanOrEqual(1, 20, 60)) {
            this.register(ItemMapping.of("minecraft:armadillo_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.ARMADILLO));
            this.register(ItemMapping.of("minecraft:breeze_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.BREEZE));
            this.register(ItemMapping.of("minecraft:trial_key", ChunkerVanillaItemType.TRIAL_KEY));
            this.register(ItemMapping.of("minecraft:armadillo_scute", ChunkerVanillaItemType.ARMADILLO_SCUTE));
            this.register(ItemMapping.of("minecraft:wolf_armor", ChunkerVanillaItemType.WOLF_ARMOR));
            this.registerOverrideOutput(ItemMapping.of("minecraft:turtle_scute", ChunkerVanillaItemType.TURTLE_SCUTE));
        }
        if (version.isGreaterThanOrEqual(1, 20, 70)) {
            this.register(ItemMapping.of("minecraft:bogged_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.BOGGED));
            this.register(ItemMapping.of("minecraft:wind_charge", ChunkerVanillaItemType.WIND_CHARGE));
        }
        if (version.isGreaterThanOrEqual(1, 20, 80)) {
            this.register(ItemMapping.of("minecraft:breeze_rod", ChunkerVanillaItemType.BREEZE_ROD));
            this.register(ItemMapping.of("minecraft:mace", ChunkerVanillaItemType.MACE));
            this.register(ItemMapping.of("minecraft:flow_pottery_sherd", ChunkerVanillaItemType.FLOW_POTTERY_SHERD));
            this.register(ItemMapping.of("minecraft:guster_pottery_sherd", ChunkerVanillaItemType.GUSTER_POTTERY_SHERD));
            this.register(ItemMapping.of("minecraft:scrape_pottery_sherd", ChunkerVanillaItemType.SCRAPE_POTTERY_SHERD));
            this.register(ItemMapping.of("minecraft:flow_banner_pattern", ChunkerVanillaItemType.FLOW_BANNER_PATTERN));
            this.register(ItemMapping.of("minecraft:guster_banner_pattern", ChunkerVanillaItemType.GUSTER_BANNER_PATTERN));
            this.register(ItemMapping.of("minecraft:bolt_armor_trim_smithing_template", ChunkerVanillaItemType.BOLT_ARMOR_TRIM_SMITHING_TEMPLATE));
            this.register(ItemMapping.of("minecraft:flow_armor_trim_smithing_template", ChunkerVanillaItemType.FLOW_ARMOR_TRIM_SMITHING_TEMPLATE));
        }
        if (version.isGreaterThanOrEqual(1, 21, 0)) {
            this.register(ItemMapping.of("minecraft:music_disc_creator", ChunkerVanillaItemType.MUSIC_DISC_CREATOR));
            this.register(ItemMapping.of("minecraft:music_disc_creator_music_box", ChunkerVanillaItemType.MUSIC_DISC_CREATOR_MUSIC_BOX));
            this.register(ItemMapping.of("minecraft:music_disc_precipice", ChunkerVanillaItemType.MUSIC_DISC_PRECIPICE));
            this.register(ItemMapping.of("minecraft:ominous_bottle", ChunkerVanillaItemType.OMINOUS_BOTTLE));
            this.register(ItemMapping.of("minecraft:ominous_bottle", 0, ChunkerVanillaItemType.OMINOUS_BOTTLE, ChunkerItemProperty.OMINOUS_BOTTLE_AMPLIFIER, 0));
            this.register(ItemMapping.of("minecraft:ominous_bottle", 1, ChunkerVanillaItemType.OMINOUS_BOTTLE, ChunkerItemProperty.OMINOUS_BOTTLE_AMPLIFIER, 1));
            this.register(ItemMapping.of("minecraft:ominous_bottle", 2, ChunkerVanillaItemType.OMINOUS_BOTTLE, ChunkerItemProperty.OMINOUS_BOTTLE_AMPLIFIER, 2));
            this.register(ItemMapping.of("minecraft:ominous_bottle", 3, ChunkerVanillaItemType.OMINOUS_BOTTLE, ChunkerItemProperty.OMINOUS_BOTTLE_AMPLIFIER, 3));
            this.register(ItemMapping.of("minecraft:ominous_bottle", 4, ChunkerVanillaItemType.OMINOUS_BOTTLE, ChunkerItemProperty.OMINOUS_BOTTLE_AMPLIFIER, 4));
            this.register(ItemMapping.of("minecraft:ominous_trial_key", ChunkerVanillaItemType.OMINOUS_TRIAL_KEY));
        }
        if (version.isGreaterThanOrEqual(1, 21, 40)) {
            this.registerOverrideOutput(ItemMapping.group(ImmutableMultimap.builder().put("minecraft:skeleton_skull", ChunkerVanillaBlockType.SKELETON_SKULL).put("minecraft:zombie_head", ChunkerVanillaBlockType.ZOMBIE_HEAD).put("minecraft:player_head", ChunkerVanillaBlockType.PLAYER_HEAD).put("minecraft:creeper_head", ChunkerVanillaBlockType.CREEPER_HEAD).put("minecraft:wither_skeleton_skull", ChunkerVanillaBlockType.WITHER_SKELETON_SKULL).put("minecraft:dragon_head", ChunkerVanillaBlockType.DRAGON_HEAD).put("minecraft:piglin_head", ChunkerVanillaBlockType.PIGLIN_HEAD).build()));
            this.register(ItemMapping.of("minecraft:bundle", ChunkerVanillaItemType.BUNDLE));
            this.register(ItemMapping.of("minecraft:black_bundle", ChunkerVanillaItemType.BLACK_BUNDLE));
            this.register(ItemMapping.of("minecraft:blue_bundle", ChunkerVanillaItemType.BLUE_BUNDLE));
            this.register(ItemMapping.of("minecraft:brown_bundle", ChunkerVanillaItemType.BROWN_BUNDLE));
            this.register(ItemMapping.of("minecraft:cyan_bundle", ChunkerVanillaItemType.CYAN_BUNDLE));
            this.register(ItemMapping.of("minecraft:gray_bundle", ChunkerVanillaItemType.GRAY_BUNDLE));
            this.register(ItemMapping.of("minecraft:green_bundle", ChunkerVanillaItemType.GREEN_BUNDLE));
            this.register(ItemMapping.of("minecraft:light_blue_bundle", ChunkerVanillaItemType.LIGHT_BLUE_BUNDLE));
            this.register(ItemMapping.of("minecraft:light_gray_bundle", ChunkerVanillaItemType.LIGHT_GRAY_BUNDLE));
            this.register(ItemMapping.of("minecraft:lime_bundle", ChunkerVanillaItemType.LIME_BUNDLE));
            this.register(ItemMapping.of("minecraft:magenta_bundle", ChunkerVanillaItemType.MAGENTA_BUNDLE));
            this.register(ItemMapping.of("minecraft:orange_bundle", ChunkerVanillaItemType.ORANGE_BUNDLE));
            this.register(ItemMapping.of("minecraft:pink_bundle", ChunkerVanillaItemType.PINK_BUNDLE));
            this.register(ItemMapping.of("minecraft:purple_bundle", ChunkerVanillaItemType.PURPLE_BUNDLE));
            this.register(ItemMapping.of("minecraft:red_bundle", ChunkerVanillaItemType.RED_BUNDLE));
            this.register(ItemMapping.of("minecraft:white_bundle", ChunkerVanillaItemType.WHITE_BUNDLE));
            this.register(ItemMapping.of("minecraft:yellow_bundle", ChunkerVanillaItemType.YELLOW_BUNDLE));
        }
        if (version.isGreaterThanOrEqual(1, 21, 50)) {
            this.register(ItemMapping.of("minecraft:creaking_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.CREAKING));
            this.register(ItemMapping.of("minecraft:pale_oak_hanging_sign", ChunkerVanillaItemType.PALE_OAK_HANGING_SIGN));
            this.register(ItemMapping.of("minecraft:pale_oak_sign", ChunkerVanillaItemType.PALE_OAK_SIGN));
            this.register(ItemMapping.of("minecraft:pale_oak_door", ChunkerVanillaBlockType.PALE_OAK_DOOR));
            this.register(ItemMapping.of("minecraft:pale_oak_boat", ChunkerVanillaItemType.PALE_OAK_BOAT));
            this.register(ItemMapping.of("minecraft:pale_oak_chest_boat", ChunkerVanillaItemType.PALE_OAK_CHEST_BOAT));
            this.register(ItemMapping.of("minecraft:resin_brick", ChunkerVanillaItemType.RESIN_BRICK));
        }
        if (version.isGreaterThanOrEqual(1, 21, 70)) {
            this.register(ItemMapping.of("minecraft:blue_egg", ChunkerVanillaItemType.BLUE_EGG));
            this.register(ItemMapping.of("minecraft:brown_egg", ChunkerVanillaItemType.BROWN_EGG));
        }
        if (version.isGreaterThanOrEqual(1, 21, 80)) {
            this.register(ItemMapping.of("minecraft:happy_ghast_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.HAPPY_GHAST));
            this.register(ItemMapping.of("minecraft:black_harness", ChunkerVanillaItemType.BLACK_HARNESS));
            this.register(ItemMapping.of("minecraft:blue_harness", ChunkerVanillaItemType.BLUE_HARNESS));
            this.register(ItemMapping.of("minecraft:brown_harness", ChunkerVanillaItemType.BROWN_HARNESS));
            this.register(ItemMapping.of("minecraft:cyan_harness", ChunkerVanillaItemType.CYAN_HARNESS));
            this.register(ItemMapping.of("minecraft:gray_harness", ChunkerVanillaItemType.GRAY_HARNESS));
            this.register(ItemMapping.of("minecraft:green_harness", ChunkerVanillaItemType.GREEN_HARNESS));
            this.register(ItemMapping.of("minecraft:light_blue_harness", ChunkerVanillaItemType.LIGHT_BLUE_HARNESS));
            this.register(ItemMapping.of("minecraft:light_gray_harness", ChunkerVanillaItemType.LIGHT_GRAY_HARNESS));
            this.register(ItemMapping.of("minecraft:lime_harness", ChunkerVanillaItemType.LIME_HARNESS));
            this.register(ItemMapping.of("minecraft:magenta_harness", ChunkerVanillaItemType.MAGENTA_HARNESS));
            this.register(ItemMapping.of("minecraft:orange_harness", ChunkerVanillaItemType.ORANGE_HARNESS));
            this.register(ItemMapping.of("minecraft:pink_harness", ChunkerVanillaItemType.PINK_HARNESS));
            this.register(ItemMapping.of("minecraft:purple_harness", ChunkerVanillaItemType.PURPLE_HARNESS));
            this.register(ItemMapping.of("minecraft:red_harness", ChunkerVanillaItemType.RED_HARNESS));
            this.register(ItemMapping.of("minecraft:white_harness", ChunkerVanillaItemType.WHITE_HARNESS));
            this.register(ItemMapping.of("minecraft:yellow_harness", ChunkerVanillaItemType.YELLOW_HARNESS));
        }
        if (version.isGreaterThanOrEqual(1, 21, 90)) {
            this.register(ItemMapping.of("minecraft:music_disc_tears", ChunkerVanillaItemType.MUSIC_DISC_TEARS));
        }
        if (version.isGreaterThanOrEqual(1, 21, 93)) {
            this.register(ItemMapping.of("minecraft:music_disc_lava_chicken", ChunkerVanillaItemType.MUSIC_DISC_LAVA_CHICKEN));
        }
        if (version.isGreaterThanOrEqual(1, 21, 100)) {
            this.register(ItemMapping.of("minecraft:copper_nugget", ChunkerVanillaItemType.COPPER_NUGGET));
            this.register(ItemMapping.of("minecraft:copper_golem_spawn_egg", ChunkerVanillaItemType.SPAWN_EGG, ChunkerItemProperty.SPAWN_EGG_MOB, ChunkerVanillaEntityType.COPPER_GOLEM));
            this.register(ItemMapping.of("minecraft:copper_axe", ChunkerVanillaItemType.COPPER_AXE));
            this.register(ItemMapping.of("minecraft:copper_hoe", ChunkerVanillaItemType.COPPER_HOE));
            this.register(ItemMapping.of("minecraft:copper_pickaxe", ChunkerVanillaItemType.COPPER_PICKAXE));
            this.register(ItemMapping.of("minecraft:copper_shovel", ChunkerVanillaItemType.COPPER_SHOVEL));
            this.register(ItemMapping.of("minecraft:copper_sword", ChunkerVanillaItemType.COPPER_SWORD));
            this.register(ItemMapping.of("minecraft:copper_boots", ChunkerVanillaItemType.COPPER_BOOTS));
            this.register(ItemMapping.of("minecraft:copper_chestplate", ChunkerVanillaItemType.COPPER_CHESTPLATE));
            this.register(ItemMapping.of("minecraft:copper_helmet", ChunkerVanillaItemType.COPPER_HELMET));
            this.register(ItemMapping.of("minecraft:copper_leggings", ChunkerVanillaItemType.COPPER_LEGGINGS));
        }
        if (version.isGreaterThanOrEqual(1, 21, 110)) {
            this.register(ItemMapping.of("minecraft:copper_horse_armor", ChunkerVanillaItemType.COPPER_HORSE_ARMOR));
        }
    }
}

