/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.entity.handlers;

import com.hivemc.chunker.conversion.encoding.base.resolver.entity.EntityHandler;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.BedrockResolvers;
import com.hivemc.chunker.conversion.handlers.pretransform.Edge;
import com.hivemc.chunker.conversion.handlers.pretransform.manager.handler.entity.EntityPreTransformHandler;
import com.hivemc.chunker.conversion.intermediate.column.ChunkerColumn;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.states.vanilla.types.FacingDirectionHorizontal;
import com.hivemc.chunker.conversion.intermediate.column.entity.PaintingEntity;
import com.hivemc.chunker.conversion.intermediate.column.entity.type.ChunkerVanillaEntityType;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import com.hivemc.chunker.util.Vec3;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class BedrockPaintingEntityHandler
extends EntityHandler<BedrockResolvers, CompoundTag, PaintingEntity> {
    public BedrockPaintingEntityHandler() {
        super(ChunkerVanillaEntityType.PAINTING, PaintingEntity.class, PaintingEntity::new);
    }

    public static Vec3 getChunkerTilePositionOffset(PaintingEntity entity) {
        int width = entity.getMotive().getWidth();
        int height = entity.getMotive().getHeight();
        return new Vec3(entity.getDirection() == FacingDirectionHorizontal.SOUTH && width % 2 == 0 ? -1.0 : 0.0, height % 2 == 0 ? -1.0 : 0.0, entity.getDirection() == FacingDirectionHorizontal.WEST && width % 2 == 0 ? -1.0 : 0.0);
    }

    public static Vec3 getChunkerPositionOffset(PaintingEntity entity) {
        int width = entity.getMotive().getWidth();
        int height = entity.getMotive().getHeight();
        double yValue = height % 2 == 0 ? 0.0 : -0.5;
        return switch (entity.getDirection()) {
            default -> throw new IncompatibleClassChangeError();
            case FacingDirectionHorizontal.NORTH -> new Vec3(width % 2 == 0 ? 0.0 : -0.5, yValue, -0.96875);
            case FacingDirectionHorizontal.EAST -> new Vec3(-0.03125, yValue, width % 2 == 0 ? 0.0 : -0.5);
            case FacingDirectionHorizontal.SOUTH -> new Vec3(width % 2 == 0 ? 0.0 : -0.5, yValue, -0.03125);
            case FacingDirectionHorizontal.WEST -> new Vec3(-0.96875, yValue, width % 2 == 0 ? 0.0 : -0.5);
        };
    }

    @Override
    public void read(@NotNull BedrockResolvers resolvers, @NotNull CompoundTag input, @NotNull PaintingEntity value) {
        String motive = input.getString("Motif", null);
        if (motive == null) {
            motive = input.getString("Motive", "Kebab");
        }
        value.setMotive(resolvers.readPaintingMotive(motive));
        value.setDirection(FacingDirectionHorizontal.from2DByte(input.getByte("Direction", (byte)0)));
    }

    @Override
    public void write(@NotNull BedrockResolvers resolvers, @NotNull CompoundTag output, @NotNull PaintingEntity value) {
        if (resolvers.dataVersion().getVersion().isGreaterThan(1, 20, 60)) {
            output.put("Motif", resolvers.writePaintingMotive(value.getMotive()));
        } else {
            output.put("Motive", resolvers.writePaintingMotive(value.getMotive()));
        }
        output.put("Direction", value.getDirection() == null ? (byte)0 : value.getDirection().to2DByte());
    }

    public static class Relocator
    implements EntityPreTransformHandler<PaintingEntity> {
        private final boolean inverse;

        public Relocator(boolean inverse) {
            this.inverse = inverse;
        }

        @Override
        public Class<PaintingEntity> getHandledType() {
            return PaintingEntity.class;
        }

        @Override
        public Set<Edge> getRequiredEdges(ChunkerColumn column, PaintingEntity entity) {
            double positionZ;
            double positionX;
            Vec3 tileOffset = BedrockPaintingEntityHandler.getChunkerTilePositionOffset(entity);
            Vec3 positionOffset = BedrockPaintingEntityHandler.getChunkerPositionOffset(entity);
            int tileX = entity.getTileX();
            int tileZ = entity.getTileZ();
            if (this.inverse) {
                tileX = (int)((double)tileX - tileOffset.x());
                tileZ = (int)((double)tileZ - tileOffset.z());
                positionX = (double)tileX - positionOffset.x();
                positionZ = (double)tileZ - positionOffset.z();
            } else {
                positionX = entity.getPositionX() + positionOffset.x();
                positionZ = entity.getPositionZ() + positionOffset.z();
            }
            int chunkX = (int)Math.floor(positionX) >> 4;
            int chunkZ = (int)Math.floor(positionZ) >> 4;
            Edge edge = Edge.fromOffset(column.getPosition().chunkX() - chunkX, column.getPosition().chunkZ() - chunkZ);
            return edge == null ? Collections.emptySet() : EnumSet.of(edge);
        }

        @Override
        public boolean handle(ChunkerColumn column, Map<Edge, ChunkerColumn> neighbours, PaintingEntity entity) {
            ChunkerColumn newColumn;
            double positionZ;
            double positionY;
            double positionX;
            Vec3 tileOffset = BedrockPaintingEntityHandler.getChunkerTilePositionOffset(entity);
            Vec3 positionOffset = BedrockPaintingEntityHandler.getChunkerPositionOffset(entity);
            int tileX = entity.getTileX();
            int tileY = entity.getTileY();
            int tileZ = entity.getTileZ();
            if (this.inverse) {
                tileX = (int)((double)tileX - tileOffset.x());
                tileY = (int)((double)tileY - tileOffset.y());
                tileZ = (int)((double)tileZ - tileOffset.z());
                positionX = (double)tileX - positionOffset.x();
                positionY = (double)tileY - positionOffset.y();
                positionZ = (double)tileZ - positionOffset.z();
            } else {
                positionX = entity.getPositionX() + positionOffset.x();
                positionY = entity.getPositionY() + positionOffset.y();
                positionZ = entity.getPositionZ() + positionOffset.z();
                tileX = (int)Math.floor(positionX + tileOffset.x());
                tileY = (int)Math.floor(positionY + tileOffset.y());
                tileZ = (int)Math.floor(positionZ + tileOffset.z());
            }
            entity.setTileX(tileX);
            entity.setTileY(tileY);
            entity.setTileZ(tileZ);
            entity.setPositionX(positionX);
            entity.setPositionY(positionY);
            entity.setPositionZ(positionZ);
            int chunkX = (int)Math.floor(positionX) >> 4;
            int chunkZ = (int)Math.floor(positionZ) >> 4;
            Edge edge = Edge.fromOffset(column.getPosition().chunkX() - chunkX, column.getPosition().chunkZ() - chunkZ);
            if (edge != null && (newColumn = neighbours.get((Object)edge)) != null) {
                newColumn.getEntities().add(entity);
                return true;
            }
            return false;
        }
    }
}

