/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.entity.handlers;

import com.hivemc.chunker.conversion.encoding.base.resolver.entity.EntityHandler;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.BedrockResolvers;
import com.hivemc.chunker.conversion.intermediate.column.entity.Entity;
import com.hivemc.chunker.nbt.TagType;
import com.hivemc.chunker.nbt.tags.Tag;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import com.hivemc.chunker.nbt.tags.collection.ListTag;
import com.hivemc.chunker.nbt.tags.primitive.FloatTag;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class BedrockEntityHandler
extends EntityHandler<BedrockResolvers, CompoundTag, Entity> {
    public BedrockEntityHandler() {
        super(null, Entity.class, () -> {
            throw new IllegalArgumentException("Unable to construct Entity, invalid type!");
        });
    }

    @Override
    public void read(@NotNull BedrockResolvers resolvers, @NotNull CompoundTag input, @NotNull Entity entity) {
        List rotation;
        List motion;
        List position;
        if (resolvers.converter().shouldAllowNBTCopying()) {
            entity.setOriginalNBT(input);
        }
        if ((position = input.getListValues("Pos", FloatTag.class, null)) != null && position.size() >= 3) {
            entity.setPositionX(((Float)position.get(0)).floatValue());
            entity.setPositionY(((Float)position.get(1)).floatValue());
            entity.setPositionZ(((Float)position.get(2)).floatValue());
        }
        if ((motion = input.getListValues("Motion", FloatTag.class, null)) != null && motion.size() >= 3) {
            entity.setMotionX(((Float)motion.get(0)).floatValue());
            entity.setMotionY(((Float)motion.get(1)).floatValue());
            entity.setMotionZ(((Float)motion.get(2)).floatValue());
        }
        if ((rotation = input.getListValues("Rotation", FloatTag.class, null)) != null && rotation.size() >= 2) {
            entity.setYaw(((Float)rotation.get(0)).floatValue());
            entity.setPitch(((Float)rotation.get(1)).floatValue());
        }
    }

    @Override
    public void write(@NotNull BedrockResolvers resolvers, @NotNull CompoundTag output, @NotNull Entity entity) {
        if (resolvers.converter().shouldAllowNBTCopying() && entity.getOriginalNBT() != null) {
            for (Map.Entry<String, Tag<?>> namedPair : entity.getOriginalNBT()) {
                output.put(namedPair.getKey(), (Tag<?>)namedPair.getValue().clone());
            }
        }
        ListTag<FloatTag, Float> pos = new ListTag<FloatTag, Float>(TagType.FLOAT, 3);
        pos.add(new FloatTag((float)entity.getPositionX()));
        pos.add(new FloatTag((float)entity.getPositionY()));
        pos.add(new FloatTag((float)entity.getPositionZ()));
        output.put("Pos", pos);
        ListTag<FloatTag, Float> motion = new ListTag<FloatTag, Float>(TagType.FLOAT, 3);
        motion.add(new FloatTag((float)entity.getMotionX()));
        motion.add(new FloatTag((float)entity.getMotionY()));
        motion.add(new FloatTag((float)entity.getMotionZ()));
        output.put("Motion", motion);
        ListTag<FloatTag, Float> rotation = new ListTag<FloatTag, Float>(TagType.FLOAT, 2);
        rotation.add(new FloatTag(entity.getYaw()));
        rotation.add(new FloatTag(entity.getPitch()));
        output.put("Rotation", rotation);
    }
}

