/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.blockentity.handlers;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.hivemc.chunker.conversion.encoding.base.resolver.blockentity.BlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.base.resolver.blockentity.UpdateBeforeProcessBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.base.resolver.blockentity.UpdateBeforeWriteBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.BedrockResolvers;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.blockentity.type.BedrockSkullBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.ChunkerColumn;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.SkullBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.ChunkerBlockIdentifier;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.ChunkerBlockType;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.ChunkerVanillaBlockType;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.states.vanilla.VanillaBlockStates;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.states.vanilla.types.Bool;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.states.vanilla.types.Rotation;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.ChunkerItemStack;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import org.jetbrains.annotations.NotNull;

public class BedrockSkullBlockEntityHandler
extends BlockEntityHandler<BedrockResolvers, CompoundTag, BedrockSkullBlockEntity>
implements UpdateBeforeWriteBlockEntityHandler<BedrockResolvers, SkullBlockEntity>,
UpdateBeforeProcessBlockEntityHandler<BedrockResolvers, SkullBlockEntity> {
    public static final BiMap<ChunkerBlockType, Pair<Byte, Boolean>> SKULL_TO_ID = ((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)((ImmutableBiMap.Builder)ImmutableBiMap.builder().put(ChunkerVanillaBlockType.SKELETON_SKULL, Pair.of((byte)0, false))).put(ChunkerVanillaBlockType.SKELETON_WALL_SKULL, Pair.of((byte)0, true))).put(ChunkerVanillaBlockType.WITHER_SKELETON_SKULL, Pair.of((byte)1, false))).put(ChunkerVanillaBlockType.WITHER_SKELETON_WALL_SKULL, Pair.of((byte)1, true))).put(ChunkerVanillaBlockType.ZOMBIE_HEAD, Pair.of((byte)2, false))).put(ChunkerVanillaBlockType.ZOMBIE_WALL_HEAD, Pair.of((byte)2, true))).put(ChunkerVanillaBlockType.PLAYER_HEAD, Pair.of((byte)3, false))).put(ChunkerVanillaBlockType.PLAYER_WALL_HEAD, Pair.of((byte)3, true))).put(ChunkerVanillaBlockType.CREEPER_HEAD, Pair.of((byte)4, false))).put(ChunkerVanillaBlockType.CREEPER_WALL_HEAD, Pair.of((byte)4, true))).put(ChunkerVanillaBlockType.DRAGON_HEAD, Pair.of((byte)5, false))).put(ChunkerVanillaBlockType.DRAGON_WALL_HEAD, Pair.of((byte)5, true))).put(ChunkerVanillaBlockType.PIGLIN_HEAD, Pair.of((byte)6, false))).put(ChunkerVanillaBlockType.PIGLIN_WALL_HEAD, Pair.of((byte)6, true))).build();

    public BedrockSkullBlockEntityHandler() {
        super("Skull", BedrockSkullBlockEntity.class, BedrockSkullBlockEntity::new);
    }

    @Override
    public void read(@NotNull BedrockResolvers resolvers, @NotNull CompoundTag input, @NotNull BedrockSkullBlockEntity value) {
        value.setSkullType(input.getByte("SkullType", (byte)0));
        if (input.contains("Rotation")) {
            value.setRotation((byte)Math.round((input.getFloat("Rotation", 0.0f) + 360.0f) % 360.0f / 22.5f));
        } else {
            value.setRotation(input.getByte("Rot", (byte)0));
        }
        value.setMovingMouth(input.getByte("DoingAnimation", (byte)0) == 1);
    }

    @Override
    public void write(@NotNull BedrockResolvers resolvers, @NotNull CompoundTag output, @NotNull BedrockSkullBlockEntity value) {
        output.put("SkullType", value.getSkullType());
        output.put("Rotation", (float)value.getRotation() * 22.5f);
        output.put("DoingAnimation", value.isMovingMouth() ? (byte)1 : 0);
    }

    @Override
    public SkullBlockEntity updateBeforeWrite(@NotNull BedrockResolvers resolvers, ChunkerColumn column, int x, int y, int z, SkullBlockEntity blockEntity) {
        Bool powered;
        BedrockSkullBlockEntity bedrockSkullBlockEntity = new BedrockSkullBlockEntity(blockEntity);
        ChunkerBlockIdentifier blockIdentifier = column.getBlock(x, y, z);
        Pair result = (Pair)SKULL_TO_ID.get(blockIdentifier.getType());
        bedrockSkullBlockEntity.setSkullType(result != null ? (Byte)result.key() : (byte)0);
        Rotation rotation = blockIdentifier.getState(VanillaBlockStates.ROTATION);
        if (rotation != null) {
            bedrockSkullBlockEntity.setRotation((byte)rotation.ordinal());
        }
        if ((powered = blockIdentifier.getState(VanillaBlockStates.POWERED)) != null) {
            bedrockSkullBlockEntity.setMovingMouth(powered == Bool.TRUE);
        }
        return bedrockSkullBlockEntity;
    }

    @Override
    public SkullBlockEntity updateBeforeWrite(@NotNull BedrockResolvers resolvers, CompoundTag itemCompoundTag, ChunkerItemStack chunkerItemStack, SkullBlockEntity blockEntity) {
        return new BedrockSkullBlockEntity(blockEntity);
    }

    @Override
    public Class<SkullBlockEntity> getAdditionalHandledClass() {
        return SkullBlockEntity.class;
    }

    @Override
    public SkullBlockEntity updateBeforeProcess(@NotNull BedrockResolvers resolvers, ChunkerColumn column, int x, int y, int z, SkullBlockEntity blockEntity) {
        if (blockEntity instanceof BedrockSkullBlockEntity) {
            BedrockSkullBlockEntity bedrockSkullBlockEntity = (BedrockSkullBlockEntity)blockEntity;
            ChunkerBlockIdentifier blockIdentifier = column.getBlock(x, y, z);
            if (blockIdentifier.isAir()) {
                return blockEntity;
            }
            boolean wallSkull = blockIdentifier.getType().getStates().contains(VanillaBlockStates.FACING_HORIZONTAL);
            ChunkerBlockType newType = (ChunkerBlockType)SKULL_TO_ID.inverse().get(Pair.of(bedrockSkullBlockEntity.getSkullType(), wallSkull));
            if (newType == null) {
                newType = blockIdentifier.getType();
            }
            Object2ObjectOpenHashMap newBlockStates = new Object2ObjectOpenHashMap(blockIdentifier.getPresentStates());
            if (!wallSkull) {
                Rotation[] constants = (Rotation[])Rotation.class.getEnumConstants();
                int normalizedRotation = (bedrockSkullBlockEntity.getRotation() % constants.length + constants.length) % constants.length;
                newBlockStates.put(VanillaBlockStates.ROTATION, constants[normalizedRotation]);
            }
            newBlockStates.put(VanillaBlockStates.POWERED, bedrockSkullBlockEntity.isMovingMouth() ? Bool.TRUE : Bool.FALSE);
            column.setBlock(x, y, z, new ChunkerBlockIdentifier(newType, newBlockStates, blockIdentifier.getPreservedIdentifier()));
            return bedrockSkullBlockEntity.toChunker();
        }
        return blockEntity;
    }

    @Override
    public SkullBlockEntity updateBeforeProcess(@NotNull BedrockResolvers resolvers, CompoundTag itemCompoundTag, ChunkerItemStack chunkerItemStack, SkullBlockEntity blockEntity) {
        if (blockEntity instanceof BedrockSkullBlockEntity) {
            BedrockSkullBlockEntity bedrockSkullBlockEntity = (BedrockSkullBlockEntity)blockEntity;
            return bedrockSkullBlockEntity.toChunker();
        }
        return blockEntity;
    }
}

