/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.blockentity.handlers;

import com.hivemc.chunker.conversion.encoding.base.resolver.blockentity.BlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.base.resolver.blockentity.DoNotProcessBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.BedrockResolvers;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.blockentity.type.BedrockItemFrameBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.ChunkerColumn;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.ChunkerBlockIdentifier;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.ChunkerVanillaBlockType;
import com.hivemc.chunker.nbt.tags.Tag;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import com.hivemc.chunker.nbt.tags.primitive.ByteTag;
import com.hivemc.chunker.nbt.tags.primitive.FloatTag;
import org.jetbrains.annotations.NotNull;

public class BedrockItemFrameBlockEntityHandler
extends BlockEntityHandler<BedrockResolvers, CompoundTag, BedrockItemFrameBlockEntity>
implements DoNotProcessBlockEntityHandler<BedrockItemFrameBlockEntity> {
    public BedrockItemFrameBlockEntityHandler() {
        super("ItemFrame", BedrockItemFrameBlockEntity.class, BedrockItemFrameBlockEntity::new);
    }

    @Override
    public void read(@NotNull BedrockResolvers resolvers, @NotNull CompoundTag input, @NotNull BedrockItemFrameBlockEntity value) {
        Object rotation;
        CompoundTag item = input.getCompound("Item");
        if (item != null) {
            value.setItem(resolvers.readItem(item));
        }
        if ((rotation = input.get("ItemRotation")) != null) {
            if (rotation instanceof FloatTag) {
                FloatTag floatTag = (FloatTag)rotation;
                value.setItemRotation((byte)Math.round((floatTag.getValue() + 360.0f) % 360.0f / 45.0f));
            } else if (rotation instanceof ByteTag) {
                ByteTag byteTag = (ByteTag)rotation;
                value.setItemRotation(byteTag.getValue());
            }
        }
    }

    @Override
    public void write(@NotNull BedrockResolvers resolvers, @NotNull CompoundTag output, @NotNull BedrockItemFrameBlockEntity value) {
        if (value.getItem() != null && !value.getItem().getIdentifier().isAir()) {
            resolvers.writeItem(value.getItem()).ifPresent(item -> output.put("Item", (Tag<?>)item));
        }
        if (resolvers.dataVersion().getVersion().isGreaterThanOrEqual(1, 13, 0)) {
            output.put("ItemRotation", (float)value.getItemRotation() * 45.0f);
        } else {
            output.put("ItemRotation", value.getItemRotation());
        }
    }

    @Override
    public boolean shouldRemoveBeforeProcess(ChunkerColumn column, int x, int y, int z, BedrockItemFrameBlockEntity blockEntity) {
        ChunkerBlockIdentifier block = column.getBlock(x, y, z);
        if (block.getType() == ChunkerVanillaBlockType.ITEM_FRAME_BEDROCK) {
            column.getEntities().add(blockEntity.toChunker(block));
            column.setBlock(x, y, z, ChunkerBlockIdentifier.AIR);
        }
        return true;
    }
}

