/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.blockentity.handlers;

import com.hivemc.chunker.conversion.encoding.base.resolver.blockentity.BlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.BedrockResolvers;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.DecoratedPotBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.ChunkerItemStackIdentifier;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.ChunkerItemStack;
import com.hivemc.chunker.mapping.identifier.Identifier;
import com.hivemc.chunker.nbt.TagType;
import com.hivemc.chunker.nbt.tags.Tag;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import com.hivemc.chunker.nbt.tags.collection.ListTag;
import com.hivemc.chunker.nbt.tags.primitive.StringTag;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class BedrockDecoratedPotBlockEntityHandler
extends BlockEntityHandler<BedrockResolvers, CompoundTag, DecoratedPotBlockEntity> {
    public BedrockDecoratedPotBlockEntityHandler() {
        super("DecoratedPot", DecoratedPotBlockEntity.class, DecoratedPotBlockEntity::new);
    }

    @Override
    public void read(@NotNull BedrockResolvers resolvers, @NotNull CompoundTag input, @NotNull DecoratedPotBlockEntity value) {
        CompoundTag item;
        String tagName = input.contains("sherds") ? "sherds" : "shards";
        List sherds = input.getListValues(tagName, StringTag.class, null);
        if (sherds != null && !sherds.isEmpty()) {
            ArrayList<ChunkerItemStackIdentifier> items = new ArrayList<ChunkerItemStackIdentifier>(sherds.size());
            for (String sherd : sherds) {
                items.add(resolvers.readItemIdentifier(new Identifier(sherd)).getIdentifier());
            }
            value.setBack((ChunkerItemStackIdentifier)items.get(0));
            if (sherds.size() == 1) {
                return;
            }
            value.setLeft((ChunkerItemStackIdentifier)items.get(1));
            if (sherds.size() == 2) {
                return;
            }
            value.setRight((ChunkerItemStackIdentifier)items.get(2));
            if (sherds.size() == 3) {
                return;
            }
            value.setFront((ChunkerItemStackIdentifier)items.get(3));
        }
        if ((item = input.getCompound("item")) != null) {
            value.setItem(resolvers.readItem(item));
        }
    }

    @Override
    public void write(@NotNull BedrockResolvers resolvers, @NotNull CompoundTag output, @NotNull DecoratedPotBlockEntity value) {
        ListTag<StringTag, String> sherds = new ListTag<StringTag, String>(TagType.STRING, 4);
        sherds.add(new StringTag(resolvers.writeItemIdentifier(new ChunkerItemStack(value.getBack())).getIdentifier()));
        sherds.add(new StringTag(resolvers.writeItemIdentifier(new ChunkerItemStack(value.getLeft())).getIdentifier()));
        sherds.add(new StringTag(resolvers.writeItemIdentifier(new ChunkerItemStack(value.getRight())).getIdentifier()));
        sherds.add(new StringTag(resolvers.writeItemIdentifier(new ChunkerItemStack(value.getFront())).getIdentifier()));
        output.put(resolvers.dataVersion().getVersion().isLessThan(1, 20, 0) ? "shards" : "sherds", sherds);
        if (resolvers.dataVersion().getVersion().isGreaterThanOrEqual(1, 20, 50) && value.getItem() != null && !value.getItem().getIdentifier().isAir()) {
            resolvers.writeItem(value.getItem()).ifPresent(item -> output.put("item", (Tag<?>)item));
        }
    }
}

