/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.blockentity.handlers;

import com.hivemc.chunker.conversion.encoding.base.resolver.blockentity.BlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.BedrockResolvers;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.container.BrewingStandBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.container.ContainerBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.ChunkerItemStack;
import com.hivemc.chunker.nbt.TagType;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import com.hivemc.chunker.nbt.tags.collection.ListTag;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectMap;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class BedrockContainerBlockEntityHandler
extends BlockEntityHandler<BedrockResolvers, CompoundTag, ContainerBlockEntity> {
    public BedrockContainerBlockEntityHandler() {
        super("Container", ContainerBlockEntity.class, () -> {
            throw new IllegalArgumentException("Unable to initialize type of container");
        });
    }

    @Override
    public void read(@NotNull BedrockResolvers resolvers, @NotNull CompoundTag input, @NotNull ContainerBlockEntity value) {
        ListTag items = input.getList("Items", CompoundTag.class, null);
        if (items != null) {
            byte index = 0;
            for (CompoundTag itemTag : items) {
                byte slot = this.remapSlot(value, true, itemTag.getByte("Slot", index));
                ChunkerItemStack item = resolvers.readItem(itemTag);
                value.getItems().put(slot, item);
                index = (byte)(index + 1);
            }
        }
    }

    @Override
    public void write(@NotNull BedrockResolvers resolvers, @NotNull CompoundTag output, @NotNull ContainerBlockEntity value) {
        ListTag items = new ListTag(TagType.COMPOUND, value.getItems().size());
        for (Byte2ObjectMap.Entry tag : value.getItems().byte2ObjectEntrySet()) {
            Optional<CompoundTag> item;
            if (((ChunkerItemStack)tag.getValue()).getIdentifier().isAir() || (item = resolvers.writeItem((ChunkerItemStack)tag.getValue())).isEmpty()) continue;
            item.get().put("Slot", this.remapSlot(value, false, tag.getByteKey()));
            items.add(item.get());
        }
        output.put("Items", items);
    }

    protected byte remapSlot(ContainerBlockEntity blockEntity, boolean reading, byte slot) {
        if (blockEntity instanceof BrewingStandBlockEntity) {
            if (reading) {
                switch (slot) {
                    case 0: {
                        return 3;
                    }
                    case 1: {
                        return 0;
                    }
                    case 2: {
                        return 1;
                    }
                    case 3: {
                        return 2;
                    }
                    case 4: {
                        return 4;
                    }
                }
            } else {
                switch (slot) {
                    case 3: {
                        return 0;
                    }
                    case 0: {
                        return 1;
                    }
                    case 1: {
                        return 2;
                    }
                    case 2: {
                        return 3;
                    }
                    case 4: {
                        return 4;
                    }
                }
            }
        }
        return slot;
    }
}

