/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.blockentity.handlers;

import com.hivemc.chunker.conversion.encoding.base.resolver.blockentity.BlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.BedrockResolvers;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.ChiseledBookshelfBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.ChunkerBlockIdentifier;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.ChunkerItemStack;
import com.hivemc.chunker.nbt.TagType;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import com.hivemc.chunker.nbt.tags.collection.ListTag;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;

public class BedrockChiseledBookshelfBlockEntityHandler
extends BlockEntityHandler<BedrockResolvers, CompoundTag, ChiseledBookshelfBlockEntity> {
    public BedrockChiseledBookshelfBlockEntityHandler() {
        super("ChiseledBookshelf", ChiseledBookshelfBlockEntity.class, ChiseledBookshelfBlockEntity::new);
    }

    @Override
    public void read(@NotNull BedrockResolvers resolvers, @NotNull CompoundTag input, @NotNull ChiseledBookshelfBlockEntity value) {
        ListTag items = input.getList("Items", CompoundTag.class, null);
        if (items != null) {
            int index = 0;
            for (CompoundTag itemTag : items) {
                ChunkerItemStack item;
                value.getBooks()[index] = item = resolvers.readItem(itemTag);
                index = (byte)(index + 1);
            }
        }
    }

    @Override
    public void write(@NotNull BedrockResolvers resolvers, @NotNull CompoundTag output, @NotNull ChiseledBookshelfBlockEntity value) {
        ListTag items = new ListTag(TagType.COMPOUND, value.getBooks().length);
        for (ChunkerItemStack itemStack : value.getBooks()) {
            Optional<CompoundTag> item = resolvers.writeItem(itemStack == null ? new ChunkerItemStack(ChunkerBlockIdentifier.AIR) : itemStack);
            item.ifPresent(items::add);
        }
        output.put("Items", items);
    }
}

