/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.blockentity.handlers;

import com.hivemc.chunker.conversion.encoding.base.resolver.blockentity.BlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.base.resolver.blockentity.UpdateBeforeProcessBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.base.resolver.blockentity.UpdateBeforeWriteBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.BedrockResolvers;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.blockentity.type.BedrockChestBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.ChunkerColumn;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.container.randomizable.ChestBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.container.randomizable.TrappedChestBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.ChunkerBlockIdentifier;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.ChunkerVanillaBlockType;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.states.vanilla.VanillaBlockStates;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.states.vanilla.types.ChestType;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.states.vanilla.types.FacingDirectionHorizontal;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.ChunkerItemStack;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import java.util.Map;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public class BedrockChestBlockEntityHandler
extends BlockEntityHandler<BedrockResolvers, CompoundTag, BedrockChestBlockEntity>
implements UpdateBeforeWriteBlockEntityHandler<BedrockResolvers, ChestBlockEntity>,
UpdateBeforeProcessBlockEntityHandler<BedrockResolvers, ChestBlockEntity> {
    public BedrockChestBlockEntityHandler() {
        super("Chest", BedrockChestBlockEntity.class, BedrockChestBlockEntity::new);
    }

    @Override
    public void read(@NotNull BedrockResolvers resolvers, @NotNull CompoundTag input, @NotNull BedrockChestBlockEntity value) {
        if (input.contains("pairx") || input.contains("pairz")) {
            value.setPairX(input.getInt("pairx", value.getX()));
            value.setPairZ(input.getInt("pairz", value.getZ()));
        }
        if (input.contains("pairlead")) {
            value.setLead(input.getByte("pairlead", (byte)0) == 1);
        }
    }

    @Override
    public void write(@NotNull BedrockResolvers resolvers, @NotNull CompoundTag output, @NotNull BedrockChestBlockEntity value) {
        if (value.getPairX() != null && value.getPairZ() != null) {
            output.put("pairlead", value.isLead() ? (byte)1 : 0);
        }
        if (value.getPairX() != null) {
            output.put("pairx", value.getPairX());
        }
        if (value.getPairZ() != null) {
            output.put("pairz", value.getPairZ());
        }
    }

    @Override
    public ChestBlockEntity updateBeforeProcess(@NotNull BedrockResolvers resolvers, ChunkerColumn column, int x, int y, int z, ChestBlockEntity blockEntity) {
        BedrockChestBlockEntity bedrockChestBlockEntity;
        ChunkerBlockIdentifier blockIdentifier = column.getBlock(x, y, z);
        if (blockEntity instanceof BedrockChestBlockEntity) {
            ChestType chestType;
            bedrockChestBlockEntity = (BedrockChestBlockEntity)blockEntity;
            FacingDirectionHorizontal direction = blockIdentifier.getState(VanillaBlockStates.FACING_HORIZONTAL);
            if (bedrockChestBlockEntity.getPairX() != null && bedrockChestBlockEntity.getPairZ() != null && direction != null) {
                int pairX = bedrockChestBlockEntity.getPairX();
                int pairZ = bedrockChestBlockEntity.getPairZ();
                FacingDirectionHorizontal left = direction.rotateClockwise();
                FacingDirectionHorizontal right = direction.rotateAntiClockwise();
                chestType = x + left.getX() == pairX && z + left.getZ() == pairZ ? ChestType.LEFT : (x + right.getX() == pairX && z + right.getZ() == pairZ ? ChestType.RIGHT : ChestType.SINGLE);
            } else {
                chestType = ChestType.SINGLE;
            }
            if (!blockIdentifier.isAir()) {
                column.setBlock(x, y, z, blockIdentifier.copyWith(VanillaBlockStates.CHEST_TYPE, chestType));
            }
        }
        if (blockIdentifier.getType() == ChunkerVanillaBlockType.TRAPPED_CHEST) {
            TrappedChestBlockEntity trappedChestBlockEntity = new TrappedChestBlockEntity();
            trappedChestBlockEntity.setX(blockEntity.getX());
            trappedChestBlockEntity.setY(blockEntity.getY());
            trappedChestBlockEntity.setZ(blockEntity.getZ());
            trappedChestBlockEntity.setMovable(blockEntity.isMovable());
            trappedChestBlockEntity.setLootTable(blockEntity.getLootTable());
            trappedChestBlockEntity.setCustomName(blockEntity.getCustomName());
            trappedChestBlockEntity.getItems().putAll((Map<Byte, ChunkerItemStack>)blockEntity.getItems());
            return trappedChestBlockEntity;
        }
        if (blockEntity instanceof BedrockChestBlockEntity) {
            bedrockChestBlockEntity = (BedrockChestBlockEntity)blockEntity;
            return bedrockChestBlockEntity.toChunker();
        }
        return blockEntity;
    }

    @Override
    public ChestBlockEntity updateBeforeProcess(@NotNull BedrockResolvers resolvers, CompoundTag itemCompoundTag, ChunkerItemStack chunkerItemStack, ChestBlockEntity blockEntity) {
        if (chunkerItemStack.getIdentifier().getItemStackType() == ChunkerVanillaBlockType.TRAPPED_CHEST) {
            TrappedChestBlockEntity trappedChestBlockEntity = new TrappedChestBlockEntity();
            trappedChestBlockEntity.setX(blockEntity.getX());
            trappedChestBlockEntity.setY(blockEntity.getY());
            trappedChestBlockEntity.setZ(blockEntity.getZ());
            trappedChestBlockEntity.setMovable(blockEntity.isMovable());
            trappedChestBlockEntity.setLootTable(blockEntity.getLootTable());
            trappedChestBlockEntity.setCustomName(blockEntity.getCustomName());
            trappedChestBlockEntity.getItems().putAll((Map<Byte, ChunkerItemStack>)blockEntity.getItems());
            return trappedChestBlockEntity;
        }
        if (blockEntity instanceof BedrockChestBlockEntity) {
            BedrockChestBlockEntity bedrockChestBlockEntity = (BedrockChestBlockEntity)blockEntity;
            return bedrockChestBlockEntity.toChunker();
        }
        return blockEntity;
    }

    @Override
    public ChestBlockEntity updateBeforeWrite(@NotNull BedrockResolvers resolvers, ChunkerColumn column, int x, int y, int z, ChestBlockEntity blockEntity) {
        BedrockChestBlockEntity bedrockChestBlockEntity = new BedrockChestBlockEntity(blockEntity);
        ChunkerBlockIdentifier blockIdentifier = column.getBlock(x, y, z);
        ChestType chestType = blockIdentifier.getState(VanillaBlockStates.CHEST_TYPE);
        if (chestType != null && chestType != ChestType.SINGLE) {
            FacingDirectionHorizontal direction = Objects.requireNonNull(blockIdentifier.getState(VanillaBlockStates.FACING_HORIZONTAL));
            FacingDirectionHorizontal targetDirection = chestType == ChestType.LEFT ? direction.rotateClockwise() : direction.rotateAntiClockwise();
            bedrockChestBlockEntity.setPairX(x + targetDirection.getX());
            bedrockChestBlockEntity.setPairZ(z + targetDirection.getZ());
            bedrockChestBlockEntity.setLead(chestType == ChestType.RIGHT);
        }
        return bedrockChestBlockEntity;
    }

    @Override
    public ChestBlockEntity updateBeforeWrite(@NotNull BedrockResolvers resolvers, CompoundTag itemCompoundTag, ChunkerItemStack chunkerItemStack, ChestBlockEntity blockEntity) {
        return new BedrockChestBlockEntity(blockEntity);
    }

    @Override
    public Class<ChestBlockEntity> getAdditionalHandledClass() {
        return ChestBlockEntity.class;
    }
}

