/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.blockentity;

import com.hivemc.chunker.conversion.encoding.base.Version;
import com.hivemc.chunker.conversion.encoding.base.resolver.blockentity.BlockEntityResolver;
import com.hivemc.chunker.conversion.encoding.base.resolver.blockentity.EmptyBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.BedrockResolvers;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.blockentity.handlers.BedrockBannerBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.blockentity.handlers.BedrockBeaconBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.blockentity.handlers.BedrockBedBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.blockentity.handlers.BedrockBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.blockentity.handlers.BedrockBrewingStandBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.blockentity.handlers.BedrockBrushableBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.blockentity.handlers.BedrockCampfireBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.blockentity.handlers.BedrockCauldronBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.blockentity.handlers.BedrockChestBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.blockentity.handlers.BedrockChiseledBookshelfBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.blockentity.handlers.BedrockCommandBlockBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.blockentity.handlers.BedrockComparatorBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.blockentity.handlers.BedrockContainerBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.blockentity.handlers.BedrockCopperGolemStatueBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.blockentity.handlers.BedrockCrafterBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.blockentity.handlers.BedrockDecoratedPotBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.blockentity.handlers.BedrockEndGatewayBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.blockentity.handlers.BedrockFlowerPotBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.blockentity.handlers.BedrockFurnaceBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.blockentity.handlers.BedrockItemFrameBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.blockentity.handlers.BedrockJukeboxBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.blockentity.handlers.BedrockLecternBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.blockentity.handlers.BedrockLodestoneBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.blockentity.handlers.BedrockNoteBlockBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.blockentity.handlers.BedrockPistonArmBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.blockentity.handlers.BedrockRandomizableContainerBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.blockentity.handlers.BedrockSculkSensorBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.blockentity.handlers.BedrockShelfBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.blockentity.handlers.BedrockShulkerBoxBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.blockentity.handlers.BedrockSignBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.blockentity.handlers.BedrockSkullBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.blockentity.handlers.BedrockSpawnerBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.blockentity.handlers.BedrockSporeBlossomBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.blockentity.handlers.BedrockStructureBlockEntityHandler;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.blockentity.type.BedrockGlowItemFrameBlockEntity;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.blockentity.type.BedrockMovingBlockBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.BeehiveBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.BellBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.BlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.ConduitBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.CreakingHeartBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.DaylightDetectorBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.EnchantmentTableBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.JigsawBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.SculkCatalystBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.SculkShriekerBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.TrialSpawnerBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.VaultBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.container.BlastFurnaceBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.container.EnderChestBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.container.HopperBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.container.SmokerBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.container.randomizable.BarrelBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.container.randomizable.ChestBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.container.randomizable.DispenserBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.container.randomizable.DropperBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.container.randomizable.TrappedChestBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.end.EndPortalBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.sculksensor.CalibratedSculkSensorBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.blockentity.sign.HangingSignBlockEntity;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.ChunkerItemStackIdentifierType;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.ChunkerVanillaBlockType;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import java.util.Optional;

public class BedrockBlockEntityResolver
extends BlockEntityResolver<BedrockResolvers, CompoundTag> {
    public BedrockBlockEntityResolver(Version version, BedrockResolvers resolvers) {
        super(version, resolvers, resolvers.converter().shouldAllowNBTCopying());
    }

    @Override
    protected void registerTypeHandlers(Version version) {
        this.register(new BedrockBlockEntityHandler());
        this.register(new BedrockContainerBlockEntityHandler());
        this.register(new BedrockRandomizableContainerBlockEntityHandler(((BedrockResolvers)this.resolvers).converter().shouldProcessLootTables()));
        this.register(new BedrockChestBlockEntityHandler());
        this.register(new EmptyBlockEntityHandler("TrappedChest", TrappedChestBlockEntity.class, () -> {
            throw new IllegalArgumentException("Cannot make TrappedChest");
        }));
        this.register(new BedrockFurnaceBlockEntityHandler());
        this.register(new BedrockSignBlockEntityHandler());
        this.register(new BedrockSpawnerBlockEntityHandler());
        this.register(new EmptyBlockEntityHandler("EnchantTable", EnchantmentTableBlockEntity.class, EnchantmentTableBlockEntity::new));
        this.register(new BedrockSkullBlockEntityHandler());
        this.register(new BedrockFlowerPotBlockEntityHandler());
        this.register(new BedrockBrewingStandBlockEntityHandler());
        this.register(new EmptyBlockEntityHandler("DaylightDetector", DaylightDetectorBlockEntity.class, DaylightDetectorBlockEntity::new));
        this.register(new BedrockNoteBlockBlockEntityHandler());
        this.register(new BedrockJukeboxBlockEntityHandler());
        this.register(new BedrockComparatorBlockEntityHandler());
        this.register(new EmptyBlockEntityHandler("Dispenser", DispenserBlockEntity.class, DispenserBlockEntity::new));
        this.register(new EmptyBlockEntityHandler("Dropper", DropperBlockEntity.class, DropperBlockEntity::new));
        this.register(new EmptyBlockEntityHandler("Hopper", HopperBlockEntity.class, HopperBlockEntity::new));
        this.register(new BedrockCauldronBlockEntityHandler());
        this.register(new BedrockItemFrameBlockEntityHandler());
        this.register(new BedrockPistonArmBlockEntityHandler());
        this.register(new BedrockBeaconBlockEntityHandler());
        this.register(new EmptyBlockEntityHandler("MovingBlock", BedrockMovingBlockBlockEntity.class, BedrockMovingBlockBlockEntity::new));
        this.register(new EmptyBlockEntityHandler("EndPortal", EndPortalBlockEntity.class, EndPortalBlockEntity::new));
        this.register(new EmptyBlockEntityHandler("EnderChest", EnderChestBlockEntity.class, EnderChestBlockEntity::new));
        this.register(new BedrockEndGatewayBlockEntityHandler());
        this.register(new BedrockBannerBlockEntityHandler());
        this.register(new BedrockStructureBlockEntityHandler());
        this.register(new EmptyBlockEntityHandler("JigsawBlock", JigsawBlockEntity.class, JigsawBlockEntity::new));
        this.register(new BedrockShulkerBoxBlockEntityHandler());
        this.register(new BedrockCommandBlockBlockEntityHandler());
        this.register(new BedrockBedBlockEntityHandler());
        this.register(new EmptyBlockEntityHandler("Conduit", ConduitBlockEntity.class, ConduitBlockEntity::new));
        this.register(new BedrockLecternBlockEntityHandler());
        this.register(new EmptyBlockEntityHandler("BlastFurnace", BlastFurnaceBlockEntity.class, BlastFurnaceBlockEntity::new));
        this.register(new EmptyBlockEntityHandler("Bell", BellBlockEntity.class, BellBlockEntity::new));
        this.register(new EmptyBlockEntityHandler("Smoker", SmokerBlockEntity.class, SmokerBlockEntity::new));
        this.register(new BedrockCampfireBlockEntityHandler());
        this.register(new EmptyBlockEntityHandler("Barrel", BarrelBlockEntity.class, BarrelBlockEntity::new));
        if (version.isGreaterThanOrEqual(1, 16, 0)) {
            this.register(new BedrockLodestoneBlockEntityHandler());
            this.register(new EmptyBlockEntityHandler("Beehive", BeehiveBlockEntity.class, BeehiveBlockEntity::new));
        }
        if (version.isGreaterThanOrEqual(1, 17, 0)) {
            this.register(new EmptyBlockEntityHandler("GlowItemFrame", BedrockGlowItemFrameBlockEntity.class, BedrockGlowItemFrameBlockEntity::new));
            this.register(new BedrockSculkSensorBlockEntityHandler());
            this.register(new BedrockSporeBlossomBlockEntityHandler());
        }
        if (version.isGreaterThanOrEqual(1, 17, 30)) {
            this.register(new EmptyBlockEntityHandler("SculkCatalyst", SculkCatalystBlockEntity.class, SculkCatalystBlockEntity::new));
            this.register(new EmptyBlockEntityHandler("SculkShrieker", SculkShriekerBlockEntity.class, SculkShriekerBlockEntity::new));
        }
        if (version.isGreaterThanOrEqual(1, 19, 50)) {
            this.register(new BedrockChiseledBookshelfBlockEntityHandler());
            this.register(new EmptyBlockEntityHandler("HangingSign", HangingSignBlockEntity.class, HangingSignBlockEntity::new));
        }
        if (version.isGreaterThanOrEqual(1, 19, 70)) {
            this.register(new BedrockDecoratedPotBlockEntityHandler());
            this.register(new BedrockBrushableBlockEntityHandler());
        }
        if (version.isGreaterThanOrEqual(1, 19, 80)) {
            this.register(new EmptyBlockEntityHandler("CalibratedSculkSensor", CalibratedSculkSensorBlockEntity.class, CalibratedSculkSensorBlockEntity::new));
        }
        if (version.isGreaterThanOrEqual(1, 20, 50)) {
            this.register(new BedrockCrafterBlockEntityHandler());
        }
        if (version.isGreaterThanOrEqual(1, 20, 60)) {
            this.register(new EmptyBlockEntityHandler("TrialSpawner", TrialSpawnerBlockEntity.class, TrialSpawnerBlockEntity::new));
        }
        if (version.isGreaterThanOrEqual(1, 20, 70)) {
            this.register(new EmptyBlockEntityHandler("Vault", VaultBlockEntity.class, VaultBlockEntity::new));
        }
        if (version.isGreaterThanOrEqual(1, 21, 50)) {
            this.register(new EmptyBlockEntityHandler("CreakingHeart", CreakingHeartBlockEntity.class, CreakingHeartBlockEntity::new));
        }
        if (version.isGreaterThanOrEqual(1, 21, 110)) {
            this.register(new BedrockCopperGolemStatueBlockEntityHandler());
            this.register(new BedrockShelfBlockEntityHandler());
        }
    }

    @Override
    protected CompoundTag constructDataType(String key) {
        CompoundTag compoundTag = new CompoundTag(1);
        compoundTag.put("id", key);
        return compoundTag;
    }

    @Override
    public Optional<String> getKey(CompoundTag input) {
        return input.getOptionalValue("id", String.class);
    }

    @Override
    public Optional<Class<? extends BlockEntity>> getBlockEntityClass(ChunkerItemStackIdentifierType itemStackType) {
        if (itemStackType == ChunkerVanillaBlockType.TRAPPED_CHEST) {
            return Optional.of(ChestBlockEntity.class);
        }
        return super.getBlockEntityClass(itemStackType);
    }
}

