/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.bedrock.base.reader.pretransform.handlers;

import com.hivemc.chunker.conversion.encoding.base.Version;
import com.hivemc.chunker.conversion.handlers.pretransform.Edge;
import com.hivemc.chunker.conversion.handlers.pretransform.manager.handler.block.BlockPreTransformHandler;
import com.hivemc.chunker.conversion.intermediate.column.ChunkerColumn;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.ChunkerBlockIdentifier;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.ChunkerVanillaBlockGroups;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.states.BlockState;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.states.vanilla.VanillaBlockStates;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.states.vanilla.types.Bool;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.states.vanilla.types.WallHeight;
import java.util.Map;
import java.util.Set;

public class BedrockWallPreTransformHandler
implements BlockPreTransformHandler {
    public static final Map<BlockPreTransformHandler.Direction, BlockState<WallHeight>> DIRECTION_TO_STATE = Map.of(BlockPreTransformHandler.Direction.NORTH, VanillaBlockStates.WALL_NORTH, BlockPreTransformHandler.Direction.EAST, VanillaBlockStates.WALL_EAST, BlockPreTransformHandler.Direction.SOUTH, VanillaBlockStates.WALL_SOUTH, BlockPreTransformHandler.Direction.WEST, VanillaBlockStates.WALL_WEST);
    private final boolean needsWallConnections;

    public BedrockWallPreTransformHandler(Version version) {
        this.needsWallConnections = version.isLessThan(1, 16, 0);
    }

    @Override
    public Set<Edge> getRequiredEdges(ChunkerColumn column, int x, int y, int z, ChunkerBlockIdentifier blockIdentifier) {
        return this.needsWallConnections ? this.calculateEdges(x, y, z, BlockPreTransformHandler.Direction.ALL) : this.calculateEdges(x, y, z, BlockPreTransformHandler.Direction.UP);
    }

    @Override
    public ChunkerBlockIdentifier handle(ChunkerColumn column, Map<Edge, ChunkerColumn> neighbours, int x, int y, int z, ChunkerBlockIdentifier blockIdentifier) {
        boolean post;
        ChunkerBlockIdentifier above = this.getRelative(column, neighbours, x, y, z, BlockPreTransformHandler.Direction.UP);
        if (this.needsWallConnections) {
            for (BlockPreTransformHandler.Direction direction : BlockPreTransformHandler.Direction.ALL_HORIZONTAL) {
                ChunkerBlockIdentifier relative = this.getRelative(column, neighbours, x, y, z, direction);
                ChunkerBlockIdentifier relativeAbove = this.getRelative(column, neighbours, x, y + 1, z, direction);
                BlockState<WallHeight> state = DIRECTION_TO_STATE.get((Object)direction);
                WallHeight wallHeight = this.calculateWallHeight(blockIdentifier, above, direction, relative, relativeAbove);
                blockIdentifier = blockIdentifier.copyWith(state, wallHeight);
            }
        }
        blockIdentifier = blockIdentifier.copyWith(VanillaBlockStates.UP, (post = this.canConnectPost(blockIdentifier, BlockPreTransformHandler.Direction.UP, above)) ? Bool.TRUE : Bool.FALSE);
        return blockIdentifier;
    }

    public WallHeight calculateWallHeight(ChunkerBlockIdentifier source, ChunkerBlockIdentifier above, BlockPreTransformHandler.Direction direction, ChunkerBlockIdentifier relative, ChunkerBlockIdentifier relativeAbove) {
        if (ChunkerVanillaBlockGroups.WALLS.contains(relative.getType())) {
            return ChunkerVanillaBlockGroups.WALLS.contains(relativeAbove.getType()) && ChunkerVanillaBlockGroups.WALLS.contains(above.getType()) ? WallHeight.TALL : WallHeight.LOW;
        }
        if (relative.getType().isAllFacesSolid()) {
            return WallHeight.LOW;
        }
        if (ChunkerVanillaBlockGroups.BARS_AND_GLASS_PANES.contains(relative.getType())) {
            return WallHeight.LOW;
        }
        if (ChunkerVanillaBlockGroups.FENCE_GATES.contains(relative.getType())) {
            return WallHeight.LOW;
        }
        return WallHeight.NONE;
    }

    public boolean canConnectPost(ChunkerBlockIdentifier source, BlockPreTransformHandler.Direction direction, ChunkerBlockIdentifier relative) {
        int west;
        int north = source.getState(VanillaBlockStates.WALL_NORTH) == WallHeight.NONE ? 0 : 1;
        int east = source.getState(VanillaBlockStates.WALL_EAST) == WallHeight.NONE ? 0 : 1;
        int south = source.getState(VanillaBlockStates.WALL_SOUTH) == WallHeight.NONE ? 0 : 1;
        int n = west = source.getState(VanillaBlockStates.WALL_WEST) == WallHeight.NONE ? 0 : 1;
        if (north + east + south + west != 2) {
            return true;
        }
        if (!(north == 1 && south == 1 || east == 1 && west == 1)) {
            return true;
        }
        return ChunkerVanillaBlockGroups.WALLS.contains(relative.getType()) || ChunkerVanillaBlockGroups.WOODEN_FENCES.contains(relative.getType()) || relative.getType().isAllFacesSolid();
    }
}

