/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.bedrock.base.reader.pretransform.handlers;

import com.hivemc.chunker.conversion.handlers.pretransform.Edge;
import com.hivemc.chunker.conversion.handlers.pretransform.manager.handler.block.BlockPreTransformHandler;
import com.hivemc.chunker.conversion.intermediate.column.ChunkerColumn;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.ChunkerBlockIdentifier;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.ChunkerVanillaBlockGroups;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.states.vanilla.VanillaBlockStates;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.states.vanilla.types.FacingDirectionHorizontal;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.states.vanilla.types.Half;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.states.vanilla.types.StairShape;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class BedrockStairShapePreTransformHandler
implements BlockPreTransformHandler {
    @Override
    public Set<Edge> getRequiredEdges(ChunkerColumn column, int x, int y, int z, ChunkerBlockIdentifier blockIdentifier) {
        return Set.of(Edge.ALL_EDGES);
    }

    @Override
    public ChunkerBlockIdentifier handle(ChunkerColumn column, Map<Edge, ChunkerColumn> neighbours, int x, int y, int z, ChunkerBlockIdentifier blockIdentifier) {
        ChunkerBlockIdentifier oppositeRelative;
        FacingDirectionHorizontal facingDirection = blockIdentifier.getState(VanillaBlockStates.FACING_HORIZONTAL);
        ChunkerBlockIdentifier relative = this.getRelative(column, neighbours, x, y, z, Objects.requireNonNull(facingDirection).asDirection());
        if (this.canConnect(blockIdentifier, relative)) {
            FacingDirectionHorizontal relativeFacing = relative.getState(VanillaBlockStates.FACING_HORIZONTAL);
            BlockPreTransformHandler.Direction relativeDirection = Objects.requireNonNull(relativeFacing).asDirection();
            ChunkerBlockIdentifier relativeOpposite = this.getRelative(column, neighbours, x, y, z, relativeDirection);
            if (facingDirection.isAdjacent(relativeFacing) && this.canTakeShape(relative, relativeOpposite)) {
                StairShape stairShape = relativeFacing.equals(facingDirection.rotateAntiClockwise()) ? StairShape.OUTER_LEFT : StairShape.OUTER_RIGHT;
                return blockIdentifier.copyWith(VanillaBlockStates.STAIR_SHAPE, stairShape);
            }
        }
        if (this.canConnect(blockIdentifier, oppositeRelative = this.getRelative(column, neighbours, x, y, z, facingDirection.asDirection().getOpposite()))) {
            FacingDirectionHorizontal relativeFacing = oppositeRelative.getState(VanillaBlockStates.FACING_HORIZONTAL);
            BlockPreTransformHandler.Direction relativeDirectionOpposite = Objects.requireNonNull(relativeFacing).asDirection().getOpposite();
            ChunkerBlockIdentifier relativeOpposite = this.getRelative(column, neighbours, x, y, z, relativeDirectionOpposite);
            if (facingDirection.isAdjacent(relativeFacing) && this.canTakeShape(oppositeRelative, relativeOpposite)) {
                StairShape stairShape = relativeFacing.equals(facingDirection.rotateAntiClockwise()) ? StairShape.INNER_LEFT : StairShape.INNER_RIGHT;
                return blockIdentifier.copyWith(VanillaBlockStates.STAIR_SHAPE, stairShape);
            }
        }
        return blockIdentifier.copyWith(VanillaBlockStates.STAIR_SHAPE, StairShape.STRAIGHT);
    }

    public boolean canConnect(ChunkerBlockIdentifier source, ChunkerBlockIdentifier relative) {
        if (!ChunkerVanillaBlockGroups.STAIRS.contains(relative.getType())) {
            return false;
        }
        Half sourceHalf = source.getState(VanillaBlockStates.HALF);
        return sourceHalf == relative.getState(VanillaBlockStates.HALF);
    }

    public boolean canTakeShape(ChunkerBlockIdentifier source, ChunkerBlockIdentifier relative) {
        if (!ChunkerVanillaBlockGroups.STAIRS.contains(relative.getType())) {
            return true;
        }
        FacingDirectionHorizontal sourceDirection = source.getState(VanillaBlockStates.FACING_HORIZONTAL);
        if (sourceDirection != relative.getState(VanillaBlockStates.FACING_HORIZONTAL)) {
            return true;
        }
        Half sourceHalf = source.getState(VanillaBlockStates.HALF);
        return sourceHalf != relative.getState(VanillaBlockStates.HALF);
    }
}

