/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.bedrock.base.reader.pretransform.handlers;

import com.hivemc.chunker.conversion.handlers.pretransform.Edge;
import com.hivemc.chunker.conversion.handlers.pretransform.manager.handler.block.BlockPreTransformHandler;
import com.hivemc.chunker.conversion.handlers.pretransform.manager.handler.block.ConnectableBlockPreTransformHandler;
import com.hivemc.chunker.conversion.intermediate.column.ChunkerColumn;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.ChunkerBlockIdentifier;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.states.BlockState;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.states.vanilla.VanillaBlockStates;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.states.vanilla.types.Bool;
import java.util.Map;

public class BedrockFirePreTransformHandler
implements ConnectableBlockPreTransformHandler {
    final Map<BlockPreTransformHandler.Direction, BlockState<Bool>> DIRECTION_TO_STATE = Map.of(BlockPreTransformHandler.Direction.NORTH, VanillaBlockStates.NORTH, BlockPreTransformHandler.Direction.EAST, VanillaBlockStates.EAST, BlockPreTransformHandler.Direction.SOUTH, VanillaBlockStates.SOUTH, BlockPreTransformHandler.Direction.WEST, VanillaBlockStates.WEST, BlockPreTransformHandler.Direction.UP, VanillaBlockStates.UP);

    @Override
    public ChunkerBlockIdentifier handle(ChunkerColumn column, Map<Edge, ChunkerColumn> neighbours, int x, int y, int z, ChunkerBlockIdentifier blockIdentifier) {
        for (BlockPreTransformHandler.Direction direction : BlockPreTransformHandler.Direction.ALL) {
            ChunkerBlockIdentifier relative = this.getRelative(column, neighbours, x, y, z, direction);
            boolean connection = this.canConnect(blockIdentifier, direction, relative);
            if (direction == BlockPreTransformHandler.Direction.DOWN) {
                if (!connection) continue;
                return blockIdentifier.copyWith(VanillaBlockStates.NORTH, Bool.FALSE).copyWith(VanillaBlockStates.EAST, Bool.FALSE).copyWith(VanillaBlockStates.SOUTH, Bool.FALSE).copyWith(VanillaBlockStates.WEST, Bool.FALSE).copyWith(VanillaBlockStates.UP, Bool.FALSE);
            }
            BlockState<Bool> state = this.DIRECTION_TO_STATE.get((Object)direction);
            blockIdentifier = blockIdentifier.copyWith(state, connection ? Bool.TRUE : Bool.FALSE);
        }
        return blockIdentifier;
    }

    @Override
    public boolean canConnect(ChunkerBlockIdentifier source, BlockPreTransformHandler.Direction direction, ChunkerBlockIdentifier relative) {
        return relative.getType().isAllFacesSolid();
    }
}

