/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.bedrock.base.reader;

import com.hivemc.chunker.conversion.encoding.base.Converter;
import com.hivemc.chunker.conversion.encoding.base.reader.WorldReader;
import com.hivemc.chunker.conversion.encoding.bedrock.base.reader.BedrockColumnReader;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.BedrockResolvers;
import com.hivemc.chunker.conversion.handlers.ColumnConversionHandler;
import com.hivemc.chunker.conversion.handlers.WorldConversionHandler;
import com.hivemc.chunker.conversion.intermediate.column.chunk.ChunkCoordPair;
import com.hivemc.chunker.conversion.intermediate.column.chunk.RegionCoordPair;
import com.hivemc.chunker.conversion.intermediate.world.ChunkerWorld;
import com.hivemc.chunker.conversion.intermediate.world.Dimension;
import com.hivemc.chunker.scheduling.task.ProgressiveTask;
import com.hivemc.chunker.scheduling.task.Task;
import com.hivemc.chunker.scheduling.task.TaskWeight;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Map;
import java.util.Set;
import org.iq80.leveldb.DB;

public class BedrockWorldReader
implements WorldReader {
    protected final BedrockResolvers resolvers;
    protected final Converter converter;
    protected final Map<RegionCoordPair, Set<ChunkCoordPair>> presentRegions;
    protected final Dimension dimension;
    protected final DB database;

    public BedrockWorldReader(BedrockResolvers resolvers, Converter converter, DB database, Map<RegionCoordPair, Set<ChunkCoordPair>> presentRegions, Dimension dimension) {
        this.database = database;
        this.resolvers = resolvers;
        this.converter = converter;
        this.presentRegions = presentRegions;
        this.dimension = dimension;
    }

    @Override
    public void readWorld(WorldConversionHandler worldConversionHandler) {
        ChunkerWorld chunkerWorld = new ChunkerWorld(this.dimension, new ObjectOpenHashSet<RegionCoordPair>(this.presentRegions.keySet()));
        Task<ColumnConversionHandler> convertWorld = worldConversionHandler.convertWorld(chunkerWorld);
        ProgressiveTask<Void> regionProcessing = convertWorld.thenConsume("Reading regions", TaskWeight.HIGHER, columnConversionHandler -> {
            if (columnConversionHandler == null) {
                return;
            }
            ProgressiveTask<Void> readingRegionFiles = Task.async("Reading regions", TaskWeight.HIGHER, () -> this.readRegions(this.presentRegions, (ColumnConversionHandler)columnConversionHandler));
            readingRegionFiles.then("Flushing columns", TaskWeight.MEDIUM, columnConversionHandler::flushColumns);
        });
        regionProcessing.then("Flushing world", TaskWeight.MEDIUM, () -> worldConversionHandler.flushWorld(chunkerWorld));
    }

    public void readRegions(Map<RegionCoordPair, Set<ChunkCoordPair>> regions, ColumnConversionHandler columnConversionHandler) {
        for (Map.Entry<RegionCoordPair, Set<ChunkCoordPair>> region : regions.entrySet()) {
            if (!this.converter.shouldProcessRegion(this.dimension, region.getKey())) continue;
            Task.async("Reading region", TaskWeight.NORMAL, () -> this.readRegion(region, columnConversionHandler)).then("Region - Flushing", TaskWeight.MEDIUM, () -> columnConversionHandler.flushRegion((RegionCoordPair)region.getKey())).then("Region - System::GC", TaskWeight.NONE, System::gc);
        }
    }

    public void readRegion(Map.Entry<RegionCoordPair, Set<ChunkCoordPair>> region, ColumnConversionHandler columnConversionHandler) {
        for (ChunkCoordPair chunkCoordPair : region.getValue()) {
            if (!this.converter.shouldProcessColumn(this.dimension, chunkCoordPair)) continue;
            Task.async("Creating Column Reader", TaskWeight.LOW, () -> this.createColumnReader(chunkCoordPair)).thenConsume("Reading Column", TaskWeight.HIGHER, columnReader -> columnReader.readColumn(columnConversionHandler));
        }
    }

    public BedrockColumnReader createColumnReader(ChunkCoordPair worldChunkCoords) {
        return new BedrockColumnReader(this.resolvers, this.converter, this.database, this.dimension, worldChunkCoords);
    }
}

