/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.bedrock.base.reader;

import com.hivemc.chunker.conversion.encoding.base.Converter;
import com.hivemc.chunker.conversion.encoding.base.Version;
import com.hivemc.chunker.conversion.encoding.base.reader.LevelReader;
import com.hivemc.chunker.conversion.encoding.bedrock.base.BedrockReaderWriter;
import com.hivemc.chunker.conversion.encoding.bedrock.base.reader.BedrockWorldReader;
import com.hivemc.chunker.conversion.encoding.bedrock.base.resolver.BedrockResolvers;
import com.hivemc.chunker.conversion.encoding.bedrock.util.LevelDBChunkType;
import com.hivemc.chunker.conversion.encoding.bedrock.util.LevelDBKey;
import com.hivemc.chunker.conversion.handlers.LevelConversionHandler;
import com.hivemc.chunker.conversion.handlers.WorldConversionHandler;
import com.hivemc.chunker.conversion.intermediate.column.chunk.ChunkCoordPair;
import com.hivemc.chunker.conversion.intermediate.column.chunk.RegionCoordPair;
import com.hivemc.chunker.conversion.intermediate.column.chunk.itemstack.ChunkerItemStack;
import com.hivemc.chunker.conversion.intermediate.level.ChunkerGeneratorType;
import com.hivemc.chunker.conversion.intermediate.level.ChunkerLevel;
import com.hivemc.chunker.conversion.intermediate.level.ChunkerLevelPlayer;
import com.hivemc.chunker.conversion.intermediate.level.ChunkerLevelSettings;
import com.hivemc.chunker.conversion.intermediate.level.ChunkerPortal;
import com.hivemc.chunker.conversion.intermediate.level.map.ChunkerMap;
import com.hivemc.chunker.conversion.intermediate.world.Dimension;
import com.hivemc.chunker.nbt.tags.Tag;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import com.hivemc.chunker.nbt.tags.collection.ListTag;
import com.hivemc.chunker.nbt.tags.primitive.FloatTag;
import com.hivemc.chunker.scheduling.task.FutureTask;
import com.hivemc.chunker.scheduling.task.ProgressiveTask;
import com.hivemc.chunker.scheduling.task.Task;
import com.hivemc.chunker.scheduling.task.TaskWeight;
import it.unimi.dsi.fastutil.bytes.Byte2ObjectAVLTreeMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.iq80.leveldb.CompressionType;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.DBIterator;
import org.iq80.leveldb.Options;
import org.iq80.leveldb.impl.Iq80DBFactory;
import org.iq80.leveldb.table.BloomFilterPolicy;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BedrockLevelReader
implements LevelReader,
BedrockReaderWriter {
    public static final float PLAYER_HEIGHT = 1.62001f;
    public static final String VOID_WORD_STRING = "{ \"biome_id\" : 1, \"block_layers\" : [{\"block_data\" : 0, \"block_name\" : \"minecraft:air\", \"count\" : 1 }], \"encoding_version\" : 4,  \"structure_options\" : null}";
    protected final File inputDirectory;
    protected final Version inputVersion;
    protected final Converter converter;
    protected final BedrockResolvers resolvers;
    protected DB database;

    public BedrockLevelReader(File inputDirectory, Version inputVersion, Converter converter) {
        this.inputDirectory = inputDirectory;
        this.inputVersion = inputVersion;
        this.converter = converter;
        this.resolvers = this.buildResolvers(converter).build();
    }

    protected void openDatabase() throws IOException {
        File databaseDirectory = new File(this.inputDirectory, "db");
        new File(databaseDirectory, "LOCK").delete();
        Options options = new Options();
        options.compressionType(CompressionType.ZLIB_RAW);
        options.blockSize(163840);
        options.filterPolicy(new BloomFilterPolicy(10));
        options.createIfMissing(true);
        Iq80DBFactory factory = new Iq80DBFactory();
        this.database = factory.open(databaseDirectory, options);
    }

    @Override
    public void free() throws Exception {
        if (this.database != null) {
            try {
                this.database.close();
            }
            finally {
                this.database = null;
            }
        }
    }

    @Override
    public void readLevel(LevelConversionHandler levelConversionHandler) throws IOException {
        this.openDatabase();
        FutureTask levelDataCollection = Task.asyncUnwrap("Collecting Level Data", TaskWeight.MEDIUM, this::collectLevelData, levelConversionHandler);
        ProgressiveTask<EnumMap> usedRegions = Task.async("Collecting Used Regions", TaskWeight.MEDIUM, () -> {
            EnumMap<Dimension, Map> dimensionLookup = new EnumMap<Dimension, Map>(Dimension.class);
            try (DBIterator iterator = this.database.iterator();){
                while (iterator.hasNext()) {
                    byte type;
                    int dimensionID;
                    boolean containsDimension;
                    Map.Entry entry = (Map.Entry)iterator.next();
                    byte[] key = (byte[])entry.getKey();
                    int keyLength = key.length;
                    boolean containsSubChunk = keyLength == 14 || keyLength == 10;
                    boolean bl = containsDimension = keyLength == 14 || keyLength == 13;
                    if (keyLength != 9 && !containsSubChunk && !containsDimension || Arrays.equals(key, LevelDBKey.LOCAL_PLAYER)) continue;
                    ByteBuffer buffer = ByteBuffer.wrap(key).order(ByteOrder.LITTLE_ENDIAN);
                    int x = buffer.getInt();
                    int z = buffer.getInt();
                    Dimension dimension = Dimension.OVERWORLD;
                    if (containsDimension && (dimension = Dimension.fromBedrock((byte)(dimensionID = buffer.getInt()), null)) == null) {
                        this.converter.logNonFatalException(new Exception("Unknown dimension key " + dimensionID));
                        continue;
                    }
                    if (containsSubChunk) {
                        buffer.get();
                    }
                    if ((type = buffer.get()) != LevelDBChunkType.DATA_2D.getId() && type != LevelDBChunkType.DATA_3D.getId() && type != LevelDBChunkType.SUB_CHUNK_PREFIX.getId() && type != LevelDBChunkType.ENTITY.getId() && type != LevelDBChunkType.BLOCK_ENTITY.getId()) continue;
                    ChunkCoordPair chunkCoordPair = new ChunkCoordPair(x, z);
                    RegionCoordPair regionCoordPair = chunkCoordPair.getRegion();
                    Map regionLookup = dimensionLookup.computeIfAbsent(dimension, ignored -> new Object2ObjectOpenHashMap());
                    Set columns = regionLookup.computeIfAbsent(regionCoordPair, ignored -> new ObjectOpenHashSet());
                    columns.add(chunkCoordPair);
                }
            }
            return dimensionLookup;
        });
        ProgressiveTask<Void> worldReading = levelDataCollection.thenConsume("Reading Worlds", TaskWeight.HIGHEST, worldConversionHandler -> {
            if (worldConversionHandler == null) {
                return;
            }
            usedRegions.thenConsume("Reading Worlds", TaskWeight.HIGHEST, dimensionLookup -> {
                ArrayList<ProgressiveTask<Void>> worlds = new ArrayList<ProgressiveTask<Void>>(dimensionLookup.size());
                for (Map.Entry entry : dimensionLookup.entrySet()) {
                    if (!this.converter.shouldProcessDimension((Dimension)((Object)((Object)((Object)entry.getKey()))))) continue;
                    BedrockWorldReader reader = this.createWorldReader((Map)entry.getValue(), (Dimension)((Object)((Object)((Object)entry.getKey()))));
                    worlds.add(Task.asyncConsume("Reading World", TaskWeight.HIGHER, reader::readWorld, worldConversionHandler));
                }
                Task.join(worlds).then("Flushing Worlds", TaskWeight.MEDIUM, worldConversionHandler::flushWorlds);
            });
        });
        worldReading.then("Flushing Level", TaskWeight.MEDIUM, levelConversionHandler::flushLevel);
    }

    protected Task<WorldConversionHandler> collectLevelData(LevelConversionHandler levelConversionHandler) {
        ChunkerLevel output = new ChunkerLevel();
        ProgressiveTask<Void> parseLevelSettings = Task.asyncConsume("Parsing Level Settings", TaskWeight.NORMAL, this::parseLevelSettings, output);
        ProgressiveTask<Void> parseLocalPlayer = Task.asyncConsume("Parsing Local Player", TaskWeight.NORMAL, this::parseLocalPlayer, output);
        ProgressiveTask<Void> parseMaps = Task.asyncConsume("Parsing Saved Maps", TaskWeight.NORMAL, this::parseMaps, output);
        ProgressiveTask<Void> parsePortals = Task.asyncConsume("Parsing Portals", TaskWeight.NORMAL, this::parsePortals, output);
        return Task.join(parseLevelSettings, parseLocalPlayer, parseMaps, parsePortals).thenUnwrap("Converting Level", TaskWeight.LOW, levelConversionHandler::convertLevel, (List<ChunkerLevel>)((Object)output));
    }

    protected void parseLevelSettings(ChunkerLevel output) throws Exception {
        CompoundTag level = Tag.readBedrockNBT(new File(this.inputDirectory, "level.dat"));
        output.setSettings(ChunkerLevelSettings.fromNBT(Objects.requireNonNull(level), this, this.converter));
        output.setOriginalLevelData(level);
    }

    @Override
    @Nullable
    public Object readCustomLevelSetting(@NotNull CompoundTag root, @NotNull String targetName, @NotNull Class<?> type) {
        if (targetName.equals("AutumnDrop2025")) {
            return false;
        }
        if (targetName.equals("SummerDrop2025")) {
            return false;
        }
        if (targetName.equals("WinterDrop2024")) {
            return false;
        }
        if (targetName.equals("R21Support")) {
            return false;
        }
        if (targetName.equals("R20Support")) {
            return false;
        }
        if (targetName.equals("CavesAndCliffs")) {
            return false;
        }
        if (targetName.equals("FlatWorldVersion")) {
            return root.getInt("WorldVersion", 0);
        }
        if (targetName.equals("RandomSeed")) {
            if (root.getInt("StorageVersion", 0) > 8) {
                return root.contains(targetName) ? String.valueOf(root.getLong(targetName)) : null;
            }
            return root.contains(targetName) ? String.valueOf((int)root.getLong(targetName)) : null;
        }
        if (type == ChunkerGeneratorType.class) {
            int generator = root.getInt("Generator", 1);
            return switch (generator) {
                case 0 -> ChunkerGeneratorType.CUSTOM;
                case 1 -> ChunkerGeneratorType.NORMAL;
                case 2 -> {
                    String generatorOptions = root.getString("generatorOptions", null);
                    if (generatorOptions != null && !generatorOptions.isEmpty()) {
                        if (VOID_WORD_STRING.equals(root.getString("FlatWorldLayers", null))) {
                            yield ChunkerGeneratorType.VOID;
                        }
                        yield ChunkerGeneratorType.CUSTOM;
                    }
                    yield ChunkerGeneratorType.FLAT;
                }
                default -> ChunkerGeneratorType.CUSTOM;
            };
        }
        throw new IllegalArgumentException("Type " + targetName + " isn't implemented for setting parsing");
    }

    protected void parseLocalPlayer(ChunkerLevel output) {
        byte[] bytes = this.database.get(LevelDBKey.LOCAL_PLAYER);
        if (bytes == null) {
            return;
        }
        try {
            ListTag offhand;
            ListTag armor;
            CompoundTag player = Objects.requireNonNull(Tag.readBedrockNBT(bytes));
            List<Float> positions = player.getListValues("Pos", FloatTag.class, List.of(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)));
            List<Float> motion = player.getListValues("Motion", FloatTag.class, List.of(Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)));
            List<Float> rotation = player.getListValues("Rotation", FloatTag.class, List.of(Float.valueOf(0.0f), Float.valueOf(0.0f)));
            Byte2ObjectAVLTreeMap<ChunkerItemStack> inventory = new Byte2ObjectAVLTreeMap<ChunkerItemStack>();
            ListTag items = player.getList("Inventory", CompoundTag.class, null);
            if (items != null) {
                byte index = 0;
                for (Object itemTag : items) {
                    byte slot = ((CompoundTag)itemTag).getByte("Slot", index);
                    ChunkerItemStack item = this.resolvers.readItem((CompoundTag)itemTag);
                    inventory.put(slot, item);
                    index = (byte)(index + 1);
                }
            }
            if ((armor = player.getList("Armor", CompoundTag.class, null)) != null) {
                byte index = 0;
                for (CompoundTag itemTag : armor) {
                    byte slot = (byte)(100 + (3 - itemTag.getByte("Slot", index)));
                    ChunkerItemStack item = this.resolvers.readItem(itemTag);
                    inventory.put(slot, item);
                    index = (byte)(index + 1);
                }
            }
            if ((offhand = player.getList("Offhand", CompoundTag.class, null)) != null) {
                byte index = 0;
                for (CompoundTag itemTag : offhand) {
                    byte slot = (byte)(150 + itemTag.getByte("Slot", index));
                    ChunkerItemStack item = this.resolvers.readItem(itemTag);
                    inventory.put(slot, item);
                    index = (byte)(index + 1);
                }
            }
            output.setPlayer(new ChunkerLevelPlayer(Dimension.fromBedrockNBT(player.get("DimensionId"), Dimension.OVERWORLD), positions.get(0).floatValue(), positions.get(1).floatValue() - 1.62001f, positions.get(2).floatValue(), motion.get(0).floatValue(), motion.get(1).floatValue(), motion.get(2).floatValue(), rotation.get(0).floatValue(), rotation.get(1).floatValue(), inventory, player.getInt("PlayerGameMode", 0)));
        }
        catch (Exception e) {
            this.converter.logNonFatalException(e);
        }
    }

    @Override
    public Version getVersion() {
        return this.inputVersion;
    }

    protected void parseMaps(ChunkerLevel output) {
        ArrayList<ChunkerMap> maps = new ArrayList<ChunkerMap>();
        if (this.converter.shouldProcessMaps()) {
            ArrayList<ProgressiveTask<ChunkerMap>> tasks = new ArrayList<ProgressiveTask<ChunkerMap>>();
            try (DBIterator iterator = this.database.iterator();){
                iterator.seek(LevelDBKey.MAP_PREFIX);
                while (iterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    if (!LevelDBKey.startsWith((byte[])entry.getKey(), LevelDBKey.MAP_PREFIX)) continue;
                    try {
                        String suffix = LevelDBKey.extractSuffix((byte[])entry.getKey(), LevelDBKey.MAP_PREFIX);
                        long mapID = Long.parseLong(suffix);
                        tasks.add(Task.async("Parsing map", TaskWeight.NORMAL, () -> this.parseMap(mapID, (byte[])entry.getValue())));
                    }
                    catch (Exception e) {
                        this.converter.logNonFatalException(e);
                    }
                }
            }
            if (!tasks.isEmpty()) {
                Task.join(tasks).thenConsume("Parsing map sync", TaskWeight.LOW, mapArray -> {
                    for (ChunkerMap map : mapArray) {
                        if (map == null) continue;
                        maps.add(map);
                    }
                    maps.sort(ChunkerMap.BY_ID_COMPARATOR);
                });
            }
        }
        output.setMaps(maps);
    }

    @Nullable
    protected ChunkerMap parseMap(long id, byte[] data) {
        try {
            CompoundTag mapCompound = Objects.requireNonNull(Tag.readBedrockNBT(data));
            return new ChunkerMap(id, id, mapCompound.getShort("height", (short)128), mapCompound.getShort("width", (short)128), mapCompound.getByte("scale", (byte)0), Dimension.fromBedrockNBT(mapCompound.get("dimension"), Dimension.OVERWORLD), mapCompound.getInt("xCenter", 0), mapCompound.getInt("zCenter", 0), mapCompound.getByte("unlimitedTracking", (byte)0) != 0, mapCompound.getByte("mapLocked", (byte)0) != 0, mapCompound.getByteArray("colors", null), this.resolvers.converter().shouldAllowNBTCopying() ? mapCompound : null);
        }
        catch (Exception e) {
            this.converter.logNonFatalException(e);
            return null;
        }
    }

    protected void parsePortals(ChunkerLevel output) {
        output.setPortals(new ArrayList<ChunkerPortal>());
        try {
            byte[] value = this.database.get(LevelDBKey.PORTALS);
            if (value == null) {
                return;
            }
            CompoundTag wrappedData = Objects.requireNonNull(Tag.readBedrockNBT(value));
            CompoundTag data = wrappedData.getCompound("data");
            if (data == null) {
                return;
            }
            ListTag portalRecords = data.getList("PortalRecords", CompoundTag.class, null);
            if (portalRecords == null) {
                return;
            }
            for (CompoundTag portalRecord : portalRecords) {
                output.getPortals().add(new ChunkerPortal(Dimension.fromBedrock((byte)portalRecord.getInt("DimId", 0), Dimension.OVERWORLD), portalRecord.getInt("TpX", 0), portalRecord.getInt("TpY", 0), portalRecord.getInt("TpZ", 0), portalRecord.getByte("Span", (byte)0), portalRecord.getByte("Xa", (byte)0), portalRecord.getByte("Za", (byte)0)));
            }
        }
        catch (Exception e) {
            this.converter.logNonFatalException(e);
        }
    }

    public BedrockWorldReader createWorldReader(Map<RegionCoordPair, Set<ChunkCoordPair>> presentRegions, Dimension dimension) {
        return new BedrockWorldReader(this.resolvers, this.converter, this.database, presentRegions, dimension);
    }
}

