/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.bedrock;

import com.hivemc.chunker.conversion.encoding.base.Converter;
import com.hivemc.chunker.conversion.encoding.base.Version;
import com.hivemc.chunker.conversion.encoding.bedrock.BedrockDataVersion;
import com.hivemc.chunker.conversion.encoding.bedrock.BedrockLevelReaderConstructor;
import com.hivemc.chunker.conversion.encoding.bedrock.BedrockLevelWriterConstructor;
import com.hivemc.chunker.conversion.encoding.bedrock.base.reader.BedrockLevelReader;
import com.hivemc.chunker.conversion.encoding.bedrock.base.writer.BedrockLevelWriter;
import com.hivemc.chunker.conversion.encoding.bedrock.v1_16.reader.LevelReader;
import com.hivemc.chunker.conversion.encoding.bedrock.v1_19.writer.LevelWriter;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collectors;

public class BedrockEncoders {
    private static final TreeMap<BedrockDataVersion, BedrockEncoder> ENCODER_LOOKUP = new TreeMap();

    public static void register(BedrockDataVersion dataVersion, BedrockLevelReaderConstructor<?> readerConstructor, BedrockLevelWriterConstructor<?> writerConstructor) {
        ENCODER_LOOKUP.put(dataVersion, new BedrockEncoder(readerConstructor, writerConstructor));
    }

    public static BedrockEncoder oldest() {
        return ENCODER_LOOKUP.firstEntry().getValue();
    }

    public static BedrockEncoder latest() {
        return ENCODER_LOOKUP.lastEntry().getValue();
    }

    public static Collection<Version> getSupportedVersions() {
        return BedrockDataVersion.getVersions().stream().map(BedrockDataVersion::getVersion).collect(Collectors.toList());
    }

    public static BedrockEncoder getNearestEncoder(BedrockDataVersion dataVersion) {
        Map.Entry<BedrockDataVersion, BedrockEncoder> entry = ENCODER_LOOKUP.floorEntry(dataVersion);
        return entry == null ? BedrockEncoders.oldest() : entry.getValue();
    }

    public static Optional<BedrockLevelReader> createReader(File directory, Converter converter) {
        Optional<BedrockDataVersion> bedrockDataVersion = BedrockDataVersion.detect(directory);
        if (bedrockDataVersion.isEmpty()) {
            return Optional.empty();
        }
        BedrockDataVersion dataVersion = bedrockDataVersion.get();
        BedrockEncoder nearest = BedrockEncoders.getNearestEncoder(dataVersion);
        if (nearest == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(nearest.readerConstructor().construct(directory, dataVersion.getVersion(), converter));
    }

    public static Optional<BedrockLevelWriter> createWriter(File directory, Version outputVersion, Converter converter) {
        BedrockDataVersion dataVersion = BedrockDataVersion.getNearestVersion(outputVersion);
        if (dataVersion == null) {
            return Optional.empty();
        }
        BedrockEncoder nearest = BedrockEncoders.getNearestEncoder(dataVersion);
        if (nearest == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(nearest.writerConstructor().construct(directory, dataVersion.getVersion(), converter));
    }

    static {
        BedrockEncoders.register(BedrockDataVersion.V1_12_0, BedrockLevelReader::new, BedrockLevelWriter::new);
        BedrockEncoders.register(BedrockDataVersion.V1_13_0, com.hivemc.chunker.conversion.encoding.bedrock.v1_13.reader.LevelReader::new, com.hivemc.chunker.conversion.encoding.bedrock.v1_13.writer.LevelWriter::new);
        BedrockEncoders.register(BedrockDataVersion.V1_14_0, com.hivemc.chunker.conversion.encoding.bedrock.v1_14.reader.LevelReader::new, com.hivemc.chunker.conversion.encoding.bedrock.v1_14.writer.LevelWriter::new);
        BedrockEncoders.register(BedrockDataVersion.V1_16_0, LevelReader::new, com.hivemc.chunker.conversion.encoding.bedrock.v1_16.writer.LevelWriter::new);
        BedrockEncoders.register(BedrockDataVersion.V1_17_0, com.hivemc.chunker.conversion.encoding.bedrock.v1_17.reader.LevelReader::new, com.hivemc.chunker.conversion.encoding.bedrock.v1_17.writer.LevelWriter::new);
        BedrockEncoders.register(BedrockDataVersion.V1_17_30, com.hivemc.chunker.conversion.encoding.bedrock.v1_17_30.reader.LevelReader::new, com.hivemc.chunker.conversion.encoding.bedrock.v1_17_30.writer.LevelWriter::new);
        BedrockEncoders.register(BedrockDataVersion.V1_18_0, com.hivemc.chunker.conversion.encoding.bedrock.v1_18.reader.LevelReader::new, com.hivemc.chunker.conversion.encoding.bedrock.v1_18.writer.LevelWriter::new);
        BedrockEncoders.register(BedrockDataVersion.V1_18_30, com.hivemc.chunker.conversion.encoding.bedrock.v1_18_30.reader.LevelReader::new, com.hivemc.chunker.conversion.encoding.bedrock.v1_18_30.writer.LevelWriter::new);
        BedrockEncoders.register(BedrockDataVersion.V1_19_0, com.hivemc.chunker.conversion.encoding.bedrock.v1_19.reader.LevelReader::new, LevelWriter::new);
        BedrockEncoders.register(BedrockDataVersion.V1_19_80, com.hivemc.chunker.conversion.encoding.bedrock.v1_19_80.reader.LevelReader::new, com.hivemc.chunker.conversion.encoding.bedrock.v1_19_80.writer.LevelWriter::new);
        BedrockEncoders.register(BedrockDataVersion.V1_20_0, com.hivemc.chunker.conversion.encoding.bedrock.v1_20.reader.LevelReader::new, com.hivemc.chunker.conversion.encoding.bedrock.v1_20.writer.LevelWriter::new);
        BedrockEncoders.register(BedrockDataVersion.V1_20_30, com.hivemc.chunker.conversion.encoding.bedrock.v1_20_30.reader.LevelReader::new, com.hivemc.chunker.conversion.encoding.bedrock.v1_20_30.writer.LevelWriter::new);
        BedrockEncoders.register(BedrockDataVersion.V1_20_50, com.hivemc.chunker.conversion.encoding.bedrock.v1_20_50.reader.LevelReader::new, com.hivemc.chunker.conversion.encoding.bedrock.v1_20_50.writer.LevelWriter::new);
        BedrockEncoders.register(BedrockDataVersion.V1_20_60, com.hivemc.chunker.conversion.encoding.bedrock.v1_20_60.reader.LevelReader::new, com.hivemc.chunker.conversion.encoding.bedrock.v1_20_60.writer.LevelWriter::new);
        BedrockEncoders.register(BedrockDataVersion.V1_21_0, com.hivemc.chunker.conversion.encoding.bedrock.v1_21.reader.LevelReader::new, com.hivemc.chunker.conversion.encoding.bedrock.v1_21.writer.LevelWriter::new);
        BedrockEncoders.register(BedrockDataVersion.V1_21_40, com.hivemc.chunker.conversion.encoding.bedrock.v1_21_40.reader.LevelReader::new, com.hivemc.chunker.conversion.encoding.bedrock.v1_21_40.writer.LevelWriter::new);
        BedrockEncoders.register(BedrockDataVersion.V1_21_50, com.hivemc.chunker.conversion.encoding.bedrock.v1_21_50.reader.LevelReader::new, com.hivemc.chunker.conversion.encoding.bedrock.v1_21_50.writer.LevelWriter::new);
        BedrockEncoders.register(BedrockDataVersion.V1_21_60, com.hivemc.chunker.conversion.encoding.bedrock.v1_21_60.reader.LevelReader::new, com.hivemc.chunker.conversion.encoding.bedrock.v1_21_60.writer.LevelWriter::new);
        BedrockEncoders.register(BedrockDataVersion.V1_21_80, com.hivemc.chunker.conversion.encoding.bedrock.v1_21_80.reader.LevelReader::new, com.hivemc.chunker.conversion.encoding.bedrock.v1_21_80.writer.LevelWriter::new);
        BedrockEncoders.register(BedrockDataVersion.V1_21_90, com.hivemc.chunker.conversion.encoding.bedrock.v1_21_90.reader.LevelReader::new, com.hivemc.chunker.conversion.encoding.bedrock.v1_21_90.writer.LevelWriter::new);
        BedrockEncoders.register(BedrockDataVersion.V1_21_100, com.hivemc.chunker.conversion.encoding.bedrock.v1_21_100.reader.LevelReader::new, com.hivemc.chunker.conversion.encoding.bedrock.v1_21_100.writer.LevelWriter::new);
        BedrockEncoders.register(BedrockDataVersion.V1_21_110, com.hivemc.chunker.conversion.encoding.bedrock.v1_21_110.reader.LevelReader::new, com.hivemc.chunker.conversion.encoding.bedrock.v1_21_110.writer.LevelWriter::new);
    }

    public record BedrockEncoder(BedrockLevelReaderConstructor<?> readerConstructor, BedrockLevelWriterConstructor<?> writerConstructor) {
    }
}

