/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.bedrock;

import com.hivemc.chunker.conversion.encoding.base.Version;
import com.hivemc.chunker.nbt.tags.Tag;
import com.hivemc.chunker.nbt.tags.collection.CompoundTag;
import com.hivemc.chunker.nbt.tags.primitive.IntTag;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;

public class BedrockDataVersion
implements Comparable<BedrockDataVersion> {
    private static final TreeMap<Integer, BedrockDataVersion> PROTOCOL_VERSION_LOOKUP = new TreeMap();
    private static final TreeMap<Version, BedrockDataVersion> VERSION_LOOKUP = new TreeMap();
    public static final BedrockDataVersion V1_12_0 = BedrockDataVersion.register(361, 8, new Version(1, 12, 0));
    public static final BedrockDataVersion V1_13_0 = BedrockDataVersion.register(388, 8, new Version(1, 13, 0));
    public static final BedrockDataVersion V1_14_0 = BedrockDataVersion.register(389, 8, new Version(1, 14, 0));
    public static final BedrockDataVersion V1_14_20 = BedrockDataVersion.register(389, 8, new Version(1, 14, 20));
    public static final BedrockDataVersion V1_14_30 = BedrockDataVersion.register(389, 8, new Version(1, 14, 30));
    public static final BedrockDataVersion V1_14_60 = BedrockDataVersion.register(390, 8, new Version(1, 14, 60));
    public static final BedrockDataVersion V1_16_0 = BedrockDataVersion.register(407, 8, new Version(1, 16, 0));
    public static final BedrockDataVersion V1_16_20 = BedrockDataVersion.register(408, 8, new Version(1, 16, 20));
    public static final BedrockDataVersion V1_16_40 = BedrockDataVersion.register(408, 8, new Version(1, 16, 40));
    public static final BedrockDataVersion V1_16_100 = BedrockDataVersion.register(419, 8, new Version(1, 16, 100));
    public static final BedrockDataVersion V1_16_200 = BedrockDataVersion.register(422, 8, new Version(1, 16, 200));
    public static final BedrockDataVersion V1_16_210 = BedrockDataVersion.register(428, 8, new Version(1, 16, 210));
    public static final BedrockDataVersion V1_16_220 = BedrockDataVersion.register(431, 8, new Version(1, 16, 220));
    public static final BedrockDataVersion V1_17_0 = BedrockDataVersion.register(440, 8, new Version(1, 17, 0));
    public static final BedrockDataVersion V1_17_10 = BedrockDataVersion.register(448, 8, new Version(1, 17, 10));
    public static final BedrockDataVersion V1_17_30 = BedrockDataVersion.register(465, 8, new Version(1, 17, 30));
    public static final BedrockDataVersion V1_17_40 = BedrockDataVersion.register(471, 8, new Version(1, 17, 40));
    public static final BedrockDataVersion V1_18_0 = BedrockDataVersion.register(475, 8, new Version(1, 18, 0));
    public static final BedrockDataVersion V1_18_10 = BedrockDataVersion.register(486, 8, new Version(1, 18, 10));
    public static final BedrockDataVersion V1_18_30 = BedrockDataVersion.register(503, 9, new Version(1, 18, 30));
    public static final BedrockDataVersion V1_19_0 = BedrockDataVersion.register(526, 9, new Version(1, 19, 0));
    public static final BedrockDataVersion V1_19_10 = BedrockDataVersion.register(534, 9, new Version(1, 19, 10));
    public static final BedrockDataVersion V1_19_20 = BedrockDataVersion.register(544, 9, new Version(1, 19, 20));
    public static final BedrockDataVersion V1_19_30 = BedrockDataVersion.register(554, 9, new Version(1, 19, 30));
    public static final BedrockDataVersion V1_19_40 = BedrockDataVersion.register(557, 9, new Version(1, 19, 40));
    public static final BedrockDataVersion V1_19_50 = BedrockDataVersion.register(560, 9, new Version(1, 19, 50));
    public static final BedrockDataVersion V1_19_60 = BedrockDataVersion.register(568, 9, new Version(1, 19, 60));
    public static final BedrockDataVersion V1_19_70 = BedrockDataVersion.register(575, 9, new Version(1, 19, 70));
    public static final BedrockDataVersion V1_19_80 = BedrockDataVersion.register(582, 9, new Version(1, 19, 80));
    public static final BedrockDataVersion V1_20_0 = BedrockDataVersion.register(588, 9, 33, new Version(1, 20, 0));
    public static final BedrockDataVersion V1_20_10 = BedrockDataVersion.register(594, 9, new Version(1, 20, 10));
    public static final BedrockDataVersion V1_20_30 = BedrockDataVersion.register(618, 9, new Version(1, 20, 30));
    public static final BedrockDataVersion V1_20_40 = BedrockDataVersion.register(622, 9, new Version(1, 20, 40));
    public static final BedrockDataVersion V1_20_50 = BedrockDataVersion.register(630, 9, new Version(1, 20, 50));
    public static final BedrockDataVersion V1_20_60 = BedrockDataVersion.register(649, 9, new Version(1, 20, 60));
    public static final BedrockDataVersion V1_20_70 = BedrockDataVersion.register(662, 9, new Version(1, 20, 70));
    public static final BedrockDataVersion V1_20_80 = BedrockDataVersion.register(671, 9, new Version(1, 20, 80));
    public static final BedrockDataVersion V1_21_0 = BedrockDataVersion.register(685, 9, new Version(1, 21, 0));
    public static final BedrockDataVersion V1_21_20 = BedrockDataVersion.register(712, 9, new Version(1, 21, 20));
    public static final BedrockDataVersion V1_21_30 = BedrockDataVersion.register(729, 9, new Version(1, 21, 30));
    public static final BedrockDataVersion V1_21_40 = BedrockDataVersion.register(748, 9, new Version(1, 21, 40));
    public static final BedrockDataVersion V1_21_50 = BedrockDataVersion.register(766, 9, new Version(1, 21, 50));
    public static final BedrockDataVersion V1_21_60 = BedrockDataVersion.register(776, 9, new Version(1, 21, 60));
    public static final BedrockDataVersion V1_21_70 = BedrockDataVersion.register(786, 9, new Version(1, 21, 70));
    public static final BedrockDataVersion V1_21_80 = BedrockDataVersion.register(800, 9, new Version(1, 21, 80));
    public static final BedrockDataVersion V1_21_90 = BedrockDataVersion.register(818, 9, new Version(1, 21, 90));
    public static final BedrockDataVersion V1_21_93 = BedrockDataVersion.register(819, 9, new Version(1, 21, 93));
    public static final BedrockDataVersion V1_21_100 = BedrockDataVersion.register(827, 9, new Version(1, 21, 100));
    public static final BedrockDataVersion V1_21_110 = BedrockDataVersion.register(843, 9, new Version(1, 21, 110));
    private final int protocolVersion;
    private final int storageVersion;
    private final Version version;
    private final int stateVersion;

    public BedrockDataVersion(int protocolVersion, int storageVersion, int statePatchSubVersion, Version version) {
        this.protocolVersion = protocolVersion;
        this.storageVersion = storageVersion;
        this.version = version;
        this.stateVersion = version.getMajor() << 24 | version.getMinor() << 16 | version.getPatch() << 8 | statePatchSubVersion;
    }

    public BedrockDataVersion(int protocolVersion, int storageVersion, Version version) {
        this(protocolVersion, storageVersion, 0, version);
    }

    public static BedrockDataVersion register(int protocolVersion, int storageVersion, int statePatchSubVersion, Version bedrockVersion) {
        BedrockDataVersion bedrockDataVersion = new BedrockDataVersion(protocolVersion, storageVersion, statePatchSubVersion, bedrockVersion);
        PROTOCOL_VERSION_LOOKUP.put(protocolVersion, bedrockDataVersion);
        VERSION_LOOKUP.put(bedrockDataVersion.getVersion(), bedrockDataVersion);
        return bedrockDataVersion;
    }

    public static BedrockDataVersion register(int protocolVersion, int storageVersion, Version bedrockVersion) {
        return BedrockDataVersion.register(protocolVersion, storageVersion, 0, bedrockVersion);
    }

    public static BedrockDataVersion oldest() {
        return VERSION_LOOKUP.firstEntry().getValue();
    }

    public static BedrockDataVersion latest() {
        return VERSION_LOOKUP.lastEntry().getValue();
    }

    public static BedrockDataVersion getNearestProtocol(int protocolVersion) {
        Map.Entry<Integer, BedrockDataVersion> entry = PROTOCOL_VERSION_LOOKUP.floorEntry(protocolVersion);
        return entry == null ? BedrockDataVersion.oldest() : entry.getValue();
    }

    public static BedrockDataVersion getNearestVersion(Version version) {
        Map.Entry<Version, BedrockDataVersion> entry = VERSION_LOOKUP.floorEntry(version);
        return entry == null ? BedrockDataVersion.oldest() : entry.getValue();
    }

    public static Collection<BedrockDataVersion> getVersions() {
        return Collections.unmodifiableCollection(VERSION_LOOKUP.values());
    }

    public static Optional<BedrockDataVersion> detect(File directory) {
        try {
            CompoundTag level = Objects.requireNonNull(Tag.readBedrockNBT(new File(directory, "level.dat")));
            List versionTag = level.getListValues("lastOpenedWithVersion", IntTag.class, null);
            if (versionTag == null) {
                versionTag = level.getListValues("MinimumCompatibleClientVersion", IntTag.class, null);
            }
            if (versionTag == null || versionTag.isEmpty()) {
                return Optional.ofNullable(BedrockDataVersion.oldest());
            }
            Version version = new Version((Integer)versionTag.get(0), (Integer)versionTag.get(1), (Integer)versionTag.get(2));
            return Optional.ofNullable(BedrockDataVersion.getNearestVersion(version));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    public int getProtocolVersion() {
        return this.protocolVersion;
    }

    public Version getVersion() {
        return this.version;
    }

    public int getStorageVersion() {
        return this.storageVersion;
    }

    public int getStateVersion() {
        return this.stateVersion;
    }

    public String toString() {
        return "BedrockDataVersion{protocolVersion=" + this.protocolVersion + ", version=" + String.valueOf(this.version) + "}";
    }

    @Override
    public int compareTo(@NotNull BedrockDataVersion o) {
        return this.version.compareTo(o.getVersion());
    }
}

