/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.base.resolver.identifier.state;

import com.google.common.base.Preconditions;
import com.hivemc.chunker.conversion.encoding.base.Version;
import com.hivemc.chunker.conversion.encoding.base.resolver.identifier.state.StateMappingGroup;
import java.util.Comparator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public interface VersionedStateMappingGroup {
    public StateMappingGroup getStateMappingGroup(Version var1);

    public static class Builder {
        private final SortedMap<Version, StateMappingGroup> versions = new TreeMap(Comparator.reverseOrder());
        private StateMappingGroup defaultStateMappingGroup;

        public Builder defaults(StateMappingGroup group) {
            Preconditions.checkArgument(this.defaultStateMappingGroup == null, "Cannot set more than one default group!");
            this.defaultStateMappingGroup = group;
            return this;
        }

        public Builder version(Version version, StateMappingGroup group) {
            Preconditions.checkArgument(this.versions.put(version, group) == null, "Duplicate group for version " + String.valueOf(version));
            return this;
        }

        public VersionedStateMappingGroup build() {
            Preconditions.checkArgument(this.defaultStateMappingGroup != null || !this.versions.isEmpty(), "No state groups have been set!");
            return new Impl(this.defaultStateMappingGroup, this.versions);
        }
    }

    public static class Impl
    implements VersionedStateMappingGroup {
        private final StateMappingGroup defaultStateMappingGroup;
        private final SortedMap<Version, StateMappingGroup> versions;

        private Impl(StateMappingGroup defaultStateMappingGroup, SortedMap<Version, StateMappingGroup> versions) {
            this.defaultStateMappingGroup = defaultStateMappingGroup;
            this.versions = versions;
        }

        @Override
        public StateMappingGroup getStateMappingGroup(Version version) {
            for (Map.Entry<Version, StateMappingGroup> entry : this.versions.entrySet()) {
                if (!entry.getKey().isLessThanOrEqual(version)) continue;
                return entry.getValue();
            }
            return this.defaultStateMappingGroup;
        }
    }
}

