/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.base.resolver.identifier.state;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.hivemc.chunker.conversion.encoding.base.resolver.identifier.state.StateLookupFunction;
import com.hivemc.chunker.conversion.encoding.base.resolver.identifier.state.TypeMapping;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.states.BlockState;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.states.BlockStateValue;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class StateMapping<I, O extends BlockStateValue> {
    private final List<String> inputStateNames;
    private final List<BlockState<? extends O>> outputBlockStates;
    private final TypeMapping<I, O> typeMapping;

    public StateMapping(List<String> inputStateNames, List<BlockState<? extends O>> blockStates, TypeMapping<I, O> typeMapping) {
        this.inputStateNames = inputStateNames;
        this.outputBlockStates = blockStates;
        this.typeMapping = typeMapping;
        Preconditions.checkArgument(typeMapping.getInputTypes().size() == inputStateNames.size(), "The number of provided input names does not match the number of states the type supports, found %s expected %s", inputStateNames.size(), typeMapping.getInputTypes().size());
        Preconditions.checkArgument(typeMapping.getOutputTypes().size() == blockStates.size(), "The number of provided output states does not match the number of states the type supports, found %s expected %s", blockStates.size(), typeMapping.getOutputTypes().size());
        int stateCombinations = 1;
        for (int i = 0; i < blockStates.size(); ++i) {
            BlockState<O> blockState = blockStates.get(i);
            stateCombinations *= blockState.getValues().length;
            Class<O> expectedType = typeMapping.getOutputTypes().get(i);
            Preconditions.checkArgument(expectedType.isAssignableFrom(blockState.getValues()[0].getClass()), "The BlockState provided does not provide a class matching the type mapping output, got %s, expected %s.", blockState.getValues()[0].getClass(), expectedType);
        }
        if (typeMapping.getOutputToInput().size() != stateCombinations) {
            HashSet combinations = new HashSet(Lists.cartesianProduct(blockStates.stream().map(a -> List.of(a.getValues())).collect(Collectors.toList())));
            combinations.removeAll(typeMapping.getOutputToInput().keySet());
            throw new IllegalArgumentException("Missing TypeMapping combinations " + String.valueOf(combinations) + ", expected " + stateCombinations + " but got " + typeMapping.getOutputToInput().size());
        }
    }

    public List<String> getInputStateNames() {
        return this.inputStateNames;
    }

    public List<BlockState<? extends O>> getOutputBlockStates() {
        return this.outputBlockStates;
    }

    public TypeMapping<I, O> getTypeMapping() {
        return this.typeMapping;
    }

    public void applyInput(StateLookupFunction<String, Object> inputStateLookup, Map<BlockState<?>, BlockStateValue> outputs, boolean allowDefaultValue) {
        List<O> typeOutput;
        ArrayList<Object> inputValues = new ArrayList<Object>(this.inputStateNames.size());
        for (String name : this.inputStateNames) {
            Object value = inputStateLookup.getState(name, allowDefaultValue && this.typeMapping.getDefaultOutput() == null);
            if (value == null) {
                inputValues = null;
                break;
            }
            inputValues.add(value);
        }
        List<O> list = typeOutput = inputValues == null ? null : this.typeMapping.getInputToOutput().get(inputValues);
        if (typeOutput == null) {
            if (allowDefaultValue) {
                typeOutput = this.typeMapping.getDefaultOutput();
            }
            if (typeOutput == null) {
                return;
            }
        }
        Iterator<BlockState<O>> outputKeyIterator = this.outputBlockStates.iterator();
        Iterator<O> outputValueIterator = typeOutput.iterator();
        while (outputKeyIterator.hasNext()) {
            outputs.putIfAbsent(outputKeyIterator.next(), (BlockStateValue)outputValueIterator.next());
        }
    }

    public void applyOutput(StateLookupFunction<BlockState<?>, BlockStateValue> outputStateLookup, Map<String, Object> inputs, boolean allowDefaultValue) {
        List<I> typeInput;
        ArrayList<BlockStateValue> outputValues = new ArrayList<BlockStateValue>(this.outputBlockStates.size());
        for (BlockState<? extends O> blockState : this.outputBlockStates) {
            BlockStateValue value = outputStateLookup.getState(blockState, allowDefaultValue && this.typeMapping.getDefaultInput() == null);
            if (value == null) {
                outputValues = null;
                break;
            }
            outputValues.add(value);
        }
        List<I> list = typeInput = outputValues == null ? null : this.typeMapping.getOutputToInput().get(outputValues);
        if (typeInput == null) {
            if (allowDefaultValue) {
                typeInput = this.typeMapping.getDefaultInput();
            }
            if (typeInput == null) {
                return;
            }
        }
        Iterator<String> iterator = this.inputStateNames.iterator();
        Iterator<I> inputValueIterator = typeInput.iterator();
        while (iterator.hasNext()) {
            inputs.putIfAbsent(iterator.next(), inputValueIterator.next());
        }
    }
}

