/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.base.resolver.identifier;

import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Multimap;
import com.hivemc.chunker.conversion.encoding.base.resolver.identifier.ComparableItemProperty;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.ChunkerItemStackIdentifierType;
import java.util.Collections;
import java.util.Map;
import java.util.NavigableMap;
import java.util.OptionalInt;

public class ItemMapping {
    private final String identifier;
    private final ChunkerItemStackIdentifierType itemStackIdentifierType;
    private final NavigableMap<String, Object> states;
    private final NavigableMap<ComparableItemProperty<?>, Object> properties;

    public ItemMapping(String identifier, ChunkerItemStackIdentifierType itemStackIdentifierType, NavigableMap<String, Object> inputStates, NavigableMap<ComparableItemProperty<?>, Object> properties) {
        this.identifier = identifier;
        this.itemStackIdentifierType = itemStackIdentifierType;
        this.states = inputStates;
        this.properties = properties;
    }

    public ItemMapping(String identifier, ChunkerItemStackIdentifierType itemStackIdentifierType, OptionalInt data, NavigableMap<ComparableItemProperty<?>, Object> properties) {
        this.identifier = identifier;
        this.itemStackIdentifierType = itemStackIdentifierType;
        this.states = data.isEmpty() ? Collections.emptyNavigableMap() : ImmutableSortedMap.of("data", data.getAsInt());
        this.properties = properties;
    }

    public static ItemMapping of(String identifier, ChunkerItemStackIdentifierType itemType) {
        return new ItemMapping(identifier, itemType, OptionalInt.empty(), Collections.emptyNavigableMap());
    }

    public static ItemMapping of(String identifier, Map<String, Object> inputStates, ChunkerItemStackIdentifierType itemType) {
        return new ItemMapping(identifier, itemType, ImmutableSortedMap.copyOf(inputStates), Collections.emptyNavigableMap());
    }

    public static ItemMapping of(String identifier, int dataValue, ChunkerItemStackIdentifierType itemType) {
        return new ItemMapping(identifier, itemType, OptionalInt.of(dataValue), Collections.emptyNavigableMap());
    }

    public static <P extends ComparableItemProperty<? extends V>, V> ItemMapping of(String identifier, int dataValue, ChunkerItemStackIdentifierType itemType, P property, V propertyValue) {
        return new ItemMapping(identifier, itemType, OptionalInt.of(dataValue), ImmutableSortedMap.of(property, propertyValue));
    }

    public static <P extends ComparableItemProperty<? extends V>, V> ItemMapping of(String identifier, ChunkerItemStackIdentifierType itemType, Map<P, V> properties) {
        return new ItemMapping(identifier, itemType, OptionalInt.empty(), ImmutableSortedMap.copyOf(properties));
    }

    public static <P extends ComparableItemProperty<? extends V>, V> ItemMapping of(String identifier, int dataValue, ChunkerItemStackIdentifierType itemType, Map<P, V> properties) {
        return new ItemMapping(identifier, itemType, OptionalInt.of(dataValue), ImmutableSortedMap.copyOf(properties));
    }

    public static <P extends ComparableItemProperty<? extends V>, V> ItemMapping of(String identifier, ChunkerItemStackIdentifierType itemType, P property, V propertyValue) {
        return new ItemMapping(identifier, itemType, OptionalInt.empty(), ImmutableSortedMap.of(property, propertyValue));
    }

    public static ItemMapping[] group(Multimap<String, ? extends ChunkerItemStackIdentifierType> types) {
        ItemMapping[] mappings = new ItemMapping[types.size()];
        int i = 0;
        for (Map.Entry<String, ? extends ChunkerItemStackIdentifierType> entry : types.entries()) {
            mappings[i++] = new ItemMapping(entry.getKey(), entry.getValue(), OptionalInt.empty(), Collections.emptyNavigableMap());
        }
        return mappings;
    }

    public static ItemMapping[] flatten(String identifier, Multimap<Integer, ? extends ChunkerItemStackIdentifierType> dataToItemType) {
        ItemMapping[] mappings = new ItemMapping[dataToItemType.size()];
        int i = 0;
        for (Map.Entry<Integer, ? extends ChunkerItemStackIdentifierType> entry : dataToItemType.entries()) {
            mappings[i++] = new ItemMapping(identifier, entry.getValue(), OptionalInt.of(entry.getKey()), Collections.emptyNavigableMap());
        }
        return mappings;
    }

    public static <P extends ComparableItemProperty<? extends V>, V> ItemMapping[] flatten(String identifier, Multimap<Integer, ? extends ChunkerItemStackIdentifierType> dataToItemType, P property, V propertyValue) {
        ItemMapping[] mappings = new ItemMapping[dataToItemType.size()];
        int i = 0;
        ImmutableSortedMap<ComparableItemProperty<?>, Object> properties = ImmutableSortedMap.of(property, propertyValue);
        for (Map.Entry<Integer, ? extends ChunkerItemStackIdentifierType> entry : dataToItemType.entries()) {
            mappings[i++] = new ItemMapping(identifier, entry.getValue(), OptionalInt.of(entry.getKey()), properties);
        }
        return mappings;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public ChunkerItemStackIdentifierType getItemStackIdentifierType() {
        return this.itemStackIdentifierType;
    }

    public NavigableMap<String, Object> getStates() {
        return this.states;
    }

    public NavigableMap<ComparableItemProperty<?>, Object> getProperties() {
        return this.properties;
    }
}

