/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.base.resolver.identifier;

import com.google.common.base.Preconditions;
import com.hivemc.chunker.conversion.encoding.base.Converter;
import com.hivemc.chunker.conversion.encoding.base.Version;
import com.hivemc.chunker.conversion.encoding.base.resolver.identifier.BlockMapping;
import com.hivemc.chunker.conversion.encoding.base.resolver.identifier.state.StateLookupFunction;
import com.hivemc.chunker.conversion.encoding.base.resolver.identifier.state.StateMappingGroup;
import com.hivemc.chunker.conversion.encoding.base.resolver.identifier.state.VersionedStateMappingGroup;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.ChunkerBlockIdentifier;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.PreservedIdentifier;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.ChunkerBlockType;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.ChunkerCustomBlockType;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.ChunkerVanillaBlockType;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.states.BlockState;
import com.hivemc.chunker.conversion.intermediate.column.chunk.identifier.type.block.states.BlockStateValue;
import com.hivemc.chunker.mapping.identifier.Identifier;
import com.hivemc.chunker.mapping.identifier.states.StateValue;
import com.hivemc.chunker.mapping.resolver.MappingsFileResolvers;
import com.hivemc.chunker.resolver.Resolver;
import com.hivemc.chunker.util.CollectionComparator;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Optional;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.function.BiFunction;
import org.jetbrains.annotations.Nullable;

public abstract class ChunkerBlockIdentifierResolver
implements Resolver<Identifier, ChunkerBlockIdentifier> {
    protected final Converter converter;
    protected final Version version;
    protected final boolean customIdentifiersAllowed;
    protected final boolean reader;
    protected final Map<String, InputStateGrouping<String, Object, ChunkerBlockType, BlockState<?>, BlockStateValue>> inputToChunker = new Object2ObjectOpenHashMap();
    protected final Map<ChunkerBlockType, InputStateGrouping<BlockState<?>, BlockStateValue, String, String, Object>> chunkerToInput = new Object2ObjectOpenHashMap();
    protected StateMappingGroup extraStateMappingGroup;

    public ChunkerBlockIdentifierResolver(Converter converter, Version version, boolean reader, boolean customIdentifiersAllowed) {
        this.converter = converter;
        this.version = version;
        this.reader = reader;
        this.customIdentifiersAllowed = customIdentifiersAllowed;
        this.registerMappings(version);
    }

    private <I, IK extends Comparable<? super IK>, IV, O, OK, OV> void createMapping(Map<I, InputStateGrouping<IK, IV, O, OK, OV>> lookup, I inputIdentifier, NavigableMap<IK, IV> inputStates, O outputIdentifier, NavigableMap<OK, OV> outputStates, StateMappingGroup stateMappingGroup, boolean override) {
        InputStateGrouping inputStateGrouping = lookup.computeIfAbsent(inputIdentifier, ignored -> new InputStateGrouping(true));
        OutputMapping<O, OK, OV> outputMapping = new OutputMapping<O, OK, OV>(outputIdentifier, outputStates, stateMappingGroup);
        Map inputStateLookup = inputStateGrouping.getGroups().computeIfAbsent(inputStates.navigableKeySet(), ignored -> new Object2ObjectOpenHashMap());
        ArrayList inputValues = new ArrayList(inputStates.values());
        if (override) {
            if (inputStateLookup.put(inputValues, outputMapping) == null) {
                throw new IllegalArgumentException("No existing mapping to override, identifier: " + String.valueOf(inputIdentifier) + " states: " + String.valueOf(inputStates));
            }
        } else if (inputStateLookup.putIfAbsent(inputValues, outputMapping) != null) {
            throw new IllegalArgumentException("Duplicate state lookup entry, identifier: " + String.valueOf(inputIdentifier) + " states: " + String.valueOf(inputStates));
        }
    }

    protected void registerDuplicateOverrideOutput(BlockMapping mapping) {
        this.createMapping(this.chunkerToInput, mapping.getBlockType(), mapping.getBlockStates(), mapping.getIdentifier(), mapping.getStates(), mapping.getStateMappingGroup(this.version), true);
    }

    protected void registerOverrideOutput(BlockMapping mapping) {
        this.createMapping(this.inputToChunker, mapping.getIdentifier(), mapping.getStates(), mapping.getBlockType(), mapping.getBlockStates(), mapping.getStateMappingGroup(this.version), false);
        this.createMapping(this.chunkerToInput, mapping.getBlockType(), mapping.getBlockStates(), mapping.getIdentifier(), mapping.getStates(), mapping.getStateMappingGroup(this.version), true);
    }

    protected void registerDuplicateOverrideInput(BlockMapping mapping) {
        this.createMapping(this.inputToChunker, mapping.getIdentifier(), mapping.getStates(), mapping.getBlockType(), mapping.getBlockStates(), mapping.getStateMappingGroup(this.version), true);
    }

    protected void registerOverrideInput(BlockMapping mapping) {
        this.createMapping(this.inputToChunker, mapping.getIdentifier(), mapping.getStates(), mapping.getBlockType(), mapping.getBlockStates(), mapping.getStateMappingGroup(this.version), true);
        this.createMapping(this.chunkerToInput, mapping.getBlockType(), mapping.getBlockStates(), mapping.getIdentifier(), mapping.getStates(), mapping.getStateMappingGroup(this.version), false);
    }

    protected void registerOverrideInputOutput(BlockMapping mapping) {
        this.createMapping(this.inputToChunker, mapping.getIdentifier(), mapping.getStates(), mapping.getBlockType(), mapping.getBlockStates(), mapping.getStateMappingGroup(this.version), true);
        this.createMapping(this.chunkerToInput, mapping.getBlockType(), mapping.getBlockStates(), mapping.getIdentifier(), mapping.getStates(), mapping.getStateMappingGroup(this.version), true);
    }

    protected void registerOverrideOutput(BlockMapping[] mappings) {
        for (BlockMapping mapping : mappings) {
            this.registerOverrideOutput(mapping);
        }
    }

    protected void registerOverrideInput(BlockMapping[] mappings) {
        for (BlockMapping mapping : mappings) {
            this.registerOverrideInput(mapping);
        }
    }

    protected void registerDuplicateInput(BlockMapping mapping) {
        this.createMapping(this.chunkerToInput, mapping.getBlockType(), mapping.getBlockStates(), mapping.getIdentifier(), mapping.getStates(), mapping.getStateMappingGroup(this.version), false);
    }

    protected void registerDuplicateInput(BlockMapping[] mappings) {
        for (BlockMapping mapping : mappings) {
            this.registerDuplicateInput(mapping);
        }
    }

    protected void registerDuplicateOutput(BlockMapping mapping) {
        this.createMapping(this.inputToChunker, mapping.getIdentifier(), mapping.getStates(), mapping.getBlockType(), mapping.getBlockStates(), mapping.getStateMappingGroup(this.version), false);
    }

    protected void registerDuplicateOutput(BlockMapping[] mappings) {
        for (BlockMapping mapping : mappings) {
            this.registerDuplicateOutput(mapping);
        }
    }

    protected void register(BlockMapping mapping) {
        this.createMapping(this.inputToChunker, mapping.getIdentifier(), mapping.getStates(), mapping.getBlockType(), mapping.getBlockStates(), mapping.getStateMappingGroup(this.version), false);
        this.createMapping(this.chunkerToInput, mapping.getBlockType(), mapping.getBlockStates(), mapping.getIdentifier(), mapping.getStates(), mapping.getStateMappingGroup(this.version), false);
    }

    protected void register(BlockMapping[] mappings) {
        for (BlockMapping mapping : mappings) {
            this.register(mapping);
        }
    }

    protected void extraStateMappingGroup(VersionedStateMappingGroup stateMappingGroup) {
        Preconditions.checkArgument(this.extraStateMappingGroup == null, "Only a single extra state mapping group is allowed.");
        this.extraStateMappingGroup = stateMappingGroup.getStateMappingGroup(this.version);
    }

    protected void removeOutputMapping(ChunkerBlockType chunkerBlockType) {
        this.chunkerToInput.remove(chunkerBlockType);
    }

    public abstract void registerMappings(Version var1);

    public boolean isSupported(String identifier) {
        return this.inputToChunker.containsKey(identifier);
    }

    public boolean isSupported(ChunkerBlockType chunkerBlockType) {
        return this.chunkerToInput.containsKey(chunkerBlockType);
    }

    protected Optional<ChunkerBlockIdentifier> handleConverterMapping(Identifier input, Optional<ChunkerBlockIdentifier> output) {
        MappingsFileResolvers mappingsFileResolvers = this.converter.getBlockMappings();
        if (mappingsFileResolvers == null) {
            return output;
        }
        Optional<Identifier> mappedIdentifier = (this.reader ? mappingsFileResolvers.getMappings() : mappingsFileResolvers.getInverseMappings()).convertBlock(input);
        if (mappedIdentifier.isEmpty()) {
            return output;
        }
        return output.map(chunkerBlockIdentifier -> new ChunkerBlockIdentifier(chunkerBlockIdentifier.getType(), chunkerBlockIdentifier.getPresentStates(), new PreservedIdentifier(this.reader, (Identifier)mappedIdentifier.get()))).or(() -> Optional.of(new ChunkerBlockIdentifier(ChunkerVanillaBlockType.STONE, Collections.emptyMap(), new PreservedIdentifier(this.reader, (Identifier)mappedIdentifier.get()))));
    }

    protected Optional<Identifier> handleConverterMapping(ChunkerBlockIdentifier input, Optional<Identifier> output) {
        if (input.getPreservedIdentifier() == null || this.reader == input.getPreservedIdentifier().fromReader()) {
            return output;
        }
        Optional<ChunkerBlockIdentifier> preservedAsChunker = this.resolveTo(input.getPreservedIdentifier().identifier());
        if (preservedAsChunker.isPresent()) {
            Object2ObjectOpenHashMap states = new Object2ObjectOpenHashMap(preservedAsChunker.get().getPresentStates());
            states.putAll(input.getPresentStates());
            ChunkerBlockIdentifier merged = new ChunkerBlockIdentifier(preservedAsChunker.get().getType(), states);
            Optional<Identifier> preservedConverted = this.resolveFrom(merged);
            if (preservedConverted.isPresent()) {
                Object2ObjectOpenHashMap newOutputStates = new Object2ObjectOpenHashMap(preservedConverted.get().getStates());
                newOutputStates.putAll(input.getPreservedIdentifier().identifier().getStates());
                return Optional.of(new Identifier(input.getPreservedIdentifier().identifier().getIdentifier(), newOutputStates));
            }
        }
        return Optional.of(input.getPreservedIdentifier().identifier());
    }

    protected Optional<ChunkerBlockIdentifier> handleFallback(Identifier identifier) {
        if (identifier.getIdentifier().startsWith("minecraft:") || !identifier.getIdentifier().contains(":") || !this.customIdentifiersAllowed) {
            return Optional.empty();
        }
        return Optional.of(ChunkerBlockIdentifier.custom(identifier.getIdentifier(), identifier.getBoxedStates()));
    }

    protected Optional<Identifier> handleFallback(ChunkerBlockIdentifier input) {
        ChunkerCustomBlockType chunkerCustomBlockType;
        block4: {
            block3: {
                ChunkerBlockType chunkerBlockType = input.getType();
                if (!(chunkerBlockType instanceof ChunkerCustomBlockType)) break block3;
                chunkerCustomBlockType = (ChunkerCustomBlockType)chunkerBlockType;
                if (this.customIdentifiersAllowed) break block4;
            }
            return Optional.empty();
        }
        Map<BlockState<?>, BlockStateValue> states = input.getPresentStates();
        Object2ObjectOpenHashMap newMap = new Object2ObjectOpenHashMap(states.size());
        for (Map.Entry<BlockState<?>, BlockStateValue> entry : states.entrySet()) {
            BlockStateValue blockStateValue = entry.getValue();
            if (!(blockStateValue instanceof ChunkerCustomBlockType.CustomBlockStateValue)) continue;
            ChunkerCustomBlockType.CustomBlockStateValue customBlockStateValue = (ChunkerCustomBlockType.CustomBlockStateValue)blockStateValue;
            newMap.put(entry.getKey().getName(), StateValue.fromBoxed(customBlockStateValue.getStateValue()));
        }
        return Optional.of(new Identifier(chunkerCustomBlockType.getIdentifier(), newMap));
    }

    @Override
    public Optional<ChunkerBlockIdentifier> to(Identifier input) {
        return this.handleConverterMapping(input, this.resolveTo(input));
    }

    protected Optional<ChunkerBlockIdentifier> resolveTo(Identifier input) {
        Optional<ChunkerBlockIdentifier> result = this.resolve(this.inputToChunker, input.getIdentifier(), input.getBoxedStates()::get, StateMappingGroup::applyInput, ChunkerBlockIdentifier::new);
        if (result.isEmpty()) {
            result = this.handleFallback(input);
        }
        return result;
    }

    @Override
    public Optional<Identifier> from(ChunkerBlockIdentifier input) {
        return this.handleConverterMapping(input, this.resolveFrom(input));
    }

    protected Optional<Identifier> resolveFrom(ChunkerBlockIdentifier input) {
        Optional<Identifier> result = this.resolve(this.chunkerToInput, input.getType(), input::getState, StateMappingGroup::applyOutput, Identifier::fromBoxed);
        if (result.isEmpty()) {
            result = this.handleFallback(input);
        }
        return result;
    }

    private <I, IK extends Comparable<? super IK>, IV, O, OK, OV, T> Optional<T> resolve(Map<I, InputStateGrouping<IK, IV, O, OK, OV>> lookup, I inputIdentifier, StateLookupFunction<IK, IV> inputStateLookup, StateMappingGroupHandler<IK, IV, OK, OV> mappingGroupHandler, BiFunction<O, Map<OK, OV>, T> outputConstructor) {
        InputStateGrouping<IK, IV, O, OK, OV> grouping = lookup.get(inputIdentifier);
        if (grouping == null) {
            return Optional.empty();
        }
        ArrayList<IV> tempList = new ArrayList<IV>();
        block0: for (Map.Entry<SortedSet<IK>, Map<List<IV>, OutputMapping<O, OK, OV>>> group : grouping.getGroups().entrySet()) {
            for (Comparable stateName : group.getKey()) {
                IV stateValue = inputStateLookup.getState(stateName, grouping.isDefaultsAllowed());
                if (stateValue == null) {
                    tempList.clear();
                    continue block0;
                }
                tempList.add(stateValue);
            }
            OutputMapping<O, OK, OV> mapping = group.getValue().get(tempList);
            if (mapping != null) {
                Object2ObjectOpenHashMap<OK, OV> states = new Object2ObjectOpenHashMap<OK, OV>(mapping.getOutputs().size());
                states.putAll(mapping.getOutputs());
                StateMappingGroup stateMappingGroup = mapping.getGroup();
                if (stateMappingGroup != null) {
                    mappingGroupHandler.apply(stateMappingGroup, inputStateLookup, states);
                }
                if (this.extraStateMappingGroup != null) {
                    mappingGroupHandler.apply(this.extraStateMappingGroup, inputStateLookup, states);
                }
                return Optional.of(outputConstructor.apply(mapping.getIdentifier(), states));
            }
            tempList.clear();
        }
        return Optional.empty();
    }

    public static class InputStateGrouping<IK extends Comparable<? super IK>, IV, O, OK, OV> {
        private final boolean defaultsAllowed;
        private final TreeMap<SortedSet<IK>, Map<List<IV>, OutputMapping<O, OK, OV>>> groups = new TreeMap(new CollectionComparator().reversed());

        public InputStateGrouping(boolean defaultsAllowed) {
            this.defaultsAllowed = defaultsAllowed;
        }

        public TreeMap<SortedSet<IK>, Map<List<IV>, OutputMapping<O, OK, OV>>> getGroups() {
            return this.groups;
        }

        public boolean isDefaultsAllowed() {
            return this.defaultsAllowed;
        }
    }

    public static class OutputMapping<O, OK, OV> {
        private final O identifier;
        private final Map<OK, OV> outputs;
        private final StateMappingGroup group;

        public OutputMapping(O identifier, Map<OK, OV> outputs, StateMappingGroup group) {
            this.identifier = identifier;
            this.outputs = outputs;
            this.group = group;
        }

        public O getIdentifier() {
            return this.identifier;
        }

        public Map<OK, OV> getOutputs() {
            return this.outputs;
        }

        @Nullable
        public StateMappingGroup getGroup() {
            return this.group;
        }
    }

    static interface StateMappingGroupHandler<IK, IV, OK, OV> {
        public void apply(StateMappingGroup var1, StateLookupFunction<IK, IV> var2, Map<OK, OV> var3);
    }
}

