/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding.base;

import java.util.Objects;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public class Version
implements Comparable<Version> {
    public static final Version LATEST = new Version(Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE);
    private final int major;
    private final int minor;
    private final int patch;

    public Version(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
    }

    public static Version fromString(String input) {
        String[] parts = input.split(Pattern.quote("."));
        int major = 0;
        int minor = 0;
        int patch = 0;
        if (parts.length > 0) {
            major = Integer.parseInt(parts[0]);
            if (parts.length > 1) {
                minor = Integer.parseInt(parts[1]);
            }
            if (parts.length > 2) {
                patch = Integer.parseInt(parts[2]);
            }
        }
        return new Version(major, minor, patch);
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public boolean isGreaterThanOrEqual(Version version) {
        return this.isGreaterThanOrEqual(version.getMajor(), version.getMinor(), version.getPatch());
    }

    public boolean isGreaterThanOrEqual(int major, int minor, int patch) {
        if (this.major > major) {
            return true;
        }
        if (this.major < major) {
            return false;
        }
        if (this.minor > minor) {
            return true;
        }
        if (this.minor < minor) {
            return false;
        }
        if (this.patch > patch) {
            return true;
        }
        return this.patch >= patch;
    }

    public boolean isGreaterThan(Version version) {
        return this.isGreaterThan(version.getMajor(), version.getMinor(), version.getPatch());
    }

    public boolean isGreaterThan(int major, int minor, int patch) {
        if (this.major > major) {
            return true;
        }
        if (this.major < major) {
            return false;
        }
        if (this.minor > minor) {
            return true;
        }
        if (this.minor < minor) {
            return false;
        }
        return this.patch > patch;
    }

    public boolean isLessThanOrEqual(Version version) {
        return this.isLessThanOrEqual(version.getMajor(), version.getMinor(), version.getPatch());
    }

    public boolean isLessThanOrEqual(int major, int minor, int patch) {
        if (this.major < major) {
            return true;
        }
        if (this.major > major) {
            return false;
        }
        if (this.minor < minor) {
            return true;
        }
        if (this.minor > minor) {
            return false;
        }
        if (this.patch < patch) {
            return true;
        }
        return this.patch <= patch;
    }

    public boolean isLessThan(Version version) {
        return this.isLessThan(version.getMajor(), version.getMinor(), version.getPatch());
    }

    public boolean isLessThan(int major, int minor, int patch) {
        if (this.major < major) {
            return true;
        }
        if (this.major > major) {
            return false;
        }
        if (this.minor < minor) {
            return true;
        }
        if (this.minor > minor) {
            return false;
        }
        return this.patch < patch;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Version)) {
            return false;
        }
        Version version = (Version)o;
        return this.getMajor() == version.getMajor() && this.getMinor() == version.getMinor() && this.getPatch() == version.getPatch();
    }

    public int hashCode() {
        return Objects.hash(this.getMajor(), this.getMinor(), this.getPatch());
    }

    public String toString() {
        return String.valueOf(this.major) + "." + this.minor + "." + this.patch;
    }

    @Override
    public int compareTo(@NotNull Version o) {
        if (this.equals(o)) {
            return 0;
        }
        if (this.isLessThan(o.getMajor(), o.getMinor(), o.getPatch())) {
            return -1;
        }
        return 1;
    }
}

