/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.conversion.encoding;

import com.hivemc.chunker.conversion.encoding.EncoderLevelReaderConstructor;
import com.hivemc.chunker.conversion.encoding.EncoderLevelWriterConstructor;
import com.hivemc.chunker.conversion.encoding.base.Converter;
import com.hivemc.chunker.conversion.encoding.base.Version;
import com.hivemc.chunker.conversion.encoding.base.reader.LevelReader;
import com.hivemc.chunker.conversion.encoding.base.writer.LevelWriter;
import com.hivemc.chunker.conversion.encoding.bedrock.BedrockEncoders;
import com.hivemc.chunker.conversion.encoding.java.JavaEncoders;
import com.hivemc.chunker.conversion.encoding.preview.PreviewLevelWriter;
import com.hivemc.chunker.conversion.encoding.settings.SettingsLevelWriter;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;

public class EncodingType {
    private static final Set<EncodingType> TYPES = new ObjectLinkedOpenHashSet<EncodingType>();
    private static final Set<EncodingType> READABLE_TYPES = new ObjectLinkedOpenHashSet<EncodingType>();
    private static final Set<EncodingType> WRITEABLE_TYPES = new ObjectLinkedOpenHashSet<EncodingType>();
    public static final EncodingType JAVA = EncodingType.register("Java", false, JavaEncoders::createReader, JavaEncoders::createWriter, JavaEncoders.getSupportedVersions());
    public static final EncodingType BEDROCK = EncodingType.register("Bedrock", false, BedrockEncoders::createReader, BedrockEncoders::createWriter, BedrockEncoders.getSupportedVersions());
    public static final EncodingType PREVIEW = EncodingType.register("Preview", true, null, (directory, version, settings) -> Optional.of(new PreviewLevelWriter(directory)), Collections.emptyList());
    public static final EncodingType SETTINGS = EncodingType.register("Settings", true, null, (directory, version, settings) -> Optional.of(new SettingsLevelWriter(directory)), Collections.emptyList());
    private final String name;
    private final boolean internal;
    private final EncoderLevelReaderConstructor<?> readerConstructor;
    private final EncoderLevelWriterConstructor<?> writerConstructor;
    private final Collection<Version> supportedVersions;

    public EncodingType(String name, boolean internal, EncoderLevelReaderConstructor<?> readerConstructor, EncoderLevelWriterConstructor<?> writerConstructor, Collection<Version> supportedVersions) {
        this.name = name;
        this.internal = internal;
        this.readerConstructor = readerConstructor;
        this.writerConstructor = writerConstructor;
        this.supportedVersions = supportedVersions;
    }

    public static EncodingType register(String name, boolean internal, EncoderLevelReaderConstructor<?> reader, EncoderLevelWriterConstructor<?> writer, Collection<Version> supportedVersions) {
        EncodingType encodingType = new EncodingType(name, internal, reader, writer, supportedVersions);
        TYPES.add(encodingType);
        if (reader != null) {
            READABLE_TYPES.add(encodingType);
        }
        if (writer != null) {
            WRITEABLE_TYPES.add(encodingType);
        }
        return encodingType;
    }

    public static Optional<? extends LevelReader> findReader(File directory, Converter converter) {
        for (EncodingType encodingType : READABLE_TYPES) {
            Optional<? extends LevelReader> reader = encodingType.createReader(directory, converter);
            if (!reader.isPresent()) continue;
            return reader;
        }
        return Optional.empty();
    }

    public static Set<EncodingType> getTypes() {
        return Collections.unmodifiableSet(TYPES);
    }

    public static Set<EncodingType> getReadableTypes() {
        return Collections.unmodifiableSet(READABLE_TYPES);
    }

    public static Set<EncodingType> getWriteableTypes() {
        return Collections.unmodifiableSet(WRITEABLE_TYPES);
    }

    public String getName() {
        return this.name;
    }

    public Optional<? extends LevelReader> createReader(File directory, Converter converter) {
        if (this.readerConstructor == null) {
            return Optional.empty();
        }
        return this.readerConstructor.construct(directory, converter);
    }

    public Optional<? extends LevelWriter> createWriter(File directory, Version version, Converter converter) {
        if (this.writerConstructor == null) {
            return Optional.empty();
        }
        return this.writerConstructor.construct(directory, version, converter);
    }

    public Collection<Version> getSupportedVersions() {
        return this.supportedVersions;
    }

    public boolean isInternal() {
        return this.internal;
    }

    public String toString() {
        return "EncodingType{name='" + this.getName() + "'}";
    }
}

