/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.cli.messenger.messaging;

import com.hivemc.chunker.cli.messenger.messaging.request.ConvertRequest;
import com.hivemc.chunker.cli.messenger.messaging.request.DetectVersionRequest;
import com.hivemc.chunker.cli.messenger.messaging.request.KillRequest;
import com.hivemc.chunker.cli.messenger.messaging.request.PreviewRequest;
import com.hivemc.chunker.cli.messenger.messaging.request.SettingsRequest;
import com.hivemc.chunker.cli.messenger.messaging.response.ErrorResponse;
import com.hivemc.chunker.cli.messenger.messaging.response.OutputResponse;
import com.hivemc.chunker.cli.messenger.messaging.response.ProgressResponse;
import com.hivemc.chunker.cli.messenger.messaging.response.ProgressStateResponse;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import java.util.UUID;

public abstract class BasicMessage {
    private final BasicMessageType type = BasicMessageType.CLASS_TO_MESSAGE.get(this.getClass());
    private final UUID requestId;

    public BasicMessage() {
        this.requestId = UUID.randomUUID();
    }

    public BasicMessage(UUID requestId) {
        this.requestId = requestId;
    }

    public BasicMessageType getType() {
        return this.type;
    }

    public UUID getRequestId() {
        return this.requestId;
    }

    public static enum BasicMessageType {
        DETECT_VERSION(DetectVersionRequest.class),
        SETTINGS(SettingsRequest.class),
        PREVIEW(PreviewRequest.class),
        CONVERT(ConvertRequest.class),
        KILL(KillRequest.class),
        RESPONSE(OutputResponse.class),
        PROGRESS(ProgressResponse.class),
        PROGRESS_STATE(ProgressStateResponse.class),
        ERROR(ErrorResponse.class);

        private static final Map<Class<? extends BasicMessage>, BasicMessageType> CLASS_TO_MESSAGE;
        private final Class<? extends BasicMessage> messageClass;

        private BasicMessageType(Class<? extends BasicMessage> messageClass) {
            this.messageClass = messageClass;
        }

        public Class<? extends BasicMessage> getMessageClass() {
            return this.messageClass;
        }

        static {
            CLASS_TO_MESSAGE = new Object2ObjectOpenHashMap<Class<? extends BasicMessage>, BasicMessageType>();
            for (BasicMessageType type : BasicMessageType.values()) {
                CLASS_TO_MESSAGE.put(type.getMessageClass(), type);
            }
        }
    }
}

