/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.cli.messenger;

import com.google.common.util.concurrent.ExecutionError;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.hivemc.chunker.cli.messenger.messaging.BasicMessage;
import com.hivemc.chunker.cli.messenger.messaging.BasicMessageTypeAdapter;
import com.hivemc.chunker.cli.messenger.messaging.request.ConvertRequest;
import com.hivemc.chunker.cli.messenger.messaging.request.DetectVersionRequest;
import com.hivemc.chunker.cli.messenger.messaging.request.KillRequest;
import com.hivemc.chunker.cli.messenger.messaging.request.PreviewRequest;
import com.hivemc.chunker.cli.messenger.messaging.request.SettingsRequest;
import com.hivemc.chunker.cli.messenger.messaging.response.ErrorResponse;
import com.hivemc.chunker.cli.messenger.messaging.response.OutputResponse;
import com.hivemc.chunker.cli.messenger.messaging.response.ProgressResponse;
import com.hivemc.chunker.cli.messenger.messaging.response.ProgressStateResponse;
import com.hivemc.chunker.conversion.WorldConverter;
import com.hivemc.chunker.conversion.encoding.EncodingType;
import com.hivemc.chunker.conversion.encoding.base.Converter;
import com.hivemc.chunker.conversion.encoding.base.Version;
import com.hivemc.chunker.conversion.encoding.base.reader.LevelReader;
import com.hivemc.chunker.conversion.encoding.base.writer.LevelWriter;
import com.hivemc.chunker.conversion.encoding.preview.PreviewLevelWriter;
import com.hivemc.chunker.conversion.encoding.settings.SettingsLevelWriter;
import com.hivemc.chunker.conversion.intermediate.level.map.ChunkerMap;
import com.hivemc.chunker.conversion.intermediate.world.Dimension;
import com.hivemc.chunker.mapping.MappingsFile;
import com.hivemc.chunker.mapping.resolver.MappingsFileResolvers;
import com.hivemc.chunker.pruning.PruningConfig;
import com.hivemc.chunker.scheduling.LoggedException;
import com.hivemc.chunker.scheduling.TaskMonitorThread;
import com.hivemc.chunker.scheduling.task.TrackedTask;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Scanner;
import java.util.UUID;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import org.jetbrains.annotations.Nullable;

public class Messenger {
    private static final Map<UUID, Map<UUID, WorldConverter>> SESSION_ID_TO_WORLD_CONVERTERS = new Object2ObjectOpenHashMap<UUID, Map<UUID, WorldConverter>>();
    private static final Gson GSON = new GsonBuilder().registerTypeHierarchyAdapter(BasicMessage.class, new BasicMessageTypeAdapter()).create();

    public static void main(String[] args) {
        try {
            Scanner scanner = new Scanner(System.in);
            block15: while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                BasicMessage message = GSON.fromJson(line, BasicMessage.class);
                switch (message.getType()) {
                    case DETECT_VERSION: {
                        DetectVersionRequest detectVersionRequest = (DetectVersionRequest)message;
                        WorldConverter emptyWorldConverter = new WorldConverter(detectVersionRequest.getAnonymousId());
                        Optional<? extends LevelReader> reader = EncodingType.findReader(new File(detectVersionRequest.getInputPath()), emptyWorldConverter);
                        if (reader.isPresent()) {
                            LevelReader levelReader = reader.get();
                            JsonObject response = new JsonObject();
                            response.add("input", Messenger.toEncodedObject(levelReader.getEncodingType(), levelReader.getVersion()));
                            response.add("writers", Messenger.getWriters());
                            String warnings = levelReader.getWarnings();
                            response.add("warnings", warnings == null ? null : new JsonPrimitive(warnings));
                            Messenger.write(new OutputResponse(message.getRequestId(), response));
                            break;
                        }
                        Messenger.write(new ErrorResponse(message.getRequestId(), false, "World format is not supported.", "", null, null));
                        break;
                    }
                    case SETTINGS: {
                        SettingsRequest settingsRequest = (SettingsRequest)message;
                        WorldConverter worldConverter = Messenger.createWorldConverter(settingsRequest.getAnonymousId(), settingsRequest.getRequestId());
                        boolean started2 = Messenger.startConversionRequest(settingsRequest.getAnonymousId(), settingsRequest.getRequestId(), worldConverter, new File(settingsRequest.getInputPath()), new SettingsLevelWriter(new File(settingsRequest.getOutputPath())));
                        worldConverter.setProcessLighting(false);
                        worldConverter.setProcessHeightMap(false);
                        worldConverter.setProcessBlockEntities(false);
                        worldConverter.setProcessColumnPreTransform(false);
                        worldConverter.setProcessEntities(false);
                        worldConverter.setProcessBiomes(false);
                        worldConverter.setProcessItems(false);
                        if (started2) continue block15;
                        Messenger.removeWorldConverter(settingsRequest.getAnonymousId(), settingsRequest.getRequestId());
                        Messenger.write(new ErrorResponse(settingsRequest.getRequestId(), false, "Failed to start settings task.", null, null, null));
                        break;
                    }
                    case PREVIEW: {
                        PreviewRequest previewRequest = (PreviewRequest)message;
                        WorldConverter worldConverter = Messenger.createWorldConverter(previewRequest.getAnonymousId(), previewRequest.getRequestId());
                        boolean started3 = Messenger.startConversionRequest(previewRequest.getAnonymousId(), previewRequest.getRequestId(), worldConverter, new File(previewRequest.getInputPath()), new PreviewLevelWriter(new File(previewRequest.getOutputPath())));
                        worldConverter.setDimensionMapping(previewRequest.getInputToOutputDimension());
                        if (previewRequest.getPruningList() != null && previewRequest.getPruningList().getConfigs() != null && !previewRequest.getPruningList().getConfigs().isEmpty()) {
                            Object2ObjectOpenHashMap<Dimension, PruningConfig> pruningConfigs = new Object2ObjectOpenHashMap<Dimension, PruningConfig>(previewRequest.getPruningList().getConfigs().size());
                            for (int i = 0; i < previewRequest.getPruningList().getConfigs().size(); ++i) {
                                pruningConfigs.put(Dimension.values()[i], previewRequest.getPruningList().getConfigs().get(i));
                            }
                            worldConverter.setPruningConfigs(pruningConfigs);
                        }
                        worldConverter.setProcessMaps(false);
                        worldConverter.setProcessLighting(false);
                        worldConverter.setProcessHeightMap(false);
                        worldConverter.setProcessBlockEntities(false);
                        worldConverter.setProcessColumnPreTransform(false);
                        worldConverter.setProcessEntities(false);
                        worldConverter.setProcessBiomes(false);
                        worldConverter.setProcessItems(false);
                        if (started3) continue block15;
                        Messenger.removeWorldConverter(previewRequest.getAnonymousId(), previewRequest.getRequestId());
                        Messenger.write(new ErrorResponse(previewRequest.getRequestId(), false, "Failed to start preview.", null, null, null));
                        break;
                    }
                    case CONVERT: {
                        ConvertRequest convertRequest = (ConvertRequest)message;
                        WorldConverter worldConverter = Messenger.createWorldConverter(convertRequest.getAnonymousId(), convertRequest.getRequestId());
                        if (convertRequest.getMappings() != null && !convertRequest.getMappings().isEmpty()) {
                            try {
                                worldConverter.setBlockMappings(new MappingsFileResolvers(MappingsFile.load(convertRequest.getMappings())));
                            }
                            catch (Exception e) {
                                Messenger.removeWorldConverter(convertRequest.getAnonymousId(), convertRequest.getRequestId());
                                Messenger.write(new ErrorResponse(convertRequest.getRequestId(), false, "Failed to parse block mappings.", null, e.getMessage(), Messenger.printStackTrace(e)));
                                return;
                            }
                        }
                        worldConverter.setChangedSettings(convertRequest.getNbtSettings());
                        worldConverter.setDimensionMapping(convertRequest.getInputToOutputDimension());
                        if (convertRequest.getPruningList() != null && convertRequest.getPruningList().getConfigs() != null && !convertRequest.getPruningList().getConfigs().isEmpty()) {
                            Object2ObjectOpenHashMap<Dimension, PruningConfig> pruningConfigs = new Object2ObjectOpenHashMap<Dimension, PruningConfig>(convertRequest.getPruningList().getConfigs().size());
                            for (int i = 0; i < convertRequest.getPruningList().getConfigs().size(); ++i) {
                                pruningConfigs.put(Dimension.values()[i], convertRequest.getPruningList().getConfigs().get(i));
                            }
                            worldConverter.setPruningConfigs(pruningConfigs);
                        }
                        if (convertRequest.getMaps() != null) {
                            ArrayList<ChunkerMap> chunkerMaps = new ArrayList<ChunkerMap>(convertRequest.getMaps().size());
                            for (JsonElement element : convertRequest.getMaps()) {
                                JsonObject jsonObject = element.getAsJsonObject();
                                ChunkerMap map = GSON.fromJson((JsonElement)jsonObject, ChunkerMap.class);
                                if (jsonObject.has("file")) {
                                    try {
                                        map.loadImage(new File(jsonObject.get("file").getAsString()));
                                    }
                                    catch (IOException e) {
                                        Messenger.removeWorldConverter(convertRequest.getAnonymousId(), convertRequest.getRequestId());
                                        Messenger.write(new ErrorResponse(convertRequest.getRequestId(), false, "Failed to parse map " + map.getId() + ".", null, e.getMessage(), Messenger.printStackTrace(e)));
                                        return;
                                    }
                                }
                                chunkerMaps.add(map);
                            }
                            worldConverter.setMaps(chunkerMaps);
                        }
                        worldConverter.setDimensionMapping(convertRequest.getInputToOutputDimension());
                        worldConverter.setAllowNBTCopying(convertRequest.isCopyNbt());
                        worldConverter.setProcessMaps(!convertRequest.isSkipMaps());
                        worldConverter.setProcessLootTables(!convertRequest.isSkipLootTables());
                        worldConverter.setProcessItems(!convertRequest.isSkipItemConversion());
                        worldConverter.setProcessColumnPreTransform(!convertRequest.isSkipBlockConnections());
                        worldConverter.setLevelDBCompaction(convertRequest.isEnableCompact());
                        worldConverter.setDiscardEmptyChunks(convertRequest.isDiscardEmptyChunks());
                        worldConverter.setPreventYBiomeBlending(convertRequest.isPreventYBiomeBlending());
                        worldConverter.setCustomIdentifiers(convertRequest.isCustomIdentifiers());
                        worldConverter.setCompactionSignal(started -> {
                            if (started.booleanValue()) {
                                Messenger.write(new ProgressStateResponse(convertRequest.getRequestId(), "Compacting output", true));
                            } else {
                                Messenger.write(new ProgressStateResponse(convertRequest.getRequestId(), null, false));
                            }
                        });
                        Optional<? extends LevelWriter> writer = Messenger.findWriter(convertRequest.getOutputType(), worldConverter, new File(convertRequest.getOutputPath()));
                        if (writer.isEmpty()) {
                            Messenger.removeWorldConverter(convertRequest.getAnonymousId(), convertRequest.getRequestId());
                            Messenger.write(new ErrorResponse(convertRequest.getRequestId(), false, "Failed to find output type.", null, null, null));
                            break;
                        }
                        boolean started4 = Messenger.startConversionRequest(convertRequest.getAnonymousId(), convertRequest.getRequestId(), worldConverter, new File(convertRequest.getInputPath()), writer.get());
                        if (started4) continue block15;
                        Messenger.removeWorldConverter(convertRequest.getAnonymousId(), convertRequest.getRequestId());
                        Messenger.write(new ErrorResponse(convertRequest.getRequestId(), false, "Failed to start conversion.", null, null, null));
                        break;
                    }
                    case KILL: {
                        KillRequest killRequest = (KillRequest)message;
                        Map<UUID, WorldConverter> converters = SESSION_ID_TO_WORLD_CONVERTERS.get(killRequest.getAnonymousId());
                        if (converters != null) {
                            ArrayList<CompletableFuture<Void>> futures = new ArrayList<CompletableFuture<Void>>(converters.size());
                            for (WorldConverter worldConverter : converters.values()) {
                                futures.add(worldConverter.cancel(null));
                            }
                            CompletableFuture.allOf(futures.toArray(new CompletableFuture[0])).whenComplete((ex, result) -> Messenger.write(new OutputResponse(message.getRequestId(), new JsonPrimitive(true))));
                            break;
                        }
                        Messenger.write(new OutputResponse(message.getRequestId(), new JsonPrimitive(true)));
                        break;
                    }
                    default: {
                        Messenger.write(new ErrorResponse(message.getRequestId(), false, "Message type does not exist, outdated software?", null, null, null));
                    }
                }
            }
        }
        catch (OutOfMemoryError e) {
            try {
                e.printStackTrace();
            }
            catch (OutOfMemoryError outOfMemoryError) {
                // empty catch block
            }
            System.exit(12);
        }
    }

    public static void removeWorldConverter(UUID sessionID, UUID taskID) {
        Map<UUID, WorldConverter> taskToConverter = SESSION_ID_TO_WORLD_CONVERTERS.get(sessionID);
        if (taskToConverter != null) {
            taskToConverter.remove(taskID);
        }
    }

    public static WorldConverter createWorldConverter(UUID sessionID, UUID taskID) {
        WorldConverter worldConverter = new WorldConverter(sessionID);
        Map taskToConverter = SESSION_ID_TO_WORLD_CONVERTERS.computeIfAbsent(sessionID, ignored -> new Object2ObjectOpenHashMap());
        taskToConverter.put(taskID, worldConverter);
        return worldConverter;
    }

    public static Optional<? extends LevelWriter> findWriter(String id, WorldConverter worldConverter, File outputDirectory) {
        try {
            Optional<EncodingType> encodingType;
            int separatorIndex = id.indexOf("_");
            String type = separatorIndex == -1 ? id : id.substring(0, separatorIndex);
            Version version = null;
            if (separatorIndex != -1) {
                Object versionString = id.substring(separatorIndex + 1);
                if (((String)versionString).startsWith("R")) {
                    versionString = "1_" + ((String)versionString).substring(1);
                }
                versionString = ((String)versionString).replace('_', '.');
                version = Version.fromString((String)versionString);
            }
            if ((encodingType = Messenger.findEncodingType(type)).isEmpty()) {
                return Optional.empty();
            }
            return encodingType.get().createWriter(outputDirectory, version, worldConverter);
        }
        catch (Exception e) {
            e.printStackTrace();
            return Optional.empty();
        }
    }

    public static Optional<EncodingType> findEncodingType(String type) {
        for (EncodingType encodingType : EncodingType.getWriteableTypes()) {
            if (!encodingType.getName().equalsIgnoreCase(type)) continue;
            return Optional.of(encodingType);
        }
        return Optional.empty();
    }

    public static boolean startConversionRequest(UUID sessionID, UUID taskID, WorldConverter worldConverter, File inputPath, LevelWriter writer) {
        Optional<? extends LevelReader> reader = EncodingType.findReader(inputPath, worldConverter);
        if (reader.isEmpty()) {
            return false;
        }
        TrackedTask<Void> environment = worldConverter.convert(reader.get(), writer);
        TaskMonitorThread taskMonitorThread = new TaskMonitorThread(environment, progress -> Messenger.write(new ProgressResponse(taskID, progress)), exception -> {
            if (exception.isPresent()) {
                Throwable throwable = (Throwable)exception.get();
                if (throwable instanceof CompletionException) {
                    throwable = throwable.getCause();
                }
                if (throwable instanceof ExecutionError) {
                    throwable = throwable.getCause();
                }
                if (throwable instanceof CancellationException) {
                    Messenger.write(new ErrorResponse(taskID, true, "The process was cancelled", null, null, null));
                } else {
                    if (!(throwable instanceof LoggedException)) {
                        throwable.printStackTrace();
                    }
                    if (throwable instanceof OutOfMemoryError) {
                        System.exit(12);
                    } else {
                        Messenger.write(new ErrorResponse(taskID, false, Messenger.getFriendlyErrorMessage((Throwable)exception.get()), sessionID.toString(), ((Throwable)exception.get()).getMessage(), Messenger.printStackTrace((Throwable)exception.get())));
                    }
                }
            } else if (worldConverter.isCancelled()) {
                Messenger.write(new ErrorResponse(taskID, true, "The process was cancelled", null, null, null));
            } else {
                JsonObject output = new JsonObject();
                if (worldConverter.isExceptions()) {
                    output.addProperty("anonymousId", sessionID.toString());
                }
                JsonArray missingIdentifiers = new JsonArray(worldConverter.getMissingIdentifiers().size());
                for (Map.Entry<Converter.MissingMappingType, String> entry : worldConverter.getMissingIdentifiers().entries()) {
                    JsonObject missingIdentifier = new JsonObject();
                    missingIdentifier.addProperty("identifier", entry.getKey().getName() + ": " + entry.getValue());
                    missingIdentifier.addProperty("type", entry.getKey().toString());
                    missingIdentifier.addProperty("value", entry.getValue());
                    missingIdentifiers.add(missingIdentifier);
                }
                output.add("missingIdentifiers", missingIdentifiers);
                Messenger.write(new OutputResponse(taskID, output));
            }
            System.gc();
        });
        taskMonitorThread.start();
        return true;
    }

    public static JsonArray getWriters() {
        JsonArray writers = new JsonArray();
        for (EncodingType encodingType : EncodingType.getWriteableTypes()) {
            if (encodingType.isInternal()) continue;
            Collection<Version> versions = encodingType.getSupportedVersions();
            if (versions == null || versions.isEmpty()) {
                writers.add(Messenger.toEncodedObject(encodingType, null));
                continue;
            }
            for (Version version : versions) {
                writers.add(Messenger.toEncodedObject(encodingType, version));
            }
        }
        return writers;
    }

    public static JsonObject toEncodedObject(EncodingType encodingType, @Nullable Version version) {
        JsonObject encoding = new JsonObject();
        if (version != null) {
            encoding.addProperty("id", Messenger.toEncodedString(encodingType, version));
            encoding.addProperty("version", version.toString());
        } else {
            encoding.addProperty("id", encodingType.getName().toUpperCase(Locale.ROOT));
        }
        encoding.addProperty("type", encodingType.getName().toUpperCase(Locale.ROOT));
        return encoding;
    }

    public static String toEncodedString(EncodingType encodingType, Version version) {
        String encodedVersion = version.toString().replaceAll("\\.0$", "").replace('.', '_');
        if (encodingType == EncodingType.BEDROCK) {
            encodedVersion = encodedVersion.replaceAll("^1_", "R");
        }
        return encodingType.getName().toUpperCase(Locale.ROOT) + "_" + encodedVersion;
    }

    public static void write(BasicMessage message) {
        System.out.println(GSON.toJson(message));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static String printStackTrace(Throwable throwable) {
        try (StringWriter stringWriter = new StringWriter();){
            PrintWriter printWriter = new PrintWriter(stringWriter);
            try {
                throwable.printStackTrace(printWriter);
                String string = stringWriter.toString();
                printWriter.close();
                return string;
            }
            catch (Throwable throwable2) {
                try {
                    printWriter.close();
                }
                catch (Throwable throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String getFriendlyErrorMessage(Throwable throwable) {
        if (throwable instanceof CompletionException) {
            throwable = throwable.getCause();
        }
        if (throwable instanceof IllegalStateException && throwable.getMessage().equals("CURRENT file does not end with newline")) {
            return "The world is either encrypted or corrupted. Chunker is unable to read marketplace worlds as they are encrypted.";
        }
        return "A fatal error occurred during conversion.";
    }
}

