/*
 * Decompiled with CFR 0.152.
 */
package com.hivemc.chunker.cli;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import picocli.CommandLine;

public class JsonObjectOrFile {
    private final String json;

    public JsonObjectOrFile(Path path) throws IOException {
        this.json = Files.readString(path);
    }

    public JsonObjectOrFile(String json) {
        this.json = json;
    }

    public String getJSONObjectString() {
        return this.json;
    }

    public static class Converter
    implements CommandLine.ITypeConverter<JsonObjectOrFile> {
        @Override
        public JsonObjectOrFile convert(String s) {
            if (s.trim().startsWith("{")) {
                return new JsonObjectOrFile(s);
            }
            try {
                return new JsonObjectOrFile(Path.of(s, new String[0]));
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }
}

