/*
 * Decompiled with CFR 0.152.
 */
package com.minecraftserverzone.weaponmaster.setup.networking.client;

import com.minecraftserverzone.weaponmaster.setup.configs.ConfigHolder;
import com.minecraftserverzone.weaponmaster.setup.events_on_client.ClientOnlyForgeSetup;
import com.minecraftserverzone.weaponmaster.setup.playerdata.IPlayerData;
import com.minecraftserverzone.weaponmaster.setup.playerdata.PlayerData;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.network.CustomPayloadEvent;
import net.minecraftforge.fml.DistExecutor;

public class PositionsCPacket {
    private int[] value;
    private boolean setconfig;
    private UUID uuid;

    public PositionsCPacket(FriendlyByteBuf buf) {
        this.value = buf.m_130100_();
        this.setconfig = buf.readBoolean();
        this.uuid = buf.m_130259_();
    }

    public PositionsCPacket(int[] slotnum, boolean setConfigForClient, UUID uuid) {
        this.value = slotnum;
        this.setconfig = setConfigForClient;
        this.uuid = uuid;
    }

    public void toBytes(FriendlyByteBuf buf) {
        buf.m_130089_(this.value);
        buf.writeBoolean(this.setconfig);
        buf.m_130077_(this.uuid);
    }

    public void handle(CustomPayloadEvent.Context ctx) {
        ctx.enqueueWork(() -> DistExecutor.unsafeRunWhenOn((Dist)Dist.CLIENT, () -> () -> this.playerChanged()));
        ctx.setPacketHandled(true);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void playerChanged() {
        for (Player target : Minecraft.m_91087_().f_91073_.m_6907_()) {
            PlayerData data;
            if (!target.m_20148_().equals(this.uuid) || (data = ((IPlayerData)target).getPlayerData()) == null || this.value == null) continue;
            data.positions = this.value;
            if (target != Minecraft.m_91087_().f_91074_ || !this.setconfig) continue;
            for (int i = 0; i < data.positions.length; ++i) {
                try {
                    ConfigHolder.COMMON.positions[i].set((Object)data.positions[i]);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            ClientOnlyForgeSetup.slotPositions = data.positions;
        }
    }
}

