/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.forge.network;

import java.util.UUID;
import mezz.jei.common.network.IConnectionToServer;
import mezz.jei.common.network.packets.PacketJeiToServer;
import mezz.jei.forge.network.NetworkHandler;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.network.EventNetworkChannel;
import net.minecraftforge.network.ICustomPacket;
import net.minecraftforge.network.NetworkDirection;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public final class ConnectionToServer
implements IConnectionToServer {
    @Nullable
    private static UUID jeiOnServerCacheUuid = null;
    private static boolean jeiOnServerCacheValue = false;
    private final NetworkHandler networkHandler;

    public ConnectionToServer(NetworkHandler networkHandler) {
        this.networkHandler = networkHandler;
    }

    @Override
    public boolean isJeiOnServer() {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientPacketListener clientPacketListener = minecraft.m_91403_();
        if (clientPacketListener == null) {
            return false;
        }
        UUID id = clientPacketListener.m_105150_();
        if (!id.equals(jeiOnServerCacheUuid)) {
            jeiOnServerCacheUuid = id;
            Connection connection = clientPacketListener.m_104910_();
            EventNetworkChannel networkChannel = this.networkHandler.getChannel();
            jeiOnServerCacheValue = networkChannel.isRemotePresent(connection);
        }
        return jeiOnServerCacheValue;
    }

    @Override
    public void sendPacketToServer(PacketJeiToServer packet) {
        Minecraft minecraft = Minecraft.m_91087_();
        ClientPacketListener netHandler = minecraft.m_91403_();
        if (netHandler != null && this.isJeiOnServer()) {
            Pair<FriendlyByteBuf, Integer> packetData = packet.getPacketData();
            ICustomPacket payload = NetworkDirection.PLAY_TO_SERVER.buildPacket((FriendlyByteBuf)packetData.getKey(), this.networkHandler.getChannelId());
            netHandler.m_295327_(payload.getThis());
        }
    }
}

