/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.util;

import java.util.Collection;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.runtime.IIngredientManager;
import mezz.jei.common.platform.IPlatformRegistry;
import mezz.jei.common.platform.Services;
import net.minecraft.client.Minecraft;
import net.minecraft.core.NonNullList;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.Nullable;

public final class ErrorUtil {
    private ErrorUtil() {
    }

    public static <T> String getIngredientInfo(T ingredient, IIngredientType<T> ingredientType, IIngredientManager ingredientManager) {
        IIngredientHelper<T> ingredientHelper = ingredientManager.getIngredientHelper(ingredientType);
        return ingredientHelper.getErrorInfo(ingredient);
    }

    public static String getItemStackInfo(@Nullable ItemStack itemStack) {
        if (itemStack == null) {
            return "null";
        }
        Item item = itemStack.m_41720_();
        IPlatformRegistry<Item> itemRegistry = Services.PLATFORM.getRegistry(Registries.f_256913_);
        String itemName = itemRegistry.getRegistryName(item).map(ResourceLocation::toString).orElseGet(() -> {
            if (item instanceof BlockItem) {
                String blockName;
                Block block = ((BlockItem)item).m_40614_();
                if (block == null) {
                    blockName = "null";
                } else {
                    IPlatformRegistry<Block> blockRegistry = Services.PLATFORM.getRegistry(Registries.f_256747_);
                    blockName = blockRegistry.getRegistryName(block).map(ResourceLocation::toString).orElseGet(() -> block.getClass().getName());
                }
                return "BlockItem(" + blockName + ")";
            }
            return item.getClass().getName();
        });
        CompoundTag nbt = itemStack.m_41783_();
        if (nbt != null) {
            return itemStack + " " + itemName + " nbt:" + nbt;
        }
        return itemStack + " " + itemName;
    }

    public static void checkNotEmpty(ItemStack itemStack) {
        if (itemStack == null) {
            throw new NullPointerException("ItemStack must not be null.");
        }
        if (itemStack.m_41619_()) {
            String info = ErrorUtil.getItemStackInfo(itemStack);
            throw new IllegalArgumentException("ItemStack value must not be empty. " + info);
        }
    }

    public static void checkNotEmpty(ItemStack itemStack, String name) {
        if (itemStack == null) {
            throw new NullPointerException(name + " must not be null.");
        }
        if (itemStack.m_41619_()) {
            String info = ErrorUtil.getItemStackInfo(itemStack);
            throw new IllegalArgumentException("ItemStack " + name + " must not be empty. " + info);
        }
    }

    public static <T> void checkNotEmpty(T[] values, String name) {
        if (values == null) {
            throw new NullPointerException(name + " must not be null.");
        }
        if (values.length == 0) {
            throw new IllegalArgumentException(name + " must not be empty.");
        }
        for (T value : values) {
            if (value != null) continue;
            throw new NullPointerException(name + " must not contain null values.");
        }
    }

    public static void checkNotEmpty(Collection<?> values, String name) {
        if (values == null) {
            throw new NullPointerException(name + " must not be null.");
        }
        if (values.isEmpty()) {
            throw new IllegalArgumentException(name + " must not be empty.");
        }
        if (!(values instanceof NonNullList)) {
            for (Object value : values) {
                if (value != null) continue;
                throw new NullPointerException(name + " must not contain null values.");
            }
        }
    }

    public static <T> void checkNotNull(@Nullable T object, String name) {
        if (object == null) {
            throw new NullPointerException(name + " must not be null.");
        }
    }

    public static void checkNotNull(Collection<?> values, String name) {
        if (values == null) {
            throw new NullPointerException(name + " must not be null.");
        }
        if (!(values instanceof NonNullList)) {
            for (Object value : values) {
                if (value != null) continue;
                throw new NullPointerException(name + " must not contain null values.");
            }
        }
    }

    public static void assertMainThread() {
        Minecraft minecraft = Minecraft.m_91087_();
        if (minecraft != null && !minecraft.m_18695_()) {
            Thread currentThread = Thread.currentThread();
            throw new IllegalStateException("A JEI API method is being called by another mod from the wrong thread:\n" + currentThread + "\nIt must be called on the main thread by using Minecraft.addScheduledTask.");
        }
    }

    public static <T> void validateRecipes(RecipeType<T> recipeType, Iterable<? extends T> recipes) {
        Class<T> recipeClass = recipeType.getRecipeClass();
        for (T recipe : recipes) {
            if (recipeClass.isInstance(recipe)) continue;
            throw new IllegalArgumentException(recipeType.getUid() + " recipes must be an instance of " + recipeClass + ". Instead got: " + recipe.getClass());
        }
    }
}

