/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.network.packets;

import java.util.List;
import mezz.jei.common.network.PacketIdServer;
import mezz.jei.common.network.ServerPacketContext;
import mezz.jei.common.network.packets.PacketJeiToServer;
import mezz.jei.common.transfer.BasicRecipeTransferHandlerServer;
import mezz.jei.common.transfer.TransferOperation;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;

public class PacketRecipeTransfer
extends PacketJeiToServer {
    public final List<TransferOperation> transferOperations;
    public final List<Integer> craftingSlots;
    public final List<Integer> inventorySlots;
    private final boolean maxTransfer;
    private final boolean requireCompleteSets;

    public static PacketRecipeTransfer fromSlots(List<TransferOperation> transferOperations, List<Slot> craftingSlots, List<Slot> inventorySlots, boolean maxTransfer, boolean requireCompleteSets) {
        return new PacketRecipeTransfer(transferOperations, craftingSlots.stream().map(s -> s.f_40219_).toList(), inventorySlots.stream().map(s -> s.f_40219_).toList(), maxTransfer, requireCompleteSets);
    }

    public PacketRecipeTransfer(List<TransferOperation> transferOperations, List<Integer> craftingSlots, List<Integer> inventorySlots, boolean maxTransfer, boolean requireCompleteSets) {
        this.transferOperations = transferOperations;
        this.craftingSlots = craftingSlots;
        this.inventorySlots = inventorySlots;
        this.maxTransfer = maxTransfer;
        this.requireCompleteSets = requireCompleteSets;
    }

    @Override
    public PacketIdServer getPacketId() {
        return PacketIdServer.RECIPE_TRANSFER;
    }

    @Override
    public void writePacketData(FriendlyByteBuf buf) {
        buf.m_236828_(this.transferOperations, (b, op) -> op.writePacketData((FriendlyByteBuf)b));
        buf.m_236828_(this.craftingSlots, FriendlyByteBuf::m_130130_);
        buf.m_236828_(this.inventorySlots, FriendlyByteBuf::m_130130_);
        buf.writeBoolean(this.maxTransfer);
        buf.writeBoolean(this.requireCompleteSets);
    }

    @Override
    public void processOnServerThread(ServerPacketContext context) {
        AbstractContainerMenu container = context.player().f_36096_;
        BasicRecipeTransferHandlerServer.setItems((Player)context.player(), this.transferOperations, this.craftingSlots.stream().map(arg_0 -> ((AbstractContainerMenu)container).m_38853_(arg_0)).toList(), this.inventorySlots.stream().map(arg_0 -> ((AbstractContainerMenu)container).m_38853_(arg_0)).toList(), this.maxTransfer, this.requireCompleteSets);
    }

    public static PacketRecipeTransfer readPacketData(FriendlyByteBuf buf) {
        List transferOperations = buf.m_236845_(TransferOperation::readPacketData);
        List craftingSlots = buf.m_236845_(FriendlyByteBuf::m_130242_);
        List inventorySlots = buf.m_236845_(FriendlyByteBuf::m_130242_);
        boolean maxTransfer = buf.readBoolean();
        boolean requireCompleteSets = buf.readBoolean();
        return new PacketRecipeTransfer(transferOperations, craftingSlots, inventorySlots, maxTransfer, requireCompleteSets);
    }
}

