/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.network.packets;

import mezz.jei.common.config.IServerConfig;
import mezz.jei.common.network.IConnectionToClient;
import mezz.jei.common.network.PacketIdServer;
import mezz.jei.common.network.ServerPacketContext;
import mezz.jei.common.network.packets.PacketCheatPermission;
import mezz.jei.common.network.packets.PacketJeiToServer;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ServerCommandUtil;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PacketDeletePlayerItem
extends PacketJeiToServer {
    private static final Logger LOGGER = LogManager.getLogger();
    private final int itemID;

    public PacketDeletePlayerItem(Item item) {
        this(Services.PLATFORM.getRegistry(Registries.f_256913_).getId(item));
    }

    public PacketDeletePlayerItem(int itemID) {
        this.itemID = itemID;
    }

    @Override
    public PacketIdServer getPacketId() {
        return PacketIdServer.DELETE_ITEM;
    }

    @Override
    public void writePacketData(FriendlyByteBuf buf) {
        buf.m_130130_(this.itemID);
    }

    public static PacketDeletePlayerItem readPacketData(FriendlyByteBuf buf) {
        int itemId = buf.m_130242_();
        return new PacketDeletePlayerItem(itemId);
    }

    @Override
    public void processOnServerThread(ServerPacketContext context) {
        Item item = Services.PLATFORM.getRegistry(Registries.f_256913_).getValue(this.itemID).orElse(null);
        ServerPlayer player = context.player();
        if (item == null) {
            LOGGER.debug("Player '{} ({})' tried to delete Item ID '{}' but no item is registered with that ID.", (Object)player.m_7755_(), (Object)player.m_20148_(), (Object)this.itemID);
        } else {
            IServerConfig serverConfig = context.serverConfig();
            if (ServerCommandUtil.hasPermissionForCheatMode(player, serverConfig)) {
                ItemStack playerItem = player.f_36096_.m_142621_();
                if (playerItem.m_41720_() == item) {
                    player.f_36096_.m_142503_(ItemStack.f_41583_);
                } else if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Player '{} ({})' tried to delete Item '{}' but is currently holding a different ItemStack '{}'.", (Object)player.m_7755_(), (Object)player.m_20148_(), (Object)item, (Object)playerItem.m_41611_());
                }
            } else {
                if (LOGGER.isDebugEnabled()) {
                    ItemStack playerItem = player.f_36096_.m_142621_();
                    LOGGER.debug("Player '{} ({})' tried to delete ItemStack '{}' but does not have permission.", (Object)player.m_7755_(), (Object)player.m_20148_(), (Object)playerItem.m_41611_());
                }
                IConnectionToClient connection = context.connection();
                connection.sendPacketToClient(new PacketCheatPermission(false), player);
            }
        }
    }
}

