/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.network;

import java.util.EnumMap;
import java.util.Optional;
import mezz.jei.common.config.IServerConfig;
import mezz.jei.common.network.ClientPacketContext;
import mezz.jei.common.network.IConnectionToServer;
import mezz.jei.common.network.PacketIdClient;
import mezz.jei.common.network.packets.IClientPacketHandler;
import mezz.jei.common.network.packets.PacketCheatPermission;
import mezz.jei.common.network.packets.PacketJeiToClient;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.FriendlyByteBuf;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ClientPacketRouter {
    private static final Logger LOGGER = LogManager.getLogger();
    public final EnumMap<PacketIdClient, IClientPacketHandler> clientHandlers = new EnumMap(PacketIdClient.class);
    private final IConnectionToServer connection;
    private final IServerConfig serverConfig;

    public ClientPacketRouter(IConnectionToServer connection, IServerConfig serverConfig) {
        this.connection = connection;
        this.serverConfig = serverConfig;
        this.clientHandlers.put(PacketIdClient.CHEAT_PERMISSION, PacketCheatPermission::readPacketData);
    }

    public void onPacket(FriendlyByteBuf packetBuffer, LocalPlayer player) {
        this.getPacketId(packetBuffer).ifPresent(packetId -> {
            IClientPacketHandler packetHandler = this.clientHandlers.get(packetId);
            ClientPacketContext context = new ClientPacketContext(player, this.connection, this.serverConfig);
            try {
                PacketJeiToClient packet = packetHandler.readPacketData(packetBuffer);
                if (packet != null) {
                    Minecraft.m_91087_().m_18707_(() -> packet.processOnClientThread(context)).exceptionally(e -> {
                        LOGGER.error("Packet error while executing packet on the client thread: {}", (Object)packetId.name(), e);
                        return null;
                    });
                }
            }
            catch (Throwable e2) {
                LOGGER.error("Packet error when reading packet: {}", (Object)packetId.name(), (Object)e2);
            }
        });
    }

    private Optional<PacketIdClient> getPacketId(FriendlyByteBuf packetBuffer) {
        try {
            byte packetIdOrdinal = packetBuffer.readByte();
            PacketIdClient packetId = PacketIdClient.VALUES[packetIdOrdinal];
            return Optional.of(packetId);
        }
        catch (RuntimeException e) {
            LOGGER.error("Packet error when trying to read packet id", (Throwable)e);
            return Optional.empty();
        }
    }
}

