/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.gui.widget;

import java.util.List;
import me.shedaniel.clothconfig2.gui.widget.DynamicEntryListWidget;
import me.shedaniel.clothconfig2.gui.widget.DynamicSmoothScrollingEntryListWidget;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.components.events.ContainerEventHandler;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarratedElementType;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.navigation.ScreenAxis;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public abstract class DynamicElementListWidget<E extends ElementEntry<E>>
extends DynamicSmoothScrollingEntryListWidget<E> {
    private static final Component USAGE_NARRATION = Component.m_237115_((String)"narration.selection.usage");

    public DynamicElementListWidget(Minecraft client, int width, int height, int top, int bottom, ResourceLocation backgroundLocation) {
        super(client, width, height, top, bottom, backgroundLocation);
    }

    @Nullable
    public ComponentPath m_264064_(FocusNavigationEvent focusNavigationEvent) {
        ComponentPath componentPath;
        if (this.getItemCount() == 0) {
            return null;
        }
        if (!(focusNavigationEvent instanceof FocusNavigationEvent.ArrowNavigation)) {
            return super.m_264064_(focusNavigationEvent);
        }
        FocusNavigationEvent.ArrowNavigation arrowNavigation = (FocusNavigationEvent.ArrowNavigation)focusNavigationEvent;
        ElementEntry entry = (ElementEntry)this.getFocused();
        if (arrowNavigation.f_263812_().m_264093_() == ScreenAxis.HORIZONTAL && entry != null) {
            return ComponentPath.m_264334_((ContainerEventHandler)this, (ComponentPath)entry.m_264064_(focusNavigationEvent));
        }
        int i = -1;
        ScreenDirection screenDirection = arrowNavigation.f_263812_();
        if (entry != null) {
            i = entry.m_6702_().indexOf(entry.m_7222_());
        }
        if (i == -1) {
            switch (screenDirection) {
                case LEFT: {
                    i = Integer.MAX_VALUE;
                    screenDirection = ScreenDirection.DOWN;
                    break;
                }
                case RIGHT: {
                    i = 0;
                    screenDirection = ScreenDirection.DOWN;
                    break;
                }
                default: {
                    i = 0;
                }
            }
        }
        ElementEntry entry2 = entry;
        do {
            if ((entry2 = this.nextEntry(screenDirection, entryx -> !entryx.m_6702_().isEmpty(), entry2)) != null) continue;
            return null;
        } while ((componentPath = entry2.focusPathAtIndex((FocusNavigationEvent)arrowNavigation, i)) == null);
        return ComponentPath.m_264334_((ContainerEventHandler)this, (ComponentPath)componentPath);
    }

    @Override
    public void m_142291_(NarrationElementOutput narrationElementOutput) {
        ElementEntry entry = (ElementEntry)this.hoveredItem;
        if (entry != null) {
            entry.m_142291_(narrationElementOutput.m_142047_());
            this.narrateListElementPosition(narrationElementOutput, entry);
        } else {
            ElementEntry entry2 = (ElementEntry)this.getFocused();
            if (entry2 != null) {
                entry2.m_142291_(narrationElementOutput.m_142047_());
                this.narrateListElementPosition(narrationElementOutput, entry2);
            }
        }
        narrationElementOutput.m_169146_(NarratedElementType.USAGE, (Component)Component.m_237115_((String)"narration.component_list.usage"));
    }

    @Override
    public void m_7522_(@Nullable GuiEventListener guiEventListener) {
        super.m_7522_(guiEventListener);
        if (guiEventListener == null) {
            this.selectItem(null);
        }
    }

    @Override
    public NarratableEntry.NarrationPriority m_142684_() {
        return this.m_93696_() ? NarratableEntry.NarrationPriority.FOCUSED : super.m_142684_();
    }

    @Override
    protected boolean isSelected(int i) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static abstract class ElementEntry<E extends ElementEntry<E>>
    extends DynamicEntryListWidget.Entry<E>
    implements ContainerEventHandler,
    NarratableEntry {
        @Nullable
        private GuiEventListener focused;
        @Nullable
        private NarratableEntry lastNarratable;
        private boolean dragging;

        public boolean m_7282_() {
            return this.dragging;
        }

        public void m_7897_(boolean bl) {
            this.dragging = bl;
        }

        @Nullable
        public GuiEventListener m_7222_() {
            return this.focused;
        }

        public void m_7522_(@Nullable GuiEventListener guiEventListener) {
            if (this.focused != null) {
                this.focused.m_93692_(false);
            }
            if (guiEventListener != null) {
                guiEventListener.m_93692_(true);
            }
            this.focused = guiEventListener;
        }

        @Nullable
        public ComponentPath focusPathAtIndex(FocusNavigationEvent focusNavigationEvent, int i) {
            if (this.m_6702_().isEmpty()) {
                return null;
            }
            ComponentPath componentPath = ((GuiEventListener)this.m_6702_().get(Math.min(i, this.m_6702_().size() - 1))).m_264064_(focusNavigationEvent);
            return ComponentPath.m_264334_((ContainerEventHandler)this, (ComponentPath)componentPath);
        }

        @Nullable
        public ComponentPath m_264064_(FocusNavigationEvent focusNavigationEvent) {
            if (focusNavigationEvent instanceof FocusNavigationEvent.ArrowNavigation) {
                int j;
                int var10000;
                FocusNavigationEvent.ArrowNavigation arrowNavigation = (FocusNavigationEvent.ArrowNavigation)focusNavigationEvent;
                switch (arrowNavigation.f_263812_()) {
                    default: {
                        throw new IncompatibleClassChangeError();
                    }
                    case LEFT: {
                        int n = -1;
                        break;
                    }
                    case RIGHT: {
                        int n = 1;
                        break;
                    }
                    case UP: 
                    case DOWN: {
                        int n = var10000 = 0;
                    }
                }
                if (var10000 == 0) {
                    return null;
                }
                for (int k = j = Mth.m_14045_((int)(var10000 + this.m_6702_().indexOf(this.m_7222_())), (int)0, (int)(this.m_6702_().size() - 1)); k >= 0 && k < this.m_6702_().size(); k += var10000) {
                    GuiEventListener guiEventListener = (GuiEventListener)this.m_6702_().get(k);
                    ComponentPath componentPath = guiEventListener.m_264064_(focusNavigationEvent);
                    if (componentPath == null) continue;
                    return ComponentPath.m_264334_((ContainerEventHandler)this, (ComponentPath)componentPath);
                }
            }
            return super.m_264064_(focusNavigationEvent);
        }

        @Override
        public abstract List<? extends NarratableEntry> narratables();

        @Override
        public void m_142291_(NarrationElementOutput narrationElementOutput) {
            List<NarratableEntry> list = this.narratables();
            Screen.NarratableSearchResult narratableSearchResult = Screen.m_169400_(list, (NarratableEntry)this.lastNarratable);
            if (narratableSearchResult != null) {
                if (narratableSearchResult.f_169422_.m_169123_()) {
                    this.lastNarratable = narratableSearchResult.f_169420_;
                }
                if (list.size() > 1) {
                    narrationElementOutput.m_169146_(NarratedElementType.POSITION, (Component)Component.m_237110_((String)"narrator.position.object_list", (Object[])new Object[]{narratableSearchResult.f_169421_ + 1, list.size()}));
                    if (narratableSearchResult.f_169422_ == NarratableEntry.NarrationPriority.FOCUSED) {
                        narrationElementOutput.m_169146_(NarratedElementType.USAGE, (Component)Component.m_237115_((String)"narration.component_list.usage"));
                    }
                }
                narratableSearchResult.f_169420_.m_142291_(narrationElementOutput.m_142047_());
            }
        }

        public boolean m_142518_() {
            return false;
        }

        public NarratableEntry.NarrationPriority m_142684_() {
            if (this.m_93696_()) {
                return NarratableEntry.NarrationPriority.FOCUSED;
            }
            return NarratableEntry.NarrationPriority.NONE;
        }

        public boolean m_6375_(double d, double e, int i) {
            if (!this.isEnabled()) {
                return false;
            }
            return super.m_6375_(d, e, i);
        }

        public boolean m_6348_(double d, double e, int i) {
            if (!this.isEnabled()) {
                return false;
            }
            return super.m_6348_(d, e, i);
        }

        public boolean m_7979_(double d, double e, int i, double f, double g) {
            if (!this.isEnabled()) {
                return false;
            }
            return super.m_7979_(d, e, i, f, g);
        }

        public boolean m_6050_(double d, double e, double amountX, double amountY) {
            if (!this.isEnabled()) {
                return false;
            }
            return super.m_6050_(d, e, amountX, amountY);
        }

        public boolean m_7933_(int i, int j, int k) {
            if (!this.isEnabled()) {
                return false;
            }
            return super.m_7933_(i, j, k);
        }

        public boolean m_7920_(int i, int j, int k) {
            if (!this.isEnabled()) {
                return false;
            }
            return super.m_7920_(i, j, k);
        }

        public boolean m_5534_(char c, int i) {
            if (!this.isEnabled()) {
                return false;
            }
            return super.m_5534_(c, i);
        }
    }
}

