/*
 * Decompiled with CFR 0.152.
 */
package fuzs.universalbonemeal.world.level.block.behavior;

import fuzs.universalbonemeal.world.level.block.behavior.BonemealBehavior;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;

public abstract class GrowingPlantBehavior
implements BonemealBehavior {
    protected final Direction growthDirection;

    public GrowingPlantBehavior(Direction growthDirection) {
        this.growthDirection = growthDirection;
    }

    public boolean m_7370_(LevelReader p_53900_, BlockPos p_53901_, BlockState p_53902_) {
        BlockPos headPos = this.getHeadPos((BlockGetter)p_53900_, p_53901_, p_53902_.m_60734_());
        return this.canGrowInto(p_53900_.m_8055_(headPos.m_121945_(this.growthDirection)));
    }

    public boolean m_214167_(Level p_53944_, RandomSource p_53945_, BlockPos p_53946_, BlockState p_53947_) {
        return true;
    }

    public void m_214148_(ServerLevel level, RandomSource random, BlockPos sourcePos, BlockState sourceState) {
        BlockPos topPos = this.getHeadPos((BlockGetter)level, sourcePos, sourceState.m_60734_());
        this.performBonemealTop(level, random, topPos, sourceState);
    }

    private void performBonemealTop(ServerLevel level, RandomSource p_53935_, BlockPos topPos, BlockState sourceState) {
        BlockPos blockpos = topPos.m_121945_(this.growthDirection);
        int j = this.getBlocksToGrowWhenBonemealed(p_53935_);
        for (int k = 0; k < j && this.canGrowInto(level.m_8055_(blockpos)); ++k) {
            level.m_46597_(blockpos, this.getGrownBlockState(sourceState.m_60734_(), sourceState));
            blockpos = blockpos.m_121945_(this.growthDirection);
        }
    }

    private BlockPos getHeadPos(BlockGetter p_153323_, BlockPos p_153324_, Block p_153325_) {
        return GrowingPlantBehavior.getTopConnectedBlock(p_153323_, p_153324_, p_153325_, this.growthDirection);
    }

    public static BlockPos getTopConnectedBlock(BlockGetter level, BlockPos pos, Block block, Direction direction) {
        BlockState blockstate;
        BlockPos.MutableBlockPos mutable = pos.m_122032_();
        do {
            mutable.m_122173_(direction);
        } while ((blockstate = level.m_8055_((BlockPos)mutable)).m_60713_(block));
        return mutable.m_122173_(direction.m_122424_());
    }

    protected abstract int getBlocksToGrowWhenBonemealed(RandomSource var1);

    protected abstract boolean canGrowInto(BlockState var1);

    protected abstract BlockState getGrownBlockState(Block var1, BlockState var2);
}

