/*
 * Decompiled with CFR 0.152.
 */
package fuzs.universalbonemeal;

import fuzs.puzzleslib.api.config.v3.ConfigHolder;
import fuzs.puzzleslib.api.core.v1.ModConstructor;
import fuzs.puzzleslib.api.event.v1.entity.player.BonemealCallback;
import fuzs.puzzleslib.api.event.v1.server.TagsUpdatedCallback;
import fuzs.universalbonemeal.config.ServerConfig;
import fuzs.universalbonemeal.handler.BonemealHandler;
import fuzs.universalbonemeal.init.ModRegistry;
import fuzs.universalbonemeal.world.level.block.behavior.ChorusFlowerBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.ChorusPlantBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.CoralBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.DirtBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.FruitStemBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.MyceliumBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.NetherWartBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.PodzolBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.PopResourceBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.SimpleGrowingPlantBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.SimpleSpreadBehavior;
import fuzs.universalbonemeal.world.level.block.behavior.VineBehavior;
import java.util.Set;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UniversalBoneMeal
implements ModConstructor {
    public static final String MOD_ID = "universalbonemeal";
    public static final String MOD_NAME = "Universal Bone Meal";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Universal Bone Meal");
    public static final ConfigHolder CONFIG = ConfigHolder.builder((String)"universalbonemeal").server(ServerConfig.class);

    public void onConstructMod() {
        ModRegistry.touch();
        UniversalBoneMeal.registerHandlers();
    }

    private static void registerHandlers() {
        BonemealCallback.EVENT.register(BonemealHandler::onBonemeal);
        TagsUpdatedCallback.EVENT.register((registryAccess, client) -> {
            if (client) {
                return;
            }
            BonemealHandler.invalidate();
            CoralBehavior.invalidate();
        });
    }

    public void onCommonSetup() {
        UniversalBoneMeal.registerBonemealBehaviors();
    }

    private static void registerBonemealBehaviors() {
        BonemealHandler.registerBehavior(Blocks.f_50128_, SimpleGrowingPlantBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowCactus);
        BonemealHandler.registerBehavior(Blocks.f_50130_, SimpleGrowingPlantBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowSugarCane);
        BonemealHandler.registerBehavior(Blocks.f_50191_, VineBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowVines);
        BonemealHandler.registerBehavior(Blocks.f_50200_, NetherWartBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowNetherWart);
        BonemealHandler.registerBehavior(Set.of(Blocks.f_50190_, Blocks.f_50189_), FruitStemBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowFruitStems);
        BonemealHandler.registerBehavior(Blocks.f_50196_, () -> new SimpleSpreadBehavior(4, 3), () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowLilyPad);
        BonemealHandler.registerBehavior(Blocks.f_50036_, () -> new SimpleSpreadBehavior(4, 2), () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowDeadBush);
        BonemealHandler.registerBehavior((TagKey<Block>)BlockTags.f_13041_, ModRegistry.FERTILIZER_RESISTANT_FLOWER_BLOCK_TAG, () -> new SimpleSpreadBehavior(3, 1), () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowSmallFlowers);
        BonemealHandler.registerBehavior((TagKey<Block>)BlockTags.f_13063_, CoralBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowCorals);
        BonemealHandler.registerBehavior(Blocks.f_50491_, ChorusFlowerBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowChorus);
        BonemealHandler.registerBehavior(Blocks.f_50490_, ChorusPlantBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowChorus);
        BonemealHandler.registerBehavior(Blocks.f_50195_, MyceliumBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowMycelium);
        BonemealHandler.registerBehavior(Set.of(Blocks.f_50493_, Blocks.f_50546_, Blocks.f_152481_), DirtBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowDirt);
        BonemealHandler.registerBehavior(Blocks.f_50599_, PodzolBehavior::new, () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowPodzol);
        BonemealHandler.registerBehavior(Blocks.f_152540_, () -> new PopResourceBehavior(Direction.DOWN), () -> ((ServerConfig)UniversalBoneMeal.CONFIG.get(ServerConfig.class)).allowSporeBlossom);
    }

    public static ResourceLocation id(String path) {
        return new ResourceLocation(MOD_ID, path);
    }
}

