/*
 * Decompiled with CFR 0.152.
 */
package me.cominixo.betterf3.utils;

import com.google.common.base.Strings;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.ArrayList;
import java.util.List;
import me.cominixo.betterf3.config.GeneralOptions;
import me.cominixo.betterf3.modules.BaseModule;
import me.cominixo.betterf3.modules.MiscLeftModule;
import me.cominixo.betterf3.modules.MiscRightModule;
import me.cominixo.betterf3.utils.PositionEnum;
import me.cominixo.betterf3.utils.Utils;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.network.chat.Component;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public final class DebugRenderer {
    private DebugRenderer() {
    }

    public static MultiBufferSource.BufferSource immediate(Minecraft minecraft, Font font, PositionEnum pos, List<Component> list, PoseStack matrixStack) {
        float f = (float)(GeneralOptions.backgroundColor >> 24 & 0xFF) / 255.0f;
        float g = (float)(GeneralOptions.backgroundColor >> 16 & 0xFF) / 255.0f;
        float h = (float)(GeneralOptions.backgroundColor >> 8 & 0xFF) / 255.0f;
        float k = (float)(GeneralOptions.backgroundColor & 0xFF) / 255.0f;
        RenderSystem.setShader(GameRenderer::m_172811_);
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85815_);
        for (int i = 0; i < list.size(); ++i) {
            int j;
            int x2;
            int x1;
            int height = 9;
            int width = font.m_92895_(list.get(i).getString());
            if (width == 0) continue;
            int y = 2 + 9 * i;
            if (pos == PositionEnum.RIGHT) {
                windowWidth = (int)((double)minecraft.m_91268_().m_85445_() / GeneralOptions.fontScale) - 2 - width;
                if (GeneralOptions.enableAnimations) {
                    windowWidth += Utils.xPos;
                }
                x1 = windowWidth - 1;
                x2 = windowWidth + width + 1;
            } else {
                windowWidth = 2;
                if (GeneralOptions.enableAnimations) {
                    windowWidth -= Utils.xPos;
                }
                x1 = windowWidth - 1;
                x2 = width + 1 + windowWidth;
            }
            int y1 = y - 1;
            int y2 = y + 9 - 1;
            Matrix4f matrix = matrixStack.m_85850_().m_252922_();
            if (x1 < x2) {
                j = x1;
                x1 = x2;
                x2 = j;
            }
            if (y1 < y2) {
                j = y1;
                y1 = y2;
                y2 = j;
            }
            bufferBuilder.m_252986_(matrix, (float)x1, (float)y2, 0.0f).m_85950_(g, h, k, f).m_5752_();
            bufferBuilder.m_252986_(matrix, (float)x2, (float)y2, 0.0f).m_85950_(g, h, k, f).m_5752_();
            bufferBuilder.m_252986_(matrix, (float)x2, (float)y1, 0.0f).m_85950_(g, h, k, f).m_5752_();
            bufferBuilder.m_252986_(matrix, (float)x1, (float)y1, 0.0f).m_85950_(g, h, k, f).m_5752_();
        }
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
        RenderSystem.disableBlend();
        return MultiBufferSource.m_109898_((BufferBuilder)Tesselator.m_85913_().m_85915_());
    }

    public static void drawRightText(List<Component> list, GuiGraphics context, Minecraft minecraft, Font font, @Nullable List<String> additional) {
        if (additional != null) {
            additional.forEach(text -> list.add(Component.m_130674_((String)text)));
        }
        MultiBufferSource.BufferSource immediate = DebugRenderer.immediate(minecraft, font, PositionEnum.RIGHT, list, context.m_280168_());
        for (int i = 0; i < list.size(); ++i) {
            if (Strings.isNullOrEmpty((String)list.get(i).getString())) continue;
            int height = 9;
            int width = font.m_92895_(list.get(i).getString());
            int windowWidth = (int)((double)minecraft.m_91268_().m_85445_() / GeneralOptions.fontScale) - 2 - width;
            if (GeneralOptions.enableAnimations) {
                windowWidth += Utils.xPos;
            }
            int y = 2 + 9 * i;
            font.m_272077_(list.get(i), (float)windowWidth, (float)y, 0xE0E0E0, GeneralOptions.shadowText, context.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)immediate, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        }
        immediate.m_109911_();
        context.m_280168_().m_85849_();
    }

    public static void drawLeftText(List<Component> list, GuiGraphics context, Minecraft minecraft, Font font, @Nullable List<String> additional) {
        if (additional != null) {
            additional.forEach(text -> list.add(Component.m_130674_((String)text)));
        }
        MultiBufferSource.BufferSource immediate = DebugRenderer.immediate(minecraft, font, PositionEnum.LEFT, list, context.m_280168_());
        for (int i = 0; i < list.size(); ++i) {
            if (Strings.isNullOrEmpty((String)list.get(i).getString())) continue;
            int height = 9;
            int y = 2 + 9 * i;
            int xPosLeft = 2;
            if (GeneralOptions.enableAnimations) {
                xPosLeft -= Utils.xPos;
            }
            font.m_272077_(list.get(i), (float)xPosLeft, (float)y, 0xE0E0E0, GeneralOptions.shadowText, context.m_280168_().m_85850_().m_252922_(), (MultiBufferSource)immediate, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        }
        immediate.m_109911_();
    }

    public static List<Component> newText(Minecraft minecraft, boolean left, List<String> gameInformation, List<String> systemInformation) {
        ArrayList<Component> list = new ArrayList<Component>();
        for (BaseModule module : left ? BaseModule.modules : BaseModule.modulesRight) {
            if (!module.enabled) continue;
            if (module instanceof MiscRightModule) {
                ((MiscRightModule)module).update(systemInformation);
            } else if (module instanceof MiscLeftModule) {
                ((MiscLeftModule)module).update(gameInformation);
            } else {
                module.update(minecraft);
            }
            list.addAll(module.linesFormatted(minecraft.m_91299_()));
            if (!GeneralOptions.spaceEveryModule) continue;
            list.add(Component.m_130674_((String)""));
        }
        return list;
    }
}

