/*
 * Decompiled with CFR 0.152.
 */
package me.cominixo.betterf3.modules;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.Objects;
import me.cominixo.betterf3.modules.BaseModule;
import me.cominixo.betterf3.utils.DebugLine;
import me.cominixo.betterf3.utils.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextColor;

public class ServerModule
extends BaseModule {
    public ServerModule() {
        this.defaultNameColor = TextColor.m_131270_((ChatFormatting)ChatFormatting.GRAY);
        this.defaultValueColor = TextColor.m_131270_((ChatFormatting)ChatFormatting.YELLOW);
        this.nameColor = this.defaultNameColor;
        this.valueColor = this.defaultValueColor;
        this.lines.add(new DebugLine("server_tick", "format.betterf3.server_tick", true));
        this.lines.add(new DebugLine("packets_sent"));
        this.lines.add(new DebugLine("packets_received"));
        for (DebugLine line : this.lines) {
            line.inReducedDebug = true;
        }
    }

    @Override
    public void update(Minecraft client) {
        IntegratedServer integratedServer = client.m_91092_();
        String serverString = "";
        if (integratedServer != null) {
            serverString = I18n.m_118938_((String)"text.betterf3.line.integrated_server", (Object[])new Object[0]);
        } else if (client.f_91074_ != null) {
            serverString = Objects.requireNonNull(client.m_91403_()).m_295034_();
        }
        if (client.m_91403_() != null) {
            Connection clientConnection = client.m_91403_().m_104910_();
            float packetsSent = clientConnection.m_129543_();
            float packetsReceived = clientConnection.m_129542_();
            ((DebugLine)this.lines.get(1)).value(Math.round(packetsSent));
            ((DebugLine)this.lines.get(2)).value(Math.round(packetsReceived));
        }
        String tickString = "";
        if (integratedServer != null) {
            tickString = Integer.toString(Math.round(integratedServer.m_304767_()));
        }
        LinkedList<MutableComponent> serverStringList = new LinkedList<MutableComponent>(Arrays.asList(Utils.styledText(serverString, this.nameColor), Utils.styledText(tickString, this.nameColor)));
        if (tickString.isEmpty()) {
            ((DebugLine)this.lines.get(0)).format("format.betterf3.no_format");
            serverStringList.remove(1);
        }
        ((DebugLine)this.lines.get(0)).value(serverStringList);
    }
}

