/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.oregrowth.content;

import com.supermartijn642.oregrowth.OreGrowth;
import com.supermartijn642.oregrowth.content.OreGrowthRecipe;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.block.Block;

public class OreGrowthRecipeManager {
    private static RecipeManager recipeManager;
    private static boolean reload;
    private static Map<Block, OreGrowthRecipe> recipesByBlock;

    public static synchronized void reloadRecipes(RecipeManager recipeManager) {
        OreGrowthRecipeManager.recipeManager = recipeManager;
        reload = true;
        recipesByBlock = Collections.emptyMap();
    }

    public static OreGrowthRecipe getRecipeFor(Block block) {
        OreGrowthRecipeManager.cacheRecipes();
        return recipesByBlock.get(block);
    }

    public static List<OreGrowthRecipe> getAllRecipes() {
        OreGrowthRecipeManager.cacheRecipes();
        return Arrays.asList((OreGrowthRecipe[])recipesByBlock.values().toArray(OreGrowthRecipe[]::new));
    }

    private static synchronized void cacheRecipes() {
        if (reload && recipeManager != null) {
            recipesByBlock = OreGrowthRecipeManager.recipeManager.f_44007_.getOrDefault(OreGrowth.ORE_GROWTH_RECIPE_TYPE, Collections.emptyMap()).values().stream().map(RecipeHolder::f_291008_).map(OreGrowthRecipe.class::cast).collect(Collectors.toUnmodifiableMap(OreGrowthRecipe::base, Function.identity(), (recipe, recipe2) -> recipe));
            reload = false;
        }
    }

    static {
        reload = true;
        recipesByBlock = Collections.emptyMap();
    }
}

