/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.oregrowth.content;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.supermartijn642.core.registry.Registries;
import com.supermartijn642.oregrowth.OreGrowth;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;

public class OreGrowthRecipe
implements Recipe<Container> {
    public static final Serializer SERIALIZER = new Serializer();
    private final Block base;
    private final int stages;
    private final double spawnChance;
    private final double growthChance;
    private final ItemStack output;

    public OreGrowthRecipe(Block base, int stages, double spawnChance, double growthChance, ItemStack output) {
        this.base = base;
        this.stages = stages;
        this.spawnChance = spawnChance;
        this.growthChance = growthChance;
        this.output = output;
    }

    public Block base() {
        return this.base;
    }

    public int stages() {
        return this.stages;
    }

    public double spawnChance() {
        return this.spawnChance;
    }

    public double growthChance() {
        return this.growthChance;
    }

    public ItemStack output() {
        return this.output.m_41777_();
    }

    public boolean m_5818_(Container container, Level level) {
        return false;
    }

    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public boolean m_8004_(int width, int height) {
        return false;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public RecipeSerializer<?> m_7707_() {
        return SERIALIZER;
    }

    public RecipeType<?> m_6671_() {
        return OreGrowth.ORE_GROWTH_RECIPE_TYPE;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("type", "oregrowth:ore_growth");
        json.addProperty("base", Registries.BLOCKS.getIdentifier((Object)this.base).toString());
        json.addProperty("stages", (Number)this.stages);
        json.addProperty("spawn_chance", (Number)this.spawnChance);
        json.addProperty("growth_chance", (Number)this.growthChance);
        JsonObject itemJson = new JsonObject();
        itemJson.addProperty("item", Registries.ITEMS.getIdentifier((Object)this.output.m_41720_()).toString());
        itemJson.addProperty("count", (Number)this.output.m_41613_());
        json.add("result", (JsonElement)itemJson);
        return json;
    }

    private static class Serializer
    implements RecipeSerializer<OreGrowthRecipe> {
        private Serializer() {
        }

        public Codec<OreGrowthRecipe> m_292673_() {
            return RecordCodecBuilder.create(instance -> instance.group((App)ExtraCodecs.m_264370_((Codec)Registries.BLOCKS.getVanillaRegistry().m_194605_(), block -> block == Blocks.f_50016_ ? DataResult.error(() -> "Unknown base block!") : DataResult.success((Object)block)).fieldOf("base").forGetter(OreGrowthRecipe::base), (App)Codec.intRange((int)1, (int)4).fieldOf("stages").forGetter(OreGrowthRecipe::stages), (App)Codec.doubleRange((double)0.0, (double)1.0).fieldOf("spawn_chance").forGetter(OreGrowthRecipe::spawnChance), (App)Codec.doubleRange((double)0.0, (double)1.0).fieldOf("growth_chance").forGetter(OreGrowthRecipe::growthChance), (App)ItemStack.f_302323_.fieldOf("result").forGetter(OreGrowthRecipe::output)).apply((Applicative)instance, OreGrowthRecipe::new));
        }

        public OreGrowthRecipe fromNetwork(FriendlyByteBuf buffer) {
            ResourceLocation blockIdentifier = buffer.m_130281_();
            if (!Registries.BLOCKS.hasIdentifier(blockIdentifier)) {
                throw new IllegalArgumentException("Unknown block '" + blockIdentifier + "'!");
            }
            Block base = (Block)Registries.BLOCKS.getValue(blockIdentifier);
            if (base == Blocks.f_50016_ || base == Blocks.f_50627_ || base == Blocks.f_50626_) {
                throw new IllegalArgumentException("Got AIR block for identifier '" + blockIdentifier + "'!");
            }
            int stages = buffer.readInt();
            if (stages < 1 || stages > 4) {
                throw new IllegalArgumentException("Invalid number of stages: '" + stages + "'!");
            }
            double spawnChance = buffer.readDouble();
            if (spawnChance <= 0.0 || spawnChance > 1.0) {
                throw new IllegalArgumentException("Invalid spawn chance: '" + spawnChance + "'!");
            }
            double growthChance = buffer.readDouble();
            if (growthChance <= 0.0 || growthChance > 1.0) {
                throw new IllegalArgumentException("Invalid growth chance: '" + growthChance + "'!");
            }
            ItemStack output = buffer.m_130267_();
            if (output.m_41619_()) {
                throw new IllegalArgumentException("Invalid output '" + output + "'!");
            }
            return new OreGrowthRecipe(base, stages, spawnChance, growthChance, output);
        }

        public void toNetwork(FriendlyByteBuf buffer, OreGrowthRecipe recipe) {
            buffer.m_130085_(Registries.BLOCKS.getIdentifier((Object)recipe.base));
            buffer.writeInt(recipe.stages);
            buffer.writeDouble(recipe.spawnChance);
            buffer.writeDouble(recipe.growthChance);
            buffer.m_130055_(recipe.output);
        }
    }
}

