/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.oregrowth.content;

import com.supermartijn642.core.block.BaseBlock;
import com.supermartijn642.core.block.BlockProperties;
import com.supermartijn642.core.block.BlockShape;
import com.supermartijn642.oregrowth.OreGrowth;
import com.supermartijn642.oregrowth.OreGrowthConfig;
import com.supermartijn642.oregrowth.content.OreGrowthRecipe;
import com.supermartijn642.oregrowth.content.OreGrowthRecipeManager;
import java.util.Collections;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class OreGrowthBlock
extends BaseBlock
implements SimpleWaterloggedBlock {
    public static final int MAX_STAGES = 4;
    public static IntegerProperty STAGE = IntegerProperty.m_61631_((String)"stage", (int)1, (int)4);
    public static EnumProperty<Direction> FACE = BlockStateProperties.f_61372_;
    public static BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    private static final BlockShape[] SHAPES = new BlockShape[]{BlockShape.createBlockShape((double)6.5, (double)0.0, (double)6.5, (double)9.5, (double)5.0, (double)9.5), BlockShape.createBlockShape((double)5.8, (double)0.0, (double)5.8, (double)10.2, (double)7.0, (double)10.2), BlockShape.createBlockShape((double)5.2, (double)0.0, (double)5.2, (double)10.8, (double)9.0, (double)10.8), BlockShape.createBlockShape((double)5.1, (double)0.0, (double)5.1, (double)10.9, (double)11.0, (double)10.9)};
    private static final BlockShape[] SHAPES_ROTATED = new BlockShape[SHAPES.length * 6];

    public static void trySpawnOreGrowth(OreGrowthRecipe recipe, ServerLevel level, BlockPos pos, RandomSource random) {
        if ((double)random.m_188501_() > recipe.spawnChance() * OreGrowthConfig.spawnChanceScalar.get()) {
            return;
        }
        Direction side = Direction.values()[random.m_188503_(Direction.values().length)];
        BlockPos growthPos = pos.m_121945_(side);
        BlockState currentState = level.m_8055_(growthPos);
        if (!currentState.m_60795_() && !currentState.m_60713_(Blocks.f_49990_)) {
            return;
        }
        level.m_46597_(growthPos, (BlockState)((BlockState)OreGrowth.ORE_GROWTH_BLOCK.m_49966_().m_61124_(FACE, (Comparable)side.m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(currentState.m_60819_().m_76152_() == Fluids.f_76193_)));
    }

    public OreGrowthBlock() {
        super(false, BlockProperties.create().lootTable(BuiltInLootTables.f_78712_).randomTicks().destroyTime(0.5f).explosionResistance(0.5f).sound(SoundType.f_56742_));
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)STAGE, (Comparable)Integer.valueOf(1))).m_61124_(FACE, (Comparable)Direction.DOWN)).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        Block base = level.m_8055_(pos.m_121945_((Direction)state.m_61143_(FACE))).m_60734_();
        OreGrowthRecipe recipe = OreGrowthRecipeManager.getRecipeFor(base);
        if (recipe == null) {
            level.m_46597_(pos, Blocks.f_50016_.m_49966_());
            return;
        }
        int stage = (Integer)state.m_61143_((Property)STAGE);
        if (stage < recipe.stages() && (double)random.m_188501_() < recipe.growthChance() * OreGrowthConfig.growthChanceScalar.get()) {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)STAGE, (Comparable)Integer.valueOf(stage + 1)));
        }
    }

    public List<ItemStack> m_49635_(BlockState state, LootParams.Builder builder) {
        Entity entity = (Entity)builder.m_287159_(LootContextParams.f_81455_);
        if (entity == null) {
            return Collections.emptyList();
        }
        Vec3 origin = (Vec3)builder.m_287261_(LootContextParams.f_81460_);
        BlockPos pos = new BlockPos((int)origin.f_82479_, (int)origin.f_82480_, (int)origin.f_82481_);
        return this.getDrops(state, entity.m_9236_(), pos);
    }

    public List<ItemStack> getDrops(BlockState state, Level level, BlockPos pos) {
        Direction facing = (Direction)state.m_61143_(FACE);
        Block base = level.m_8055_(pos.m_121945_(facing)).m_60734_();
        OreGrowthRecipe recipe = OreGrowthRecipeManager.getRecipeFor(base);
        return recipe != null && ((Integer)state.m_61143_((Property)STAGE)).intValue() == recipe.stages() ? List.of(recipe.output()) : Collections.emptyList();
    }

    public float m_5880_(BlockState state, Player player, BlockGetter level, BlockPos pos) {
        pos = pos.m_121945_((Direction)state.m_61143_(FACE));
        return level.m_8055_(pos).m_60625_(player, level, pos);
    }

    public SoundType getSoundType(BlockState state, LevelReader level, BlockPos pos, @Nullable Entity entity) {
        Direction facing = (Direction)state.m_61143_(FACE);
        Block base = level.m_8055_(pos.m_121945_(facing)).m_60734_();
        return base.getSoundType(state, level, pos, entity);
    }

    public boolean m_7278_(BlockState state) {
        return true;
    }

    public int m_6782_(BlockState state, Level level, BlockPos pos) {
        Block base = level.m_8055_(pos.m_121945_((Direction)state.m_61143_(FACE))).m_60734_();
        OreGrowthRecipe recipe = OreGrowthRecipeManager.getRecipeFor(base);
        if (recipe == null) {
            return 0;
        }
        int stage = (Integer)state.m_61143_((Property)STAGE);
        return (int)Math.floor((double)stage / (double)recipe.stages() * 15.0);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPES_ROTATED[((Integer)state.m_61143_((Property)STAGE) - 1) * 6 + ((Direction)state.m_61143_(FACE)).ordinal()].getUnderlying();
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{STAGE, FACE, WATERLOGGED});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState state = (BlockState)((BlockState)this.m_49966_().m_61124_(FACE, (Comparable)context.m_43719_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(context.m_43725_().m_6425_(context.m_8083_()).m_76152_() == Fluids.f_76193_));
        return this.m_7898_(state, (LevelReader)context.m_43725_(), context.m_8083_()) ? state : null;
    }

    public BlockState m_7417_(BlockState state, Direction neighborDirection, BlockState neighborState, LevelAccessor level, BlockPos pos, BlockPos neighborPos) {
        if (!this.m_7898_(state, (LevelReader)level, pos)) {
            return Blocks.f_50016_.m_49966_();
        }
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, neighborDirection, neighborState, level, pos, neighborPos);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        Direction facing = (Direction)state.m_61143_(FACE);
        return OreGrowthRecipeManager.getRecipeFor(level.m_8055_(pos.m_121945_(facing)).m_60734_()) != null;
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    static {
        for (int stage = 0; stage < 4; ++stage) {
            BlockShape shape = SHAPES[stage];
            for (Direction face : Direction.values()) {
                OreGrowthBlock.SHAPES_ROTATED[stage * 6 + face.ordinal()] = face == Direction.UP ? shape.rotate(Direction.Axis.X).rotate(Direction.Axis.X) : (face == Direction.NORTH ? shape.rotate(Direction.Axis.X).rotate(Direction.Axis.Y).rotate(Direction.Axis.Y) : (face == Direction.EAST ? shape.rotate(Direction.Axis.X).rotate(Direction.Axis.Y).rotate(Direction.Axis.Y).rotate(Direction.Axis.Y) : (face == Direction.SOUTH ? shape.rotate(Direction.Axis.X) : (face == Direction.WEST ? shape.rotate(Direction.Axis.X).rotate(Direction.Axis.Y) : shape))));
            }
        }
    }
}

