/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.oregrowth.compat;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.oregrowth.OreGrowth;
import com.supermartijn642.oregrowth.content.OreGrowthBlock;
import com.supermartijn642.oregrowth.content.OreGrowthBlockBakedModel;
import com.supermartijn642.oregrowth.content.OreGrowthRecipe;
import com.supermartijn642.oregrowth.content.OreGrowthRecipeManager;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.IWailaClientRegistration;
import snownee.jade.api.IWailaCommonRegistration;
import snownee.jade.api.IWailaPlugin;
import snownee.jade.api.Identifiers;
import snownee.jade.api.WailaPlugin;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.Element;
import snownee.jade.api.ui.IElement;

@WailaPlugin
public class OreGrowthWailaPlugin
implements IWailaPlugin {
    public void register(IWailaCommonRegistration registration) {
        super.register(registration);
    }

    public void registerClient(IWailaClientRegistration registration) {
        registration.registerBlockComponent(new IBlockComponentProvider(){

            public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
                Direction facing = (Direction)accessor.getBlockState().m_61143_(OreGrowthBlock.FACE);
                Block base = accessor.getLevel().m_8055_(accessor.getPosition().m_121945_(facing)).m_60734_();
                tooltip.remove(Identifiers.CORE_OBJECT_NAME);
                tooltip.add(0, (Component)IThemeHelper.get().title((Object)TextComponents.translation((String)"oregrowth.ore_growth_block.adjusted_name", (Object[])new Object[]{base.m_49954_()}).get()));
                OreGrowthRecipe recipe = OreGrowthRecipeManager.getRecipeFor(base);
                if (recipe != null) {
                    float growth = (float)((Integer)accessor.getBlockState().m_61143_((Property)OreGrowthBlock.STAGE)).intValue() / (float)recipe.stages() * 100.0f;
                    MutableComponent growthText = TextComponents.string((String)String.format("%.0f%%", Float.valueOf(growth))).color(growth < 100.0f ? ChatFormatting.WHITE : ChatFormatting.GREEN).get();
                    tooltip.add((Component)TextComponents.translation((String)"oregrowth.ore_growth_block.growth_hint", (Object[])new Object[]{growthText}).get());
                }
            }

            public ResourceLocation getUid() {
                return new ResourceLocation("oregrowth", "ore_growth_hint");
            }
        }, OreGrowthBlock.class);
        registration.registerBlockIcon(new IBlockComponentProvider(){

            @Nullable
            public IElement getIcon(BlockAccessor accessor, IPluginConfig config, final IElement currentIcon) {
                BlockState state = accessor.getBlockState();
                Direction facing = (Direction)state.m_61143_(OreGrowthBlock.FACE);
                final Block base = accessor.getLevel().m_8055_(accessor.getPosition().m_121945_(facing)).m_60734_();
                return new Element(){

                    public Vec2 getSize() {
                        return currentIcon.getSize();
                    }

                    public void render(GuiGraphics guiGraphics, float x, float y, float maxX, float maxY) {
                        BakedModel model = ClientUtils.getItemRenderer().m_115103_().m_109394_(OreGrowth.ORE_GROWTH_BLOCK.m_5456_());
                        if (model instanceof OreGrowthBlockBakedModel) {
                            ((OreGrowthBlockBakedModel)model).withContext(base, () -> currentIcon.render(guiGraphics, x, y, maxX, maxY));
                        } else {
                            currentIcon.render(guiGraphics, x, y, maxX, maxY);
                        }
                    }

                    @Nullable
                    public String getMessage() {
                        return currentIcon.getMessage();
                    }
                };
            }

            public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
            }

            public ResourceLocation getUid() {
                return new ResourceLocation("oregrowth", "ore_growth_icon");
            }
        }, OreGrowthBlock.class);
    }
}

