/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.oregrowth.compat;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.vertex.PoseStack;
import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.core.TextComponents;
import com.supermartijn642.oregrowth.OreGrowth;
import com.supermartijn642.oregrowth.compat.OreGrowthJEIPlugin;
import com.supermartijn642.oregrowth.content.OreGrowthBlock;
import com.supermartijn642.oregrowth.content.OreGrowthBlockBakedModel;
import com.supermartijn642.oregrowth.content.OreGrowthRecipe;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.runtime.IIngredientManager;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.ChunkRenderTypeSet;
import net.minecraftforge.client.model.data.ModelData;
import org.joml.Matrix4f;
import org.joml.Quaternionf;

public class OreGrowthJEIRecipeCategory
implements IRecipeCategory<OreGrowthRecipe> {
    private static final RandomSource RANDOM = RandomSource.m_216327_();
    private final IDrawable background;
    private final IDrawable icon;
    private final IIngredientManager ingredientManager;

    public OreGrowthJEIRecipeCategory(IGuiHelper guiHelper, IIngredientManager ingredientManager) {
        this.background = guiHelper.createDrawable(new ResourceLocation("oregrowth", "textures/screen/jei_category_background.png"), 0, 10, 93, 52);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)OreGrowth.ORE_GROWTH_BLOCK));
        this.ingredientManager = ingredientManager;
    }

    public RecipeType<OreGrowthRecipe> getRecipeType() {
        return OreGrowthJEIPlugin.ORE_GROWTH_RECIPE_TYPE;
    }

    public Component getTitle() {
        return TextComponents.translation((String)"oregrowth.jei_category.title").get();
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder layoutBuilder, OreGrowthRecipe recipe, IFocusGroup focusGroup) {
        final IIngredientRenderer originalRenderer = this.ingredientManager.getIngredientRenderer((IIngredientType)VanillaTypes.ITEM_STACK);
        ((IRecipeSlotBuilder)layoutBuilder.addSlot(RecipeIngredientRole.CATALYST, 2, 22).addItemStack(new ItemStack((ItemLike)recipe.base()))).setCustomRenderer((IIngredientType)VanillaTypes.ITEM_STACK, (IIngredientRenderer)new IIngredientRenderer<ItemStack>(){

            public void render(GuiGraphics guiGraphics, ItemStack stack) {
            }

            public List<Component> getTooltip(ItemStack stack, TooltipFlag flag) {
                return originalRenderer.getTooltip((Object)stack, flag);
            }

            public Font getFontRenderer(Minecraft minecraft, ItemStack ingredient) {
                return originalRenderer.getFontRenderer(minecraft, (Object)ingredient);
            }

            public int getWidth() {
                return 30;
            }

            public int getHeight() {
                return 30;
            }
        });
        layoutBuilder.addSlot(RecipeIngredientRole.OUTPUT, 75, 18).addItemStack(recipe.output());
    }

    public void draw(OreGrowthRecipe recipe, IRecipeSlotsView slotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        guiGraphics.m_280203_(Items.f_42390_.m_7968_(), 43, 16);
        OreGrowthJEIRecipeCategory.renderModel(guiGraphics, recipe.base().m_49966_(), 9, 29, 0, ModelData.EMPTY);
        int stage = (int)(System.currentTimeMillis() / 1200L % (long)recipe.stages() + 1L);
        BlockState state = (BlockState)OreGrowth.ORE_GROWTH_BLOCK.m_49966_().m_61124_((Property)OreGrowthBlock.STAGE, (Comparable)Integer.valueOf(stage));
        ModelData modelData = ModelData.builder().with(OreGrowthBlockBakedModel.BASE_BLOCK_PROPERTY, (Object)recipe.base()).build();
        OreGrowthJEIRecipeCategory.renderModel(guiGraphics, state, 9, 13, 10, modelData);
    }

    private static void renderModel(GuiGraphics guiGraphics, BlockState state, int x, int y, int offset, ModelData modelData) {
        boolean blockLight;
        PoseStack poseStack = guiGraphics.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_((float)(x + 8), (float)(y + 8), (float)(150 + offset));
        poseStack.m_85841_(1.85f, 1.85f, 1.85f);
        poseStack.m_252931_(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
        poseStack.m_85841_(16.0f, 16.0f, 16.0f);
        BakedModel model = ClientUtils.getBlockRenderer().m_110910_(state);
        boolean bl = blockLight = !model.m_7547_();
        if (blockLight) {
            Lighting.m_84930_();
        }
        poseStack.m_252781_(new Quaternionf().rotationXYZ(0.5235988f, 3.9269907f, 0.0f));
        poseStack.m_85841_(0.625f, 0.625f, 0.625f);
        poseStack.m_252880_(-0.5f, -0.5f, -0.5f);
        RANDOM.m_188584_(42L);
        ChunkRenderTypeSet renderTypes = model.getRenderTypes(state, RANDOM, modelData);
        RenderType renderType = renderTypes.contains(RenderType.m_110466_()) ? Sheets.m_110792_() : Sheets.m_110790_();
        ClientUtils.getBlockRenderer().renderSingleBlock(state, poseStack, (MultiBufferSource)guiGraphics.m_280091_(), 0xF000F0, OverlayTexture.f_118083_, modelData, renderType);
        guiGraphics.m_280262_();
        if (blockLight) {
            Lighting.m_84931_();
        }
        poseStack.m_85849_();
    }
}

