/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.oregrowth;

import com.supermartijn642.core.CommonUtils;
import com.supermartijn642.core.data.condition.ResourceConditionSerializer;
import com.supermartijn642.core.item.BaseBlockItem;
import com.supermartijn642.core.item.CreativeItemGroup;
import com.supermartijn642.core.item.ItemProperties;
import com.supermartijn642.core.registry.GeneratorRegistrationHandler;
import com.supermartijn642.core.registry.RegistrationHandler;
import com.supermartijn642.oregrowth.OreGrowthClient;
import com.supermartijn642.oregrowth.OreGrowthConfig;
import com.supermartijn642.oregrowth.compat.OreGrowthTOPPlugin;
import com.supermartijn642.oregrowth.content.OreGrowthBlock;
import com.supermartijn642.oregrowth.content.OreGrowthDefaultRecipeCondition;
import com.supermartijn642.oregrowth.content.OreGrowthRecipe;
import com.supermartijn642.oregrowth.generators.OreGrowthBlockStateGenerator;
import com.supermartijn642.oregrowth.generators.OreGrowthLanguageGenerator;
import com.supermartijn642.oregrowth.generators.OreGrowthModelGenerator;
import com.supermartijn642.oregrowth.generators.OreGrowthOreGrowthRecipeGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

@Mod(value="oregrowth")
public class OreGrowth {
    public static final String MODID = "oregrowth";
    public static RecipeType<OreGrowthRecipe> ORE_GROWTH_RECIPE_TYPE;
    public static OreGrowthBlock ORE_GROWTH_BLOCK;
    public static BaseBlockItem ORE_GROWTH_ITEM;

    public OreGrowth() {
        OreGrowthConfig.init();
        OreGrowth.register();
        if (CommonUtils.getEnvironmentSide().isClient()) {
            OreGrowthClient.initializeClient();
        }
        OreGrowth.registerGenerators();
        if (CommonUtils.isModLoaded((String)"theoneprobe")) {
            FMLJavaModLoadingContext.get().getModEventBus().addListener(event -> InterModComms.sendTo((String)"theoneprobe", (String)"getTheOneProbe", OreGrowthTOPPlugin::new));
        }
    }

    private static void register() {
        RegistrationHandler handler = RegistrationHandler.get((String)MODID);
        handler.registerRecipeSerializer("ore_growth", () -> OreGrowthRecipe.SERIALIZER);
        handler.registerBlock("ore_growth", () -> {
            ORE_GROWTH_BLOCK = new OreGrowthBlock();
            return ORE_GROWTH_BLOCK;
        });
        handler.registerItem("ore_growth", () -> {
            ORE_GROWTH_ITEM = new BaseBlockItem((Block)ORE_GROWTH_BLOCK, ItemProperties.create().group(CreativeItemGroup.getNaturalBlocks()));
            return ORE_GROWTH_ITEM;
        });
        handler.registerRecipeType("ore_growth", () -> {
            ORE_GROWTH_RECIPE_TYPE = RecipeType.simple((ResourceLocation)new ResourceLocation(MODID, "ore_growth"));
            return ORE_GROWTH_RECIPE_TYPE;
        });
        handler.registerResourceConditionSerializer("default_recipes", (ResourceConditionSerializer)OreGrowthDefaultRecipeCondition.SERIALIZER);
    }

    public static void registerGenerators() {
        GeneratorRegistrationHandler handler = GeneratorRegistrationHandler.get((String)MODID);
        handler.addGenerator(OreGrowthBlockStateGenerator::new);
        handler.addGenerator(OreGrowthLanguageGenerator::new);
        handler.addGenerator(OreGrowthModelGenerator::new);
        handler.addGenerator(OreGrowthOreGrowthRecipeGenerator::new);
    }
}

