/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.skinlayers.renderlayers;

import com.google.common.collect.Sets;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.tr7zw.skinlayers.SkinLayersModBase;
import dev.tr7zw.skinlayers.SkinUtil;
import dev.tr7zw.skinlayers.accessor.PlayerEntityModelAccessor;
import dev.tr7zw.skinlayers.accessor.PlayerSettings;
import dev.tr7zw.skinlayers.api.LayerFeatureTransformerAPI;
import dev.tr7zw.skinlayers.api.Mesh;
import dev.tr7zw.skinlayers.api.PlayerData;
import dev.tr7zw.skinlayers.versionless.util.wrapper.SolidPixelWrapper;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.PlayerModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.PlayerModelPart;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;

public class CustomLayerFeatureRenderer
extends RenderLayer<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> {
    private static final Minecraft mc = Minecraft.m_91087_();
    private final Set<Item> hideHeadLayers = Sets.newHashSet((Object[])new Item[]{Items.f_42681_, Items.f_42682_, Items.f_42683_, Items.f_42678_, Items.f_42679_});
    private final List<Layer> bodyLayers = new ArrayList<Layer>();
    private final boolean thinArms = ((PlayerEntityModelAccessor)this.m_117386_()).hasThinArms();

    public CustomLayerFeatureRenderer(RenderLayerParent<AbstractClientPlayer, PlayerModel<AbstractClientPlayer>> renderLayerParent) {
        super(renderLayerParent);
        this.bodyLayers.add(new Layer(PlayerData::getHeadMesh, false, PlayerModelPart.HAT, Shape.HEAD, () -> ((PlayerModel)this.m_117386_()).f_102808_, player -> {
            ItemStack itemStack = player.m_6844_(EquipmentSlot.HEAD);
            if (itemStack != null && this.hideHeadLayers.contains(itemStack.m_41720_())) {
                return false;
            }
            return SkinLayersModBase.config.enableHat;
        }));
        this.bodyLayers.add(new Layer(PlayerData::getLeftLegMesh, false, PlayerModelPart.LEFT_PANTS_LEG, Shape.LEGS, () -> ((PlayerModel)this.m_117386_()).f_102814_, player -> SkinLayersModBase.config.enableLeftPants));
        this.bodyLayers.add(new Layer(PlayerData::getRightLegMesh, false, PlayerModelPart.RIGHT_PANTS_LEG, Shape.LEGS, () -> ((PlayerModel)this.m_117386_()).f_102813_, player -> SkinLayersModBase.config.enableRightPants));
        this.bodyLayers.add(new Layer(PlayerData::getLeftArmMesh, false, PlayerModelPart.LEFT_SLEEVE, this.thinArms ? Shape.ARMS_SLIM : Shape.ARMS, () -> ((PlayerModel)this.m_117386_()).f_102812_, player -> SkinLayersModBase.config.enableLeftSleeve));
        this.bodyLayers.add(new Layer(PlayerData::getRightArmMesh, true, PlayerModelPart.RIGHT_SLEEVE, this.thinArms ? Shape.ARMS_SLIM : Shape.ARMS, () -> ((PlayerModel)this.m_117386_()).f_102811_, player -> SkinLayersModBase.config.enableRightSleeve));
        this.bodyLayers.add(new Layer(PlayerData::getTorsoMesh, false, PlayerModelPart.JACKET, Shape.BODY, () -> ((PlayerModel)this.m_117386_()).f_102810_, player -> SkinLayersModBase.config.enableJacket));
    }

    public void render(PoseStack poseStack, MultiBufferSource multiBufferSource, int i, AbstractClientPlayer player, float f, float g, float h, float j, float k, float l) {
        if (player.m_20145_()) {
            return;
        }
        if (CustomLayerFeatureRenderer.mc.f_91073_ == null) {
            return;
        }
        if (CustomLayerFeatureRenderer.mc.f_91074_.m_20280_((Entity)player) > (double)(SkinLayersModBase.config.renderDistanceLOD * SkinLayersModBase.config.renderDistanceLOD)) {
            return;
        }
        PlayerSettings settings = (PlayerSettings)player;
        if (!SkinUtil.setup3dLayers(player, settings, this.thinArms, (PlayerModel<AbstractClientPlayer>)((PlayerModel)this.m_117386_()))) {
            return;
        }
        VertexConsumer vertexConsumer = multiBufferSource.m_6299_(RenderType.m_110454_((ResourceLocation)player.m_294544_().f_290339_(), (boolean)true));
        int m = LivingEntityRenderer.m_115338_((LivingEntity)player, (float)0.0f);
        this.renderLayers(player, settings, poseStack, vertexConsumer, i, m);
    }

    public void renderLayers(AbstractClientPlayer abstractClientPlayer, PlayerSettings settings, PoseStack matrixStack, VertexConsumer vertices, int light, int overlay) {
        float pixelScaling = SkinLayersModBase.config.baseVoxelSize;
        float heightScaling = 1.035f;
        float widthScaling = SkinLayersModBase.config.baseVoxelSize;
        for (Layer layer : this.bodyLayers) {
            Mesh mesh = layer.meshGetter.apply(settings);
            if (mesh == null || !abstractClientPlayer.m_36170_(layer.modelPart) || !layer.vanillaGetter.get().f_104207_ || !layer.configGetter.apply(abstractClientPlayer).booleanValue()) continue;
            matrixStack.m_85836_();
            LayerFeatureTransformerAPI.getTransformer().transform(abstractClientPlayer, matrixStack, layer.vanillaGetter.get());
            layer.vanillaGetter.get().m_104299_(matrixStack);
            float x = 0.0f;
            float y = 0.0f;
            if (layer.shape == Shape.ARMS) {
                x = 0.998f;
            } else if (layer.shape == Shape.ARMS_SLIM) {
                x = 0.499f;
            }
            if (layer.shape == Shape.BODY) {
                widthScaling = SkinLayersModBase.config.bodyVoxelWidthSize;
            }
            if (layer.mirrored) {
                x *= -1.0f;
            }
            if (layer.shape == Shape.HEAD) {
                float voxelSize = SkinLayersModBase.config.headVoxelSize;
                matrixStack.m_85837_(0.0, -0.25, 0.0);
                matrixStack.m_85841_(voxelSize, voxelSize, voxelSize);
                matrixStack.m_85837_(0.0, 0.25, 0.0);
                matrixStack.m_85837_(0.0, -0.04, 0.0);
            } else {
                matrixStack.m_85841_(widthScaling, heightScaling, pixelScaling);
                y = layer.shape.yOffsetMagicValue;
            }
            mesh.setPosition(x, y, 0.0f);
            mesh.render(layer.vanillaGetter.get(), matrixStack, vertices, light, overlay, 1.0f, 1.0f, 1.0f, 1.0f);
            matrixStack.m_85849_();
        }
    }

    private static class Layer {
        private final Function<PlayerSettings, Mesh> meshGetter;
        private final boolean mirrored;
        private final PlayerModelPart modelPart;
        private final Shape shape;
        private final Supplier<ModelPart> vanillaGetter;
        private final Function<AbstractClientPlayer, Boolean> configGetter;

        public Layer(Function<PlayerSettings, Mesh> meshGetter, boolean mirrored, PlayerModelPart modelPart, Shape shape, Supplier<ModelPart> vanillaGetter, Function<AbstractClientPlayer, Boolean> configGetter) {
            this.meshGetter = meshGetter;
            this.mirrored = mirrored;
            this.modelPart = modelPart;
            this.shape = shape;
            this.vanillaGetter = vanillaGetter;
            this.configGetter = configGetter;
        }
    }

    private static enum Shape {
        HEAD(0.0f, new SolidPixelWrapper.Dimensions(8, 8, 8)),
        BODY(-0.2f, new SolidPixelWrapper.Dimensions(8, 12, 4)),
        LEGS(-0.2f, new SolidPixelWrapper.Dimensions(4, 14, 4)),
        ARMS(-0.1f, new SolidPixelWrapper.Dimensions(4, 14, 4)),
        ARMS_SLIM(-0.1f, new SolidPixelWrapper.Dimensions(3, 14, 4));

        private final float yOffsetMagicValue;
        private final SolidPixelWrapper.Dimensions dimensions;

        private Shape(float yOffsetMagicValue, SolidPixelWrapper.Dimensions dimensions) {
            this.dimensions = dimensions;
            this.yOffsetMagicValue = yOffsetMagicValue;
        }
    }
}

