/*
 * Decompiled with CFR 0.152.
 */
package fuzs.visualworkbench.handler;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import fuzs.puzzleslib.api.block.v1.BlockConversionHelper;
import fuzs.puzzleslib.api.event.v1.core.EventResultHolder;
import fuzs.puzzleslib.api.init.v3.registry.RegistryHelper;
import fuzs.visualworkbench.VisualWorkbench;
import fuzs.visualworkbench.config.ServerConfig;
import fuzs.visualworkbench.init.ModRegistry;
import fuzs.visualworkbench.world.level.block.CraftingTableWithInventoryBlock;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CraftingTableBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

public class BlockConversionHandler {
    public static final Component INVALID_BLOCK_COMPONENT = Component.m_237115_((String)"container.invalidBlock");
    public static final BiMap<Block, Block> BLOCK_CONVERSIONS = HashBiMap.create();

    public static void onRegistryEntryAdded(Registry<Block> registry, ResourceLocation id, Block block, BiConsumer<ResourceLocation, Supplier<Block>> registrar) {
        if (block instanceof CraftingTableBlock) {
            ResourceLocation resourceLocation = VisualWorkbench.id(id.m_135827_() + "/" + id.m_135815_());
            registrar.accept(resourceLocation, () -> {
                CraftingTableWithInventoryBlock newBlock = new CraftingTableWithInventoryBlock(block);
                BLOCK_CONVERSIONS.put((Object)block, (Object)newBlock);
                return newBlock;
            });
        }
    }

    public static EventResultHolder<InteractionResult> onUseBlock(Player player, Level level, InteractionHand interactionHand, BlockHitResult hitResult) {
        if (!((ServerConfig)VisualWorkbench.CONFIG.get(ServerConfig.class)).disableVanillaWorkbench) {
            return EventResultHolder.pass();
        }
        BlockState blockState = level.m_8055_(hitResult.m_82425_());
        if (BLOCK_CONVERSIONS.containsKey((Object)blockState.m_60734_()) && !blockState.m_204336_(ModRegistry.UNALTERED_WORKBENCHES_BLOCK_TAG)) {
            player.m_5661_((Component)Component.m_237119_().m_7220_(INVALID_BLOCK_COMPONENT).m_130940_(ChatFormatting.RED), true);
            return EventResultHolder.interrupt((Object)InteractionResult.m_19078_((boolean)level.f_46443_));
        }
        return EventResultHolder.pass();
    }

    public static void onTagsUpdated(RegistryAccess registryAccess, boolean client) {
        for (Map.Entry entry : BuiltInRegistries.f_257033_.m_6579_()) {
            Object v = entry.getValue();
            if (!(v instanceof BlockItem)) continue;
            BlockItem blockItem = (BlockItem)v;
            Block block = blockItem.m_40614_();
            BlockConversionHandler.setItemForBlock(((ResourceKey)entry.getKey()).m_135782_(), blockItem, block);
            BlockConversionHandler.setBlockForItem(blockItem, block);
        }
        BlockConversionHandler.copyBoundTags();
    }

    private static void setItemForBlock(ResourceLocation resourceLocation, BlockItem blockItem, Block block) {
        if (block instanceof CraftingTableBlock) {
            BlockConversionHelper.setItemForBlock((Block)((Block)BLOCK_CONVERSIONS.get((Object)block)), (Item)blockItem);
        }
    }

    private static void setBlockForItem(BlockItem blockItem, Block block) {
        Block baseBlock;
        Block diagonalBlock = (Block)BLOCK_CONVERSIONS.get((Object)block);
        if (diagonalBlock != null) {
            baseBlock = block;
        } else {
            baseBlock = (Block)BLOCK_CONVERSIONS.inverse().get((Object)block);
            if (baseBlock != null) {
                diagonalBlock = block;
            } else {
                return;
            }
        }
        if (RegistryHelper.is(ModRegistry.UNALTERED_WORKBENCHES_BLOCK_TAG, (Object)baseBlock)) {
            BlockConversionHelper.setBlockForItem((BlockItem)blockItem, (Block)baseBlock);
        } else {
            BlockConversionHelper.setBlockForItem((BlockItem)blockItem, (Block)diagonalBlock);
        }
    }

    private static void copyBoundTags() {
        BLOCK_CONVERSIONS.forEach(BlockConversionHelper::copyBoundTags);
    }
}

